/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.ur.swing.resources.ImageResource;
import com.ur.util.logging.Log;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;

public final class QRCodeGenerator {
    static final int DEFAULT_WIDTH = 375;
    static final int DEFAULT_HEIGHT = 375;

    private QRCodeGenerator() {
    }

    public static BufferedImage getQRCode(String url) {
        return QRCodeGenerator.getQRCode(url, 375, 375);
    }

    public static BufferedImage getQRCode(String url, int width, int height) {
        BitMatrix bitMatrix = QRCodeGenerator.generateQrCode(url, width, height);
        assert (bitMatrix != null) : "QRCodeGenerator: getQRCode bitMatrix is null";
        BufferedImage bufferedImage = QRCodeGenerator.bitMatrixToBitMap(bitMatrix);
        return QRCodeGenerator.addURIconOverlay(bufferedImage);
    }

    static BitMatrix generateQrCode(String url, int width, int height) {
        try {
            QRCodeWriter qrWriter = new QRCodeWriter();
            HashMap<EncodeHintType, ErrorCorrectionLevel> errorCorrection = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
            errorCorrection.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            return qrWriter.encode(url, BarcodeFormat.QR_CODE, width, height, errorCorrection);
        }
        catch (WriterException e) {
            Log.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static BufferedImage bitMatrixToBitMap(BitMatrix bitMatrix) {
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage bufferedImage = new BufferedImage(width, height, 10);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                bufferedImage.setRGB(x, y, bitMatrix.get(x, y) ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                ++y;
            }
            ++x;
        }
        return bufferedImage;
    }

    private static BufferedImage addURIconOverlay(BufferedImage inputImage) {
        BufferedImage urLogo = QRCodeGenerator.createURLogo();
        int width = inputImage.getWidth();
        int height = inputImage.getHeight();
        int deltaHeight = height - ((Image)urLogo).getHeight(null);
        int deltaWidth = width - ((Image)urLogo).getWidth(null);
        BufferedImage combined = new BufferedImage(width, height, 2);
        Graphics2D g = combined.createGraphics();
        g.drawImage((Image)inputImage, 0, 0, null);
        g.setComposite(AlphaComposite.SrcOver);
        g.drawImage((Image)urLogo, deltaWidth / 2, deltaHeight / 2, null);
        return combined;
    }

    private static BufferedImage createURLogo() {
        Image urIcon = ((ImageIcon)ImageResource.urIcon()).getImage();
        int iconWidth = urIcon.getWidth(null);
        int iconHeight = urIcon.getHeight(null);
        BufferedImage urLogo = new BufferedImage(iconWidth + 6, iconHeight + 6, 2);
        Graphics2D g = urLogo.createGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, urLogo.getWidth(), urLogo.getHeight());
        g.setComposite(AlphaComposite.SrcOver);
        g.drawImage(urIcon, 3, 3, null);
        return urLogo;
    }
}

