/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.resources;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ButtonImageResource {
    private static boolean isG5 = true;

    static {
        if (isG5) {
            ButtonImageResource.tryGetImage("keyboard.png");
            ButtonImageResource.tryGetImage("up_arrow.png");
            ButtonImageResource.tryGetImage("scroll_right.png");
            ButtonImageResource.tryGetImage("toggle_on.png");
            ButtonImageResource.tryGetImage("escape.png");
            ButtonImageResource.tryGetImage("shift.png");
            ButtonImageResource.tryGetImage("toggle_off.png");
            ButtonImageResource.tryGetImage("down_arrow.png");
            ButtonImageResource.tryGetImage("backspace.png");
            ButtonImageResource.tryGetImage("submit.png");
            ButtonImageResource.tryGetImage("gtk-remove.png");
            ButtonImageResource.tryGetImage("left_arrow.png");
            ButtonImageResource.tryGetImage("right_arrow.png");
            ButtonImageResource.tryGetImage("scroll_left.png");
            ButtonImageResource.tryGetImage("toggle_off_gray.png");
            ButtonImageResource.tryGetImage("scroll_up.png");
            ButtonImageResource.tryGetImage("gtk-add.png");
            ButtonImageResource.tryGetImage("scroll_down.png");
        }
    }

    private ButtonImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/buttons/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="keyboard.png")
    public static @Key(value="keyboard.png") Icon keyboard() {
        return ButtonImageResource.tryGetImage("keyboard.png");
    }

    @Key(value="up_arrow.png")
    public static @Key(value="up_arrow.png") Icon upArrow() {
        return ButtonImageResource.tryGetImage("up_arrow.png");
    }

    @Key(value="scroll_right.png")
    public static @Key(value="scroll_right.png") Icon scrollRight() {
        return ButtonImageResource.tryGetImage("scroll_right.png");
    }

    @Key(value="toggle_on.png")
    public static @Key(value="toggle_on.png") Icon toggleOn() {
        return ButtonImageResource.tryGetImage("toggle_on.png");
    }

    @Key(value="escape.png")
    public static @Key(value="escape.png") Icon escape() {
        return ButtonImageResource.tryGetImage("escape.png");
    }

    @Key(value="shift.png")
    public static @Key(value="shift.png") Icon shift() {
        return ButtonImageResource.tryGetImage("shift.png");
    }

    @Key(value="toggle_off.png")
    public static @Key(value="toggle_off.png") Icon toggleOff() {
        return ButtonImageResource.tryGetImage("toggle_off.png");
    }

    @Key(value="down_arrow.png")
    public static @Key(value="down_arrow.png") Icon downArrow() {
        return ButtonImageResource.tryGetImage("down_arrow.png");
    }

    @Key(value="backspace.png")
    public static @Key(value="backspace.png") Icon backspace() {
        return ButtonImageResource.tryGetImage("backspace.png");
    }

    @Key(value="submit.png")
    public static @Key(value="submit.png") Icon submit() {
        return ButtonImageResource.tryGetImage("submit.png");
    }

    @Key(value="gtk-remove.png")
    public static @Key(value="gtk-remove.png") Icon gtkRemove() {
        return ButtonImageResource.tryGetImage("gtk-remove.png");
    }

    @Key(value="left_arrow.png")
    public static @Key(value="left_arrow.png") Icon leftArrow() {
        return ButtonImageResource.tryGetImage("left_arrow.png");
    }

    @Key(value="right_arrow.png")
    public static @Key(value="right_arrow.png") Icon rightArrow() {
        return ButtonImageResource.tryGetImage("right_arrow.png");
    }

    @Key(value="scroll_left.png")
    public static @Key(value="scroll_left.png") Icon scrollLeft() {
        return ButtonImageResource.tryGetImage("scroll_left.png");
    }

    @Key(value="toggle_off_gray.png")
    public static @Key(value="toggle_off_gray.png") Icon toggleOffGray() {
        return ButtonImageResource.tryGetImage("toggle_off_gray.png");
    }

    @Key(value="scroll_up.png")
    public static @Key(value="scroll_up.png") Icon scrollUp() {
        return ButtonImageResource.tryGetImage("scroll_up.png");
    }

    @Key(value="gtk-add.png")
    public static @Key(value="gtk-add.png") Icon gtkAdd() {
        return ButtonImageResource.tryGetImage("gtk-add.png");
    }

    @Key(value="scroll_down.png")
    public static @Key(value="scroll_down.png") Icon scrollDown() {
        return ButtonImageResource.tryGetImage("scroll_down.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return ButtonImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = String.valueOf(path) + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

