/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.resources;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageResource {
    private static boolean isG5 = true;

    static {
        if (isG5) {
            ImageResource.tryGetImage("gtk-go-back-ltr.png");
            ImageResource.tryGetImage("checkbox-checked.png");
            ImageResource.tryGetImage("slider.png");
            ImageResource.tryGetImage("disabled-slider.png");
            ImageResource.tryGetImage("navigation-item-selected.png");
            ImageResource.tryGetImage("rb.gif");
            ImageResource.tryGetImage("menu-collapse.png");
            ImageResource.tryGetImage("urIcon.png");
            ImageResource.tryGetImage("navigation-item-unselected.png");
            ImageResource.tryGetImage("collapsedbreakpoint.png");
            ImageResource.tryGetImage("gtk-cancel.png");
            ImageResource.tryGetImage("radioUnselected.png");
            ImageResource.tryGetImage("gtk-ok.png");
            ImageResource.tryGetImage("gtk-go-back-rtl.png");
            ImageResource.tryGetImage("rbp.gif");
            ImageResource.tryGetImage("cancel.png");
            ImageResource.tryGetImage("rbs.gif");
            ImageResource.tryGetImage("checkbox.png");
            ImageResource.tryGetImage("enter.png");
            ImageResource.tryGetImage("menu-expand.png");
            ImageResource.tryGetImage("approve.png");
            ImageResource.tryGetImage("radioSelected.png");
            ImageResource.tryGetImage("form-error.png");
        }
    }

    private ImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/icons/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="gtk-go-back-ltr.png")
    public static @Key(value="gtk-go-back-ltr.png") Icon gtkGoBackLtr() {
        return ImageResource.tryGetImage("gtk-go-back-ltr.png");
    }

    @Key(value="checkbox-checked.png")
    public static @Key(value="checkbox-checked.png") Icon checkboxChecked() {
        return ImageResource.tryGetImage("checkbox-checked.png");
    }

    @Key(value="slider.png")
    public static @Key(value="slider.png") Icon slider() {
        return ImageResource.tryGetImage("slider.png");
    }

    @Key(value="disabled-slider.png")
    public static @Key(value="disabled-slider.png") Icon disabledSlider() {
        return ImageResource.tryGetImage("disabled-slider.png");
    }

    @Key(value="navigation-item-selected.png")
    public static @Key(value="navigation-item-selected.png") Icon navigationItemSelected() {
        return ImageResource.tryGetImage("navigation-item-selected.png");
    }

    @Key(value="rb.gif")
    public static @Key(value="rb.gif") Icon rb() {
        return ImageResource.tryGetImage("rb.gif");
    }

    @Key(value="menu-collapse.png")
    public static @Key(value="menu-collapse.png") Icon menuCollapse() {
        return ImageResource.tryGetImage("menu-collapse.png");
    }

    @Key(value="urIcon.png")
    public static @Key(value="urIcon.png") Icon urIcon() {
        return ImageResource.tryGetImage("urIcon.png");
    }

    @Key(value="navigation-item-unselected.png")
    public static @Key(value="navigation-item-unselected.png") Icon navigationItemUnselected() {
        return ImageResource.tryGetImage("navigation-item-unselected.png");
    }

    @Key(value="collapsedbreakpoint.png")
    public static @Key(value="collapsedbreakpoint.png") Icon collapsedbreakpoint() {
        return ImageResource.tryGetImage("collapsedbreakpoint.png");
    }

    @Key(value="gtk-cancel.png")
    public static @Key(value="gtk-cancel.png") Icon gtkCancel() {
        return ImageResource.tryGetImage("gtk-cancel.png");
    }

    @Key(value="radioUnselected.png")
    public static @Key(value="radioUnselected.png") Icon radioUnselected() {
        return ImageResource.tryGetImage("radioUnselected.png");
    }

    @Key(value="gtk-ok.png")
    public static @Key(value="gtk-ok.png") Icon gtkOk() {
        return ImageResource.tryGetImage("gtk-ok.png");
    }

    @Key(value="gtk-go-back-rtl.png")
    public static @Key(value="gtk-go-back-rtl.png") Icon gtkGoBackRtl() {
        return ImageResource.tryGetImage("gtk-go-back-rtl.png");
    }

    @Key(value="rbp.gif")
    public static @Key(value="rbp.gif") Icon rbp() {
        return ImageResource.tryGetImage("rbp.gif");
    }

    @Key(value="cancel.png")
    public static @Key(value="cancel.png") Icon cancel() {
        return ImageResource.tryGetImage("cancel.png");
    }

    @Key(value="rbs.gif")
    public static @Key(value="rbs.gif") Icon rbs() {
        return ImageResource.tryGetImage("rbs.gif");
    }

    @Key(value="checkbox.png")
    public static @Key(value="checkbox.png") Icon checkbox() {
        return ImageResource.tryGetImage("checkbox.png");
    }

    @Key(value="enter.png")
    public static @Key(value="enter.png") Icon enter() {
        return ImageResource.tryGetImage("enter.png");
    }

    @Key(value="menu-expand.png")
    public static @Key(value="menu-expand.png") Icon menuExpand() {
        return ImageResource.tryGetImage("menu-expand.png");
    }

    @Key(value="approve.png")
    public static @Key(value="approve.png") Icon approve() {
        return ImageResource.tryGetImage("approve.png");
    }

    @Key(value="radioSelected.png")
    public static @Key(value="radioSelected.png") Icon radioSelected() {
        return ImageResource.tryGetImage("radioSelected.png");
    }

    @Key(value="form-error.png")
    public static @Key(value="form-error.png") Icon formError() {
        return ImageResource.tryGetImage("form-error.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return ImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = String.valueOf(path) + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

