/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.taskprogress;

import com.ur.swing.GuiUtilities;
import com.ur.swing.JFrameUtils;
import com.ur.swing.SwingUtil;
import com.ur.swing.dialog.HiddenLegacyDialog;
import com.ur.swing.taskprogress.ProgressBarDialog;
import com.ur.swing.taskprogress.ProgressBarPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;

@Singleton
public class ProgressBarDialogImpl
extends JDialog
implements ProgressBarDialog {
    private static final int DELAY_TIME = 1000;
    private static final String PROGRESS_BAR_NAME = "URDialogCreator.progressBarName";
    private final List<TitleAndButton> labels = Collections.synchronizedList(new ArrayList());
    private Timer showDialogTimer = new Timer(0, null);
    private ActionListener delayedShowActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ProgressBarDialogImpl.this.showDialogUsingTimer();
        }
    };
    private JLabel jLabelTitle;
    private int delayTime;
    private ActionListener cancelListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    private final ProgressBarPanel progressBarPanel = new ProgressBarPanel(new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ProgressBarDialogImpl.this.doHideDialog();
            ProgressBarDialogImpl.this.cancelListener.actionPerformed(e);
        }
    });
    private final ProgressBarPopupShowingListener progressBarPopupShowingListener = new ProgressBarPopupShowingListener();

    @Inject
    public ProgressBarDialogImpl() {
        this(1000);
    }

    public ProgressBarDialogImpl(int delayTime) {
        super(JFrameUtils.getActiveOrNullFrame());
        this.delayTime = delayTime;
        this.initComponent();
    }

    private void initComponent() {
        this.setName(PROGRESS_BAR_NAME);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.addWindowListener(this.progressBarPopupShowingListener);
        this.getContentPane().add(this.createDialogContent(this.progressBarPanel));
    }

    private JPanel createDialogContent(JComponent panel) {
        JPanel result = new JPanel();
        JPanel titlePanel = new JPanel();
        JPanel innerPanel = new JPanel();
        JPanel messagePanel = new JPanel();
        LineBorder b1 = new LineBorder(new Color(0.0f, 0.0f, 0.0f), 1);
        BevelBorder b2 = new BevelBorder(0);
        result.setBorder(new CompoundBorder(b1, b2));
        result.setLayout(new BorderLayout());
        result.add((Component)titlePanel, "North");
        result.add((Component)innerPanel, "Center");
        innerPanel.setLayout(new BorderLayout());
        innerPanel.add((Component)messagePanel, "Center");
        titlePanel.setLayout(new FlowLayout(1));
        EtchedBorder titleBorder = new EtchedBorder(1);
        titlePanel.setBackground(new Color(67, 136, 201));
        titlePanel.setBorder(titleBorder);
        this.jLabelTitle = new JLabel(" ");
        this.jLabelTitle.setFont(new Font("Dialog", 1, 13));
        this.jLabelTitle.setForeground(new Color(255, 255, 255));
        titlePanel.add(this.jLabelTitle);
        messagePanel.add(panel);
        return result;
    }

    @Override
    public void addMaxProgress(final int progressTicks) {
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ProgressBarDialogImpl.this.progressBarPanel.addMaxProgress(progressTicks);
            }
        });
    }

    @Override
    public void addProgress(final int progressTicks) {
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ProgressBarDialogImpl.this.progressBarPanel.addProgress(progressTicks);
            }
        });
    }

    @Override
    public void increaseProgress() {
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ProgressBarDialogImpl.this.progressBarPanel.increaseProgress();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTitle(String title, int totalProgressTicks, boolean showCancelButton) {
        boolean resetProgress;
        List<TitleAndButton> list = this.labels;
        synchronized (list) {
            resetProgress = this.labels.isEmpty();
            this.labels.add(new TitleAndButton(title, showCancelButton));
        }
        if (resetProgress) {
            this.resetAndAddMaxProgress(totalProgressTicks);
        } else {
            this.addMaxProgress(totalProgressTicks);
        }
    }

    private void resetAndAddMaxProgress(final int totalProgressTicks) {
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ProgressBarDialogImpl.this.progressBarPanel.resetProgress();
                ProgressBarDialogImpl.this.progressBarPanel.addMaxProgress(totalProgressTicks);
            }
        });
    }

    @Override
    public void showTitle(String title) {
        TitleAndButton label = this.getLabelByTitle(title);
        this.updateDialog(label.title, label.showCancelButton);
        this.delayedShowDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TitleAndButton getLabelByTitle(String title) {
        List<TitleAndButton> list = this.labels;
        synchronized (list) {
            for (TitleAndButton label : this.labels) {
                if (!label.title.equals(title)) continue;
                return label;
            }
        }
        return new TitleAndButton("", false);
    }

    private void delayedShowDialog() {
        if (!this.doingDelayedShow()) {
            this.doDelayedShow(this.delayTime);
        }
    }

    private void updateDialog(final String title, final boolean showCancelButton) {
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ProgressBarDialogImpl.this.doUpdateDialog(title, showCancelButton);
            }
        });
    }

    private void doUpdateDialog(String title, boolean showCancelButton) {
        this.jLabelTitle.setText(String.valueOf(title) + " ");
        this.progressBarPanel.setCancelButtonVisible(showCancelButton);
        this.pack();
        ProgressBarDialogImpl.setButtonFocus(this);
        JFrameUtils.moveToCenter(this, 0, false);
        this.validate();
        this.repaint();
    }

    @Override
    public void removeTitle(String title) {
        this.removeLabel(title);
        TitleAndButton lastLabel = this.getLastLabel();
        if (lastLabel != null) {
            if (this.isVisible()) {
                this.updateDialog(lastLabel.title, lastLabel.showCancelButton);
            }
        } else {
            this.cancelShowDialog();
            this.hideDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TitleAndButton getLastLabel() {
        List<TitleAndButton> list = this.labels;
        synchronized (list) {
            if (!this.labels.isEmpty()) {
                return this.labels.get(this.labels.size() - 1);
            }
        }
        return null;
    }

    private void hideDialog() {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressBarDialogImpl.this.doHideDialog();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLabel(String title) {
        List<TitleAndButton> list = this.labels;
        synchronized (list) {
            Iterator<TitleAndButton> it = this.labels.iterator();
            while (it.hasNext()) {
                TitleAndButton titleAndButton = it.next();
                if (!titleAndButton.title.equals(title)) continue;
                it.remove();
                return;
            }
        }
    }

    private void cancelShowDialog() {
        this.showDialogTimer.removeActionListener(this.delayedShowActionListener);
        this.showDialogTimer.stop();
    }

    @Override
    public void setOnCancelListener(ActionListener cancelListener) {
        this.cancelListener = cancelListener;
    }

    @Override
    public void setShowProgressPercentage(boolean showIt) {
        this.progressBarPanel.setShowProgressPercentage(showIt);
    }

    private void doDelayedShow(int delayInMS) {
        this.showDialogTimer = new Timer(delayInMS, this.delayedShowActionListener);
        this.showDialogTimer.start();
    }

    private boolean doingDelayedShow() {
        return this.showDialogTimer.isRunning();
    }

    private void showDialogUsingTimer() {
        if (!this.isVisible()) {
            this.cancelShowDialog();
            if (this.isModalDialogShowing()) {
                this.delayedShowDialog();
            } else {
                super.setVisible(true);
            }
        }
    }

    private void doHideDialog() {
        if (this.isVisible() && !this.isDoingDelayedShow()) {
            super.setVisible(false);
        }
    }

    private boolean isDoingDelayedShow() {
        return this.showDialogTimer.isRunning();
    }

    private boolean isModalDialogShowing() {
        Window[] windows = Window.getWindows();
        if (windows != null) {
            Window[] windowArray = windows;
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                Window w = windowArray[n2];
                if (ProgressBarDialogImpl.isWindowShowingModalDialog(w) && this.isNotHiddenLegacyAndNotCurrent(w)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean isNotHiddenLegacyAndNotCurrent(Window w) {
        return !(w instanceof HiddenLegacyDialog) && !this.equals(w);
    }

    private static boolean isWindowShowingModalDialog(Window w) {
        return w.isShowing() && w instanceof Dialog && ((Dialog)w).isModal();
    }

    private static void setButtonFocus(JDialog dialog) {
        List<Component> comList = GuiUtilities.getAllComponents(dialog);
        for (Component comp : comList) {
            if (!(comp instanceof JButton)) continue;
            JButton button = (JButton)comp;
            dialog.getRootPane().setDefaultButton(button);
            return;
        }
    }

    @Override
    public void dispose() {
        this.removeWindowListener(this.progressBarPopupShowingListener);
        super.dispose();
    }

    @Override
    public void setVisible(boolean visible) {
    }

    private class ProgressBarPopupShowingListener
    extends WindowAdapter {
        private ProgressBarPopupShowingListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ProgressBarDialogImpl.this.doHideDialog();
        }
    }

    private static class TitleAndButton {
        String title;
        boolean showCancelButton;

        public TitleAndButton(String title, boolean showCancelButton) {
            this.title = title;
            this.showCancelButton = showCancelButton;
        }
    }
}

