/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.taskprogress;

import com.ur.swing.SwingLanguagePack;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressBarPanel
extends JPanel {
    private JButton cancelButton = new JButton();
    private JProgressBar progressBar = new JProgressBar();

    public ProgressBarPanel(ActionListener cancelButtonListener) {
        this.initComponents(cancelButtonListener);
    }

    public void addMaxProgress(int progressTicks) {
        this.progressBar.setMaximum(this.progressBar.getMaximum() + progressTicks);
        this.progressBar.setIndeterminate(this.progressBar.getMaximum() == 0);
    }

    public void resetProgress() {
        this.progressBar.setMaximum(0);
        this.progressBar.setValue(0);
        this.progressBar.setIndeterminate(true);
    }

    public void addProgress(int progressTicks) {
        if (!this.progressBar.isIndeterminate()) {
            this.progressBar.setValue(this.progressBar.getValue() + progressTicks);
        }
    }

    public void increaseProgress() {
        if (!this.progressBar.isIndeterminate()) {
            this.progressBar.setValue(this.progressBar.getValue() + 1);
        }
    }

    public void setCancelButtonVisible(boolean visible) {
        this.cancelButton.setVisible(visible);
    }

    public void setShowProgressPercentage(boolean showProgressPercentage) {
        this.progressBar.setStringPainted(showProgressPercentage);
    }

    private void initComponents(ActionListener cancelButtonListener) {
        this.setLayout(new BorderLayout());
        JLabel pleaseWaitLabel = new JLabel();
        pleaseWaitLabel.setText(SwingLanguagePack.getTextResource().pleaseWait());
        JPanel progressBarPanel = new JPanel();
        progressBarPanel.add(pleaseWaitLabel);
        progressBarPanel.add(this.progressBar);
        this.progressBar.setIndeterminate(true);
        this.add((Component)progressBarPanel, "North");
        this.cancelButton.setText(SwingLanguagePack.getTextResource().CANCEL());
        this.cancelButton.addActionListener(cancelButtonListener);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.cancelButton);
        this.add((Component)buttonPanel, "Center");
    }
}

