/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.taskprogress;

import com.ur.swing.SwingUtil;
import com.ur.swing.dialog.SwingWaiting;
import com.ur.swing.taskprogress.ProgressBarDialog;
import com.ur.swing.taskprogress.TaskMonitor;
import com.ur.swing.taskprogress.TaskRunner;
import com.ur.swing.taskprogress.TaskRunnerListener;
import com.ur.util.Waiting;
import com.ur.util.concurrent.ParallelTask;
import com.ur.util.concurrent.Task;
import com.ur.util.logging.Log;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class TaskMonitorImpl
implements TaskMonitor {
    private static final int MAX_WAIT_IN_MINUTES = 30;
    private final Provider<ProgressBarDialog> progressBarDialogProvider;
    private final TaskRunner taskRunner;
    private ProgressBarCancelListener progressBarCancelListener;

    @Inject
    public TaskMonitorImpl(Provider<ProgressBarDialog> progressBarDialogProvider, TaskRunner taskRunner) {
        this.progressBarDialogProvider = progressBarDialogProvider;
        this.taskRunner = taskRunner;
        this.addListeners();
    }

    @Override
    public void runAndWait(Task task) {
        Future<?> future = this.run(task);
        TaskMonitorImpl.waitForCompletion(future, 30, TimeUnit.MINUTES);
    }

    private static void waitForCompletion(final Future<?> future, final int timeout, final TimeUnit unit) {
        if (SwingUtil.isUiOrEventThread()) {
            SwingWaiting.until(new Waiting.ItHappens(){

                public boolean itHappened() {
                    TaskMonitorImpl.waitForFutureGet(future, timeout, unit);
                    return true;
                }
            }, timeout, unit);
        } else {
            TaskMonitorImpl.waitForFutureGet(future, timeout, unit);
        }
    }

    private static void waitForFutureGet(Future<?> future, int timeout, TimeUnit unit) {
        try {
            future.get(timeout, unit);
        }
        catch (CancellationException cancellationException) {
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException te) {
            Log.warning((String)te.getMessage());
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
        }
    }

    @Override
    public Future<?> run(Task task) {
        return this.taskRunner.run(task);
    }

    @Override
    public void wait(Future<?> task) {
        TaskMonitorImpl.waitForCompletion(task, 30, TimeUnit.MINUTES);
    }

    @Override
    public void addMaxProgress(int progressTicks) {
        this.getProgressBarDialog().addMaxProgress(progressTicks);
    }

    @Override
    public void addProgress(int progressTicks) {
        this.getProgressBarDialog().addProgress(progressTicks);
    }

    @Override
    public void increaseProgress() {
        this.getProgressBarDialog().increaseProgress();
    }

    @Override
    public Future<?> start(String taskName) {
        return this.start(taskName, 0);
    }

    @Override
    public Future<?> start(String taskName, int totalProgressTicks) {
        return this.run((Task)new ParallelTask(taskName, totalProgressTicks){

            public void run() {
                Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

                    public boolean itHappened() {
                        return Thread.interrupted();
                    }
                }, (int)30, (TimeUnit)TimeUnit.MINUTES);
            }
        });
    }

    @Override
    public void stop(Future<?> future) {
        future.cancel(true);
    }

    @Override
    public void cancelAll() {
        this.taskRunner.cancelAll();
    }

    @Override
    public void showProgressPercentage(boolean showIt) {
        this.getProgressBarDialog().setShowProgressPercentage(showIt);
    }

    private void addListeners() {
        this.taskRunner.setOnTaskRunnerListener(new TaskRunnerListener(){

            @Override
            public void onInit(Task task) {
                TaskMonitorImpl.this.getProgressBarDialog().addTitle(task.getName(), task.getProgressTicks(), task.isCancellable());
            }

            @Override
            public void onBeforeExecute(Task task) {
                this.onBefore(task);
                TaskMonitorImpl.this.getProgressBarDialog().showTitle(task.getName());
            }

            private void onBefore(final Task task) {
                SwingUtil.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        task.onBefore();
                    }
                });
            }

            @Override
            public void onAfterExecute(Task task, Object result, Throwable throwable) {
                TaskMonitorImpl.this.getProgressBarDialog().removeTitle(task.getName());
                if (throwable != null) {
                    this.onError(task, throwable);
                } else {
                    this.onAfter(task);
                }
            }

            private void onAfter(final Task task) {
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        task.onAfter();
                    }
                });
            }

            private void onError(final Task task, final Throwable throwable) {
                Log.debug((String)("Exception in task '" + task.getName() + "' :" + throwable.getMessage()));
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        task.onError(throwable);
                    }
                });
            }
        });
    }

    private ProgressBarDialog getProgressBarDialog() {
        if (this.progressBarCancelListener == null) {
            this.progressBarCancelListener = new ProgressBarCancelListener();
            ((ProgressBarDialog)this.progressBarDialogProvider.get()).setOnCancelListener(this.progressBarCancelListener);
        }
        return (ProgressBarDialog)this.progressBarDialogProvider.get();
    }

    private class ProgressBarCancelListener
    implements ActionListener {
        private ProgressBarCancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskMonitorImpl.this.taskRunner.cancelAll();
        }
    }
}

