/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.taskprogress;

import com.ur.swing.taskprogress.TaskRunner;
import com.ur.swing.taskprogress.TaskRunnerListener;
import com.ur.util.concurrent.SequentialTask;
import com.ur.util.concurrent.Task;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TaskRunnerImpl
implements TaskRunner {
    private final List<URFutureTask> tasks = Collections.synchronizedList(new ArrayList());
    private final URThreadPoolExecutor threadPoolExecutor = new URThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private final URThreadPoolExecutor singleThreadExecutor = new URThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private TaskRunnerListener onTaskRunnerListener = new TaskRunnerListener(){

        @Override
        public void onInit(Task task) {
        }

        @Override
        public void onBeforeExecute(Task task) {
        }

        @Override
        public void onAfterExecute(Task task, Object result, Throwable throwable) {
        }
    };

    @Override
    public void setOnTaskRunnerListener(TaskRunnerListener onTaskRunnerListener) {
        this.onTaskRunnerListener = onTaskRunnerListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> run(Task task) {
        this.onTaskRunnerListener.onInit(task);
        URFutureTask future = (URFutureTask)this.getExecutor(task).submit((Runnable)task);
        List<URFutureTask> list = this.tasks;
        synchronized (list) {
            this.tasks.add(future);
        }
        return future;
    }

    private URThreadPoolExecutor getExecutor(Task task) {
        if (task instanceof SequentialTask) {
            return this.singleThreadExecutor;
        }
        return this.threadPoolExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        List<URFutureTask> list = this.tasks;
        synchronized (list) {
            for (URFutureTask future : this.tasks) {
                if (!TaskRunnerImpl.isRunning(future)) continue;
                if (future.isCancellable()) {
                    future.cancel();
                    future.cancel(true);
                    continue;
                }
                future.cancel(true);
            }
        }
    }

    private static boolean isRunning(URFutureTask future) {
        return !future.isDone() && !future.isCancelled();
    }

    private static class URFutureTask<V>
    extends FutureTask<V> {
        private Task task;

        public URFutureTask(Task task, V result) {
            super((Runnable)task, result);
            this.task = task;
        }

        public String getName() {
            return this.task.getName();
        }

        public boolean isCancellable() {
            return this.task.isCancellable();
        }

        public void cancel() {
            if (this.isCancellable()) {
                this.task.cancel();
            }
        }

        public Task getTask() {
            return this.task;
        }
    }

    private class URThreadPoolExecutor
    extends ThreadPoolExecutor {
        public URThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        @Override
        protected void beforeExecute(Thread thread, Runnable runnable) {
            super.beforeExecute(thread, runnable);
            Task task = ((URFutureTask)runnable).getTask();
            TaskRunnerImpl.this.onTaskRunnerListener.onBeforeExecute(task);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            super.afterExecute(runnable, throwable);
            Object result = null;
            if (throwable == null && runnable instanceof Future) {
                try {
                    result = ((Future)((Object)runnable)).get();
                }
                catch (CancellationException ce) {
                    throwable = ce;
                }
                catch (ExecutionException ee) {
                    throwable = ee.getCause();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            Task task = ((URFutureTask)runnable).getTask();
            TaskRunnerImpl.this.onTaskRunnerListener.onAfterExecute(task, result, throwable);
            this.cleanUp();
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            return new URFutureTask<T>((Task)runnable, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void cleanUp() {
            List list = TaskRunnerImpl.this.tasks;
            synchronized (list) {
                Iterator it = TaskRunnerImpl.this.tasks.iterator();
                while (it.hasNext()) {
                    URFutureTask future = (URFutureTask)it.next();
                    if (TaskRunnerImpl.isRunning(future)) continue;
                    it.remove();
                }
            }
        }
    }
}

