/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.text;

import com.ur.lang.Defense;
import com.ur.swing.AbstractInputPanel;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.InputPicker;
import com.ur.swing.KeyboardLayouts;
import com.ur.swing.LongPressEraseDelegate;
import com.ur.swing.ShiftKeyDelegate;
import com.ur.swing.SwingLanguagePack;
import com.ur.swing.TextIcon;
import com.ur.swing.resources.ButtonImageResource;
import com.ur.swing.resources.ImageResource;
import com.ur.swing.text.BackspaceSupport;
import com.ur.swing.text.KeyboardLayoutHolder;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextPicker;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.CollectionUtils;
import com.ur.util.logging.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class KeyboardPanel
extends AbstractInputPanel {
    static final Color NUMBER_KEYS = UIManager.getColor("NumberPicker.numberKeysColor");
    private static final Color OTHER_KEYS = UIManager.getColor("NumberPicker.otherKeysColor");
    static final Dimension BUTTON_DIMENSIONS = UIManager.getDimension("TextPicker.dimensions") == null ? new Dimension(45, 50) : UIManager.getDimension("TextPicker.dimensions");
    static final Color SHIFTED_KEY_COLOR = UIManager.getColor("TextPicker.shiftedKeyColor") == null ? Color.gray : UIManager.getColor("TextPicker.shiftedKeyColor");
    private static final Color SHIFT_KEY_LOCK_COLOR = UIManager.getColor("TextPicker.shiftKeyLockedColor");
    private static final int MAX_WIDTH = UIManager.getInt("TextPicker.maxWidth") == 0 ? 790 : UIManager.getInt("TextPicker.maxWidth");
    private static final int PADDING = UIManager.getInt("TextPicker.padding") == 0 ? 1 : UIManager.getInt("TextPicker.padding");
    private static final int DYNAMIC_WIDTH = -1;
    private static final Color BACKGROUND_COOR = UIManager.getColor("TextPicker.background");
    private static final Font BOLD_FONT = UIManager.getFont("TextPicker.font");
    private static final Font OTHER_BOLD_FONT = UIManager.getFont("TextPicker.otherFont");
    private JButton submitKey;
    private JButton escKey;
    protected JTextComponent textField;
    private TextPicker textPicker;
    private PropertyChangeListener backgroundChangeListener;
    private ArrayList<JComponent> firstRow = new ArrayList();
    private ArrayList<JComponent> secondRow = new ArrayList();
    private ArrayList<JComponent> thirdRow = new ArrayList();
    private ArrayList<JComponent> fourthRow = new ArrayList();
    private ArrayList<JComponent> fifthRow = new ArrayList();
    protected JComponent strategy;

    public KeyboardPanel(JTextComponent textField) {
        this.textField = textField;
        this.strategy = textField;
        try {
            AbsoluteLayout g = new AbsoluteLayout();
            this.setLayout((LayoutManager)g);
            this.setBackground(BACKGROUND_COOR != null ? BACKGROUND_COOR : this.getBackground());
            Properties keyboardLayout = new Properties();
            KeyboardPanel.loadKeyboardLayoutFromProperties(keyboardLayout, KeyboardLayoutHolder.getKeyboardLayout());
            JButton cancel = this.escKey(textField);
            cancel.setEnabled(false);
            this.firstRow = KeyboardPanel.buildRowOfKeys(keyboardLayout, "firstRow", textField);
            this.firstRow.add(0, cancel);
            this.firstRow.add(this.backspaceKey(SwingLanguagePack.getTextResource().backspace(), textField));
            this.secondRow = KeyboardPanel.buildRowOfKeys(keyboardLayout, "secondRow", textField);
            this.secondRow.add(this.enterKey(textField));
            this.thirdRow = KeyboardPanel.buildRowOfKeys(keyboardLayout, "thirdRow", textField);
            this.fourthRow = KeyboardPanel.buildRowOfKeys(keyboardLayout, "fourthRow", textField);
            this.fourthRow.add(0, this.shiftKey(textField));
            this.fifthRow.add(this.spaceBar(textField));
            this.fifthRow.add(this.leftArrowKey(textField));
            this.fifthRow.add(this.upDownArrowKey(textField));
            this.fifthRow.add(this.rightArrowKey(textField));
            new KeyboardButtonsBuilder(false, null).build();
        }
        catch (IOException ex) {
            Log.error((String)"Failed to create keyboard", (Throwable)ex);
        }
    }

    public KeyboardPanel(JTextComponent textField, TextPicker textPicker, boolean addTextField, String headline, JButton ... actions) {
        this.textField = textField;
        this.textPicker = textPicker;
        this.strategy = textField;
        try {
            AbsoluteLayout g = new AbsoluteLayout();
            this.setLayout((LayoutManager)g);
            this.setBackground(BACKGROUND_COOR != null ? BACKGROUND_COOR : this.getBackground());
            Properties keyboardLayout = new Properties();
            KeyboardPanel.loadKeyboardLayoutFromProperties(keyboardLayout, KeyboardLayoutHolder.getKeyboardLayout());
            this.firstRow = KeyboardPanel.buildRowOfKeys(keyboardLayout, "firstRow", textField);
            this.escKey = this.escKey(textField);
            this.firstRow.add(0, this.escKey);
            this.firstRow.add(this.backspaceKey(SwingLanguagePack.getTextResource().backspace(), textField));
            this.secondRow = KeyboardPanel.buildRowOfKeys(keyboardLayout, "secondRow", textField);
            this.secondRow.add(this.submitKey());
            this.thirdRow = KeyboardPanel.buildRowOfKeys(keyboardLayout, "thirdRow", textField);
            this.fourthRow = KeyboardPanel.buildRowOfKeys(keyboardLayout, "fourthRow", textField);
            this.fourthRow.add(0, this.shiftKey(textField));
            this.fifthRow.addAll(Arrays.asList(actions));
            this.fifthRow.add(this.spaceBar(textField));
            this.fifthRow.add(this.leftArrowKey(textField));
            this.fifthRow.add(this.rightArrowKey(textField));
            new KeyboardButtonsBuilder(addTextField, headline).build();
        }
        catch (IOException ex) {
            Log.error((String)"Failed to create keyboard", (Throwable)ex);
        }
    }

    public KeyboardPanel(JTextComponent textField, TextPicker textPicker, boolean addTextField, String headline, ValidationStrategy keyValidation, JButton ... actions) {
        this.textField = textField;
        this.textPicker = textPicker;
        this.strategy = textField;
        try {
            AbsoluteLayout g = new AbsoluteLayout();
            this.setLayout((LayoutManager)g);
            this.setBackground(BACKGROUND_COOR != null ? BACKGROUND_COOR : this.getBackground());
            Properties keyboardLayout = new Properties();
            KeyboardPanel.loadKeyboardLayoutFromProperties(keyboardLayout, KeyboardLayoutHolder.getKeyboardLayout());
            this.firstRow = KeyboardPanel.buildRowOfKeys(keyboardLayout, "firstRow", textField, keyValidation);
            this.escKey = this.escKey(textField);
            this.firstRow.add(0, this.escKey);
            this.firstRow.add(this.backspaceKey(SwingLanguagePack.getTextResource().backspace(), textField));
            this.secondRow = KeyboardPanel.buildRowOfKeys(keyboardLayout, "secondRow", textField, keyValidation);
            this.secondRow.add(this.submitKey());
            this.thirdRow = KeyboardPanel.buildRowOfKeys(keyboardLayout, "thirdRow", textField, keyValidation);
            this.fourthRow = KeyboardPanel.buildRowOfKeys(keyboardLayout, "fourthRow", textField, keyValidation);
            this.fourthRow.add(0, this.shiftKey(textField));
            this.fifthRow.addAll(Arrays.asList(actions));
            this.fifthRow.add(this.spaceBar(textField));
            this.fifthRow.add(this.leftArrowKey(textField));
            this.fifthRow.add(this.rightArrowKey(textField));
            new KeyboardButtonsBuilder(addTextField, headline).build();
        }
        catch (IOException ex) {
            Log.error((String)"Failed to create keyboard", (Throwable)ex);
        }
    }

    @Override
    public void onShow() {
        this.addBackgroundListener();
    }

    @Override
    public void onHide() {
        this.removeBackgroundListener();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.textField = null;
        this.textPicker = null;
    }

    @Override
    public void onSubmit() {
        this.submitKey.doClick();
    }

    @Override
    public void onCancel() {
        this.escKey.doClick();
    }

    private void addBackgroundListener() {
        this.updateOkEnabled();
        this.backgroundChangeListener = evt -> this.updateOkEnabled();
        this.textPicker.getTextField().addPropertyChangeListener("background", this.backgroundChangeListener);
    }

    private void removeBackgroundListener() {
        this.textPicker.getTextField().removePropertyChangeListener("background", this.backgroundChangeListener);
    }

    private void updateOkEnabled() {
        Log.trace((String)("Has error: " + !DisplayMessageFactory.hasError(this.textPicker.getTextField())));
        this.setSubmitKeyEnabled(!DisplayMessageFactory.hasError(this.textPicker.getTextField()));
    }

    public void setSubmitKeyEnabled(boolean enabled) {
        if (this.submitKey != null) {
            this.submitKey.setEnabled(enabled);
        }
    }

    public static void loadKeyboardLayoutFromProperties(Properties keyboardLayout, KeyboardLayouts layouts) throws IOException {
        try {
            keyboardLayout.load(TextPicker.class.getResourceAsStream("/keymap/" + layouts.getFileName()));
        }
        catch (Exception exception) {
            Log.info((String)("We don't seem to have a means of supporting locale: " + Locale.getDefault().getDisplayLanguage()));
            keyboardLayout.load(TextPicker.class.getResourceAsStream("/keymap/keyboard_layout.properties"));
        }
    }

    public static ArrayList<JComponent> buildRowOfKeys(Properties properties, String key, JTextComponent textField) {
        ArrayList<JComponent> result = new ArrayList<JComponent>();
        String normal = properties.getProperty(key);
        String shifted = properties.getProperty(String.valueOf(key) + "Shift");
        Defense.sameLength((Object)normal, (Object)shifted, (String)("The key lengths should be the same for '" + key + "' and '" + key + "Shift', but they differ"));
        int i = 0;
        while (i < normal.length()) {
            result.add(new OnScreenKey(normal.charAt(i), shifted.charAt(i), textField, null, null));
            ++i;
        }
        return result;
    }

    public static ArrayList<JComponent> buildRowOfKeys(Properties properties, String key, JTextComponent textField, ValidationStrategy validator) {
        ArrayList<JComponent> result = new ArrayList<JComponent>();
        String normal = properties.getProperty(key);
        String shifted = properties.getProperty(String.valueOf(key) + "Shift");
        Defense.sameLength((Object)normal, (Object)shifted, (String)("The key lengths should be the same for '" + key + "' and '" + key + "Shift', but they differ"));
        int i = 0;
        while (i < normal.length()) {
            result.add(new OnScreenKeyValidator(normal.charAt(i), shifted.charAt(i), textField, validator));
            ++i;
        }
        return result;
    }

    private JButton shiftKey(JTextComponent textField) {
        JButton result = this.createSpecialKey(SwingLanguagePack.getTextResource().shiftKey());
        ShiftKeyDelegate keyDelegate = new ShiftKeyDelegate(result);
        keyDelegate.setShiftStateListener(new ShiftKeyHandler(result));
        textField.addCaretListener(e -> keyDelegate.otherKeyClicked());
        result.setSize(-1, KeyboardPanel.BUTTON_DIMENSIONS.height);
        result.setName(TextPicker.SHIFT_BUTTON);
        result.setIcon(ButtonImageResource.shift());
        result.setFont(OTHER_BOLD_FONT);
        return result;
    }

    private JButton spaceBar(JTextComponent textField) {
        JButton result = this.createSpecialKey("", evt -> {
            textField.replaceSelection(" ");
            this.strategy.requestFocus();
        });
        result.setSize(new Dimension(-1, KeyboardPanel.BUTTON_DIMENSIONS.height));
        result.setBackground(NUMBER_KEYS);
        result.setName(TextPicker.SPACE_BAR);
        return result;
    }

    private JButton submitKey() {
        this.submitKey = this.createSpecialKey(SwingLanguagePack.getTextResource().submit(), evt -> this.submitKeyAction());
        this.submitKey.setVerticalTextPosition(3);
        this.submitKey.setHorizontalTextPosition(0);
        this.submitKey.setMargin(new Insets(0, 0, 0, 0));
        this.submitKey.setIcon(ButtonImageResource.submit());
        this.submitKey.setSize(new Dimension(-1, KeyboardPanel.BUTTON_DIMENSIONS.height));
        this.submitKey.setName(TextPicker.OK_BUTTON);
        return this.submitKey;
    }

    protected void submitKeyAction() {
        this.textPicker.hideInputPanel(InputPicker.Request.Apply);
    }

    private JComponent enterKey(JTextComponent textField) {
        JButton result = this.createSpecialKey(SwingLanguagePack.getTextResource().enter(), e -> {
            try {
                textField.getDocument().insertString(textField.getCaretPosition(), "\n", null);
            }
            catch (BadLocationException badLocationException) {
                Log.error((String)"Unable to enter a new line");
            }
            this.strategy.requestFocus();
        });
        result.setIcon(ImageResource.enter());
        result.setSize(-1, KeyboardPanel.BUTTON_DIMENSIONS.height);
        return result;
    }

    private JButton escKey(JTextComponent textField) {
        JButton result = this.createSpecialKey("Esc", new ActionListener(textField){
            private final String originalText;
            {
                this.originalText = jTextComponent.getText();
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.escKeyAction(this.originalText);
            }
        });
        result.setIcon(ButtonImageResource.escape());
        result.setBackground(OTHER_KEYS);
        result.setVerticalTextPosition(3);
        result.setHorizontalTextPosition(0);
        result.setSize(new Dimension(KeyboardPanel.BUTTON_DIMENSIONS.width, KeyboardPanel.BUTTON_DIMENSIONS.height));
        return result;
    }

    protected void escKeyAction(String originalText) {
        this.textField.setText(originalText);
        this.textPicker.hideInputPanel(InputPicker.Request.Cancel);
    }

    private JButton leftArrowKey(JTextComponent textField) {
        JButton result = this.arrowKey("caret-backward", textField);
        result.setIcon(ButtonImageResource.leftArrow());
        return result;
    }

    private JButton rightArrowKey(JTextComponent textField) {
        JButton result = this.arrowKey("caret-forward", textField);
        result.setIcon(ButtonImageResource.rightArrow());
        return result;
    }

    private JPanel upDownArrowKey(JTextComponent textField) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        result.add(this.upArrowKey(textField));
        result.add(Box.createVerticalStrut(PADDING));
        result.add(this.downArrowKey(textField));
        result.setOpaque(false);
        result.setSize((int)((double)KeyboardPanel.BUTTON_DIMENSIONS.width * 1.5), KeyboardPanel.BUTTON_DIMENSIONS.height);
        return result;
    }

    private JButton upArrowKey(JTextComponent textField) {
        JButton result = this.arrowKey("caret-up", textField);
        result.setIcon(ButtonImageResource.upArrow());
        result.setSize((int)((double)KeyboardPanel.BUTTON_DIMENSIONS.width * 1.5), KeyboardPanel.BUTTON_DIMENSIONS.height / 2 - PADDING / 2);
        result.setMaximumSize(result.getSize());
        result.setPreferredSize(result.getSize());
        return result;
    }

    private JButton downArrowKey(JTextComponent textField) {
        JButton result = this.arrowKey("caret-down", textField);
        result.setIcon(ButtonImageResource.downArrow());
        result.setSize((int)((double)KeyboardPanel.BUTTON_DIMENSIONS.width * 1.5), KeyboardPanel.BUTTON_DIMENSIONS.height / 2 - PADDING / 2);
        result.setMaximumSize(result.getSize());
        result.setPreferredSize(result.getSize());
        return result;
    }

    private JButton arrowKey(String styledEditorKitLookup, JTextComponent textField) {
        JButton result = this.createSpecialKey("", evt -> {
            textField.getActionMap().get(styledEditorKitLookup).actionPerformed(evt);
            this.strategy.requestFocus();
        });
        result.setSize(new Dimension((int)((double)KeyboardPanel.BUTTON_DIMENSIONS.width * 1.5), KeyboardPanel.BUTTON_DIMENSIONS.height));
        return result;
    }

    private JButton backspaceKey(String text, final JTextComponent textField) {
        JButton result = this.createSpecialKey(text);
        result.setMargin(new Insets(0, 0, 0, 0));
        new LongPressEraseDelegate(result, textField){

            @Override
            protected void longPressAction() {
                if (textField instanceof BackspaceSupport) {
                    BackspaceSupport expressionField = (BackspaceSupport)((Object)textField);
                    expressionField.backspace();
                    expressionField.setCaretPosition(textField.getSelectionStart());
                    expressionField.updateInputTextField();
                } else {
                    super.longPressAction();
                }
            }

            @Override
            protected void buttonReleased() {
                KeyboardPanel.this.strategy.requestFocus();
            }
        };
        result.setIcon(ButtonImageResource.backspace());
        result.setVerticalTextPosition(3);
        result.setHorizontalTextPosition(0);
        result.setSize(-1, result.getHeight());
        result.setName(TextPicker.BACKSPACE_BUTTON);
        return result;
    }

    private JButton createSpecialKey(String text, ActionListener action) {
        JButton result = this.createSpecialKey(text);
        result.addActionListener(action);
        return result;
    }

    private JButton createSpecialKey(String text) {
        JButton result = new JButton(text);
        result.setFont(OTHER_BOLD_FONT);
        result.setPreferredSize(BUTTON_DIMENSIONS);
        result.setSize(BUTTON_DIMENSIONS);
        result.setBackground(OTHER_KEYS);
        return result;
    }

    @Override
    public void setValidationStrategy(ValidationStrategy errorValidationStrategy) {
        Defense.notNull((Object)this.textField, (String)"Must have a textfield showing on keypad");
        Defense.notNull((Object)errorValidationStrategy, (String)"Validation strategy cannot be null");
        TextFieldUtils.bindValidator(this.textField, errorValidationStrategy);
    }

    private final class KeyboardButtonsBuilder {
        private int padding = 1;
        private int buttonRow = 0;
        private boolean addTextField;
        private String headline;

        private KeyboardButtonsBuilder(boolean addTextField, String headline) {
            this.addTextField = addTextField;
            this.headline = headline;
        }

        private void build() {
            if (this.headline != null) {
                JTextArea textArea = new JTextArea(this.headline, 2, 0);
                textArea.setLineWrap(true);
                textArea.setWrapStyleWord(true);
                textArea.setEditable(false);
                textArea.setOpaque(false);
                JScrollPane scrollPane = new JScrollPane(textArea);
                scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
                scrollPane.setSize(KeyboardPanel.BUTTON_DIMENSIONS.width * 10, KeyboardPanel.BUTTON_DIMENSIONS.height - 5);
                this.addRow(KeyboardPanel.BUTTON_DIMENSIONS.width * 2, Arrays.asList(scrollPane));
            }
            if (this.addTextField) {
                KeyboardPanel.this.textField.setSize((KeyboardPanel.BUTTON_DIMENSIONS.width + PADDING) * 10 - PADDING, KeyboardPanel.BUTTON_DIMENSIONS.height - 5);
                this.addRow((KeyboardPanel.BUTTON_DIMENSIONS.width + PADDING) * 2, Arrays.asList(KeyboardPanel.this.textField));
            }
            int secondRowWidthStart = (int)((double)KeyboardPanel.BUTTON_DIMENSIONS.width * (KeyboardPanel.this.secondRow.size() > 12 ? 0.5 : 1.5));
            int thirdRowWidthStart = KeyboardPanel.BUTTON_DIMENSIONS.width * (KeyboardPanel.this.thirdRow.size() <= 12 ? 2 : (KeyboardPanel.this.thirdRow.size() == 13 ? 1 : 0));
            this.addRow(0, KeyboardPanel.this.firstRow);
            this.addRow(secondRowWidthStart, KeyboardPanel.this.secondRow);
            this.addRow(thirdRowWidthStart, KeyboardPanel.this.thirdRow);
            this.addRow(0, KeyboardPanel.this.fourthRow);
            this.addRow(0, KeyboardPanel.this.fifthRow);
        }

        private void addRow(int x, List<JComponent> components) {
            this.attachButtonsStartingAt(x, this.padding + KeyboardPanel.BUTTON_DIMENSIONS.height * this.buttonRow, components);
            this.padding += PADDING;
            ++this.buttonRow;
        }

        private void attachButtonsStartingAt(int startX, int startY, List<JComponent> row) {
            int x = startX;
            int y = startY;
            int i = 0;
            while (i < row.size()) {
                JComponent component = row.get(i);
                component.setLocation(x, y);
                if (component.getWidth() == -1) {
                    int width = this.calculateRest(row, i + 1);
                    component.setSize(MAX_WIDTH - (x + width), component.getHeight());
                }
                KeyboardPanel.this.add((Component)component, new AbsoluteConstraints(x, y, component.getWidth(), component.getHeight()));
                x += PADDING + component.getWidth();
                ++i;
            }
        }

        private int calculateRest(List<JComponent> row, int start) {
            int result = 0;
            int i = start;
            while (i < row.size()) {
                int width = row.get(i).getWidth();
                if (width == -1) {
                    throw new IllegalStateException("Only 1 key per row can have dynamic width");
                }
                result += width + PADDING;
                ++i;
            }
            return result;
        }
    }

    private static class OnScreenKey
    extends JButton {
        private TextIcon main;
        private TextIcon shifted;

        public OnScreenKey() {
        }

        private OnScreenKey(char mainChar, char shiftedChar, JTextComponent component) {
            if (Character.toUpperCase(mainChar) != Character.toUpperCase(shiftedChar)) {
                this.main = new TextIcon(this, Character.toString(mainChar));
                this.main.setFont(OTHER_BOLD_FONT);
                this.main.setForeground(SHIFTED_KEY_COLOR);
                this.shifted = new TextIcon(this, Character.toString(shiftedChar));
                this.shifted.setFont(OTHER_BOLD_FONT);
                this.shifted.setForeground(SHIFTED_KEY_COLOR);
            }
            this.setText(Character.toString(mainChar));
            this.setName(Character.toString(shiftedChar));
            this.setIcon(this.shifted);
            this.addActionListener(evt -> {
                component.replaceSelection(this.getText());
                component.requestFocus();
            });
            this.setBackground(NUMBER_KEYS);
            this.setFont(BOLD_FONT);
            this.setPreferredSize(BUTTON_DIMENSIONS);
            this.setSize(BUTTON_DIMENSIONS);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
        }

        public void shift() {
            String name = this.getName();
            String text = this.getText();
            this.setName(text);
            this.setText(name);
            TextIcon tmp = this.main;
            this.main = this.shifted;
            this.shifted = tmp;
            this.setIcon(this.shifted);
        }

        /* synthetic */ OnScreenKey(char c, char c2, JTextComponent jTextComponent, OnScreenKey onScreenKey, OnScreenKey onScreenKey2) {
            this(c, c2, jTextComponent);
        }
    }

    private static final class OnScreenKeyValidator
    extends OnScreenKey {
        ValidationStrategy validator;

        private OnScreenKeyValidator(char mainChar, char shiftedChar, JTextComponent component, ValidationStrategy validator) {
            super(mainChar, shiftedChar, component);
            this.validator = validator;
            this.setEnabled(validator.isValid(this.getText()));
        }

        @Override
        public void shift() {
            super.shift();
            this.setEnabled(this.validator.isValid(this.getText()));
        }
    }

    private final class ShiftKeyHandler
    implements ShiftKeyDelegate.ShiftStateListener {
        private final JButton shiftButton;

        private ShiftKeyHandler(JButton shiftButton) {
            this.shiftButton = shiftButton;
        }

        @Override
        public void shiftOnce() {
            this.shiftAction();
            this.shiftButton.setBackground(BACKGROUND_COOR);
            this.shiftButton.setText(SwingLanguagePack.getTextResource().shiftKey().toUpperCase());
        }

        @Override
        public void shiftOff() {
            this.shiftAction();
            this.shiftButton.setBackground(OTHER_KEYS);
            this.shiftButton.setText(SwingLanguagePack.getTextResource().shiftKey());
        }

        @Override
        public void shiftLock() {
            this.shiftAction();
            this.shiftButton.setBackground(SHIFT_KEY_LOCK_COLOR);
            this.shiftButton.setText(SwingLanguagePack.getTextResource().shiftKey().toUpperCase());
        }

        private void shiftAction() {
            this.shiftDisplayedKeys(KeyboardPanel.this.firstRow);
            this.shiftDisplayedKeys(KeyboardPanel.this.secondRow);
            this.shiftDisplayedKeys(KeyboardPanel.this.thirdRow);
            this.shiftDisplayedKeys(KeyboardPanel.this.fourthRow);
            this.shiftDisplayedKeys(KeyboardPanel.this.fifthRow);
            KeyboardPanel.this.textField.requestFocus();
        }

        private void shiftDisplayedKeys(Collection<JComponent> keys) {
            for (OnScreenKey each : CollectionUtils.filter(keys, OnScreenKey.class)) {
                each.shift();
            }
        }
    }
}

