/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.text;

import com.ur.lang.Defense;
import com.ur.lang.EqualsUtil;
import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.swing.BindingRegistration;
import com.ur.swing.CloseListener;
import com.ur.swing.CompletedListener;
import com.ur.swing.CompoundRegistration;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.DocumentUpdateListener;
import com.ur.swing.JFrameUtils;
import com.ur.swing.ScreenUtils;
import com.ur.swing.SwingUtil;
import com.ur.swing.WidgetState;
import com.ur.swing.text.TextHolder;
import com.ur.swing.text.TextPicker;
import com.ur.swing.text.UpdateBeanDocumentListener;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.FormValidation;
import com.ur.swing.validation.ValidationDocumentListener;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.Optional;
import com.ur.util.logging.Log;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class TextFieldUtils {
    private static final CompletedListener DUMMY_LISTENER = new CompletedListener.Template();

    public static void setText(JTextField field, String text) {
        if (EqualsUtil.equalsOneOf((Object)text, (Object[])new String[]{"-0.0", "-0.00", "-0.000", "-0.0000"})) {
            text = text.substring(1);
        }
        if (!EqualsUtil.equals((Object)field.getText(), (Object)text)) {
            field.setText(text);
        }
    }

    public static BindingRegistration bindGhostText(final JTextField field, final String ghostText) {
        final FocusListener focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (StringUtils.isNullOrOnlyWhitespace((String)field.getText())) {
                    field.setForeground(Color.LIGHT_GRAY);
                    field.setText(ghostText);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (field.getText().equals(ghostText)) {
                    field.setForeground(Color.black);
                    field.setText("");
                }
            }
        };
        final ComponentAdapter componentListener = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (StringUtils.isNullOrOnlyWhitespace((String)field.getText())) {
                    field.setForeground(Color.LIGHT_GRAY);
                    field.setText(ghostText);
                }
            }
        };
        field.addFocusListener(focusListener);
        field.addComponentListener(componentListener);
        if (StringUtils.isNullOrOnlyWhitespace((String)field.getText())) {
            field.setForeground(Color.LIGHT_GRAY);
            field.setText(ghostText);
        }
        return new BindingRegistration(){

            @Override
            public void removeRegistration() {
                field.removeFocusListener(focusListener);
                field.removeComponentListener(componentListener);
                if (field.getText().equals(ghostText)) {
                    field.setText("");
                    field.setForeground(Color.black);
                }
            }
        };
    }

    public static BindingRegistration bindTextPicker(JComponent component, TextHolder provider) {
        return TextFieldUtils.bindTextPicker(component, provider, DUMMY_LISTENER, ValidationStrategy.ALWAYS_VALID);
    }

    public static BindingRegistration bindTextPicker(JComponent component, TextHolder provider, ValidationStrategy strategy) {
        return TextFieldUtils.bindTextPicker(component, provider, DUMMY_LISTENER, strategy);
    }

    public static BindingRegistration bindTextPickerAtPosition(JComponent component, PositionHolder positionHolder, TextHolder provider, ValidationStrategy strategy) {
        return TextFieldUtils.bindTextPickerAtPosition(component, positionHolder, provider, DUMMY_LISTENER, strategy);
    }

    public static BindingRegistration bindTextPickerAtPosition(final JComponent component, final PositionHolder positionHolder, final TextHolder provider, final CompletedListener completedListener, final ValidationStrategy strategy) {
        final MouseAdapter listener = new MouseAdapter(){
            private long timeToWaitAfterClose = System.currentTimeMillis();
            private TextPicker textPicker = null;

            @Override
            public void mousePressed(MouseEvent e) {
                if (!component.isEnabled()) {
                    return;
                }
                if (this.textPicker == null && this.timeToWaitAfterClose < System.currentTimeMillis()) {
                    this.textPicker = new TextPicker(provider, component instanceof JPasswordField);
                    this.textPicker.addCompletedListener(completedListener);
                    this.textPicker.addCloseListener(new CloseListener(){

                        @Override
                        public void onClose() {
                            textPicker = null;
                            timeToWaitAfterClose = System.currentTimeMillis() + 300L;
                        }
                    });
                    TextFieldUtils.bindValidator(this.textPicker.getTextField(), strategy);
                    this.textPicker.showInputPanelAt(component, positionHolder.getPosition());
                }
            }
        };
        component.addMouseListener(listener);
        return new BindingRegistration(){

            @Override
            public void removeRegistration() {
                component.removeMouseListener(listener);
            }
        };
    }

    public static BindingRegistration bindTextPickerAtPositionValidateKeys(final JComponent component, final PositionHolder positionHolder, final TextHolder provider, final CompletedListener completedListener, final ValidationStrategy textStrategy, final ValidationStrategy keyStrategy) {
        final MouseAdapter listener = new MouseAdapter(){
            private long timeToWaitAfterClose = System.currentTimeMillis();
            private TextPicker textPicker = null;

            @Override
            public void mousePressed(MouseEvent e) {
                if (!component.isEnabled()) {
                    return;
                }
                if (this.textPicker == null && this.timeToWaitAfterClose < System.currentTimeMillis()) {
                    this.textPicker = new TextPicker(provider, component instanceof JPasswordField, keyStrategy);
                    this.textPicker.addCompletedListener(completedListener);
                    this.textPicker.addCloseListener(new CloseListener(){

                        @Override
                        public void onClose() {
                            textPicker = null;
                            timeToWaitAfterClose = System.currentTimeMillis() + 300L;
                        }
                    });
                    TextFieldUtils.bindValidator(this.textPicker.getTextField(), textStrategy);
                    this.textPicker.showInputPanelAt(component, positionHolder.getPosition());
                }
            }
        };
        component.addMouseListener(listener);
        return new BindingRegistration(){

            @Override
            public void removeRegistration() {
                component.removeMouseListener(listener);
            }
        };
    }

    public static BindingRegistration bindTextPicker(final JComponent component, final TextHolder provider, final CompletedListener completedListener, final ValidationStrategy strategy) {
        final MouseAdapter listener = new MouseAdapter(){
            private long timeToWaitAfterClose = System.currentTimeMillis();
            private TextPicker textPicker = null;

            @Override
            public void mousePressed(MouseEvent e) {
                if (!ScreenUtils.isUrGuiCenteredOnScreen()) {
                    SwingUtil.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!ScreenUtils.isUrGuiCenteredOnScreen()) {
                                ScreenUtils.centerURGUIOnScreen();
                            }
                        }
                    });
                }
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.onMousePressed();
                    }
                });
            }

            private JFrame getApplicationFrame() {
                Optional<JFrame> optionalFrame = JFrameUtils.getApplicationFrame();
                return optionalFrame.isPresent() ? (JFrame)optionalFrame.get() : new JFrame();
            }

            private void onMousePressed() {
                if (!component.isEnabled()) {
                    return;
                }
                if (this.textPicker == null && this.timeToWaitAfterClose < System.currentTimeMillis()) {
                    this.textPicker = new TextPicker(provider, component instanceof JPasswordField);
                    this.textPicker.addCompletedListener(completedListener);
                    this.textPicker.addCloseListener(new CloseListener(){

                        @Override
                        public void onClose() {
                            textPicker = null;
                            timeToWaitAfterClose = System.currentTimeMillis() + 300L;
                        }
                    });
                    TextFieldUtils.bindValidator(this.textPicker.getTextField(), strategy);
                    this.textPicker.validateValue();
                    int position = component.getLocationOnScreen().y + component.getHeight();
                    this.textPicker.showInputPanelAt(component, position);
                }
            }
        };
        component.addMouseListener(listener);
        return new BindingRegistration(){

            @Override
            public void removeRegistration() {
                component.removeMouseListener(listener);
            }
        };
    }

    public static BindingRegistration bindTextPickerValidateKeys(final JComponent component, final TextHolder provider, final CompletedListener completedListener, final ValidationStrategy textStrategy, final ValidationStrategy keyStrategy) {
        final MouseAdapter listener = new MouseAdapter(){
            private long timeToWaitAfterClose = System.currentTimeMillis();
            private TextPicker textPicker = null;

            @Override
            public void mousePressed(MouseEvent e) {
                if (!component.isEnabled()) {
                    return;
                }
                if (this.textPicker == null && this.timeToWaitAfterClose < System.currentTimeMillis()) {
                    this.textPicker = new TextPicker(provider, component instanceof JPasswordField, keyStrategy);
                    this.textPicker.addCompletedListener(completedListener);
                    this.textPicker.addCloseListener(new CloseListener(){

                        @Override
                        public void onClose() {
                            textPicker = null;
                            timeToWaitAfterClose = System.currentTimeMillis() + 300L;
                        }
                    });
                    TextFieldUtils.bindValidator(this.textPicker.getTextField(), textStrategy);
                    int position = component.getLocationOnScreen().y + component.getHeight();
                    this.textPicker.showInputPanelAt(component, position);
                }
            }
        };
        component.addMouseListener(listener);
        return new BindingRegistration(){

            @Override
            public void removeRegistration() {
                component.removeMouseListener(listener);
            }
        };
    }

    public static BindingRegistration bindValidator(final JTextComponent nameTextField, ValidationStrategy validator) {
        final ValidationDocumentListener documentValidation = new ValidationDocumentListener(nameTextField, validator);
        nameTextField.getDocument().addDocumentListener(documentValidation);
        return new BindingRegistration(){

            @Override
            public void removeRegistration() {
                nameTextField.getDocument().removeDocumentListener(documentValidation);
            }
        };
    }

    public static BindingRegistration bindPropertyChangeListenerToField(final JTextField field, final String propertyName, final PropertyChangeListener listener) {
        field.removePropertyChangeListener(propertyName, listener);
        field.addPropertyChangeListener(propertyName, listener);
        return new BindingRegistration(){

            @Override
            public void removeRegistration() {
                field.removePropertyChangeListener(propertyName, listener);
            }
        };
    }

    public static BindingRegistration bindToField(JTextField observed, Object observer, String fieldName) {
        return TextFieldUtils.bindToField(observed, observer, fieldName, ValueConverter.DUMMY_CONVERTER);
    }

    public static BindingRegistration bindToField(final JTextField observed, Object observer, String fieldName, ValueConverter<?, ?> converter) {
        final UpdateBeanDocumentListener documentListener = new UpdateBeanDocumentListener(observed, observer, fieldName, converter);
        observed.getDocument().addDocumentListener(documentListener);
        return new BindingRegistration(){

            @Override
            public void removeRegistration() {
                observed.getDocument().removeDocumentListener(documentListener);
            }
        };
    }

    public static BindingRegistration massBindToDoubleArray(final Collection<JTextField> fields, final double[] values, UnitsConverter converter, final DecimalFormat formatter, final PropertyChangeListener changeListener) {
        Defense.sameLength(fields, (Object)values, (String)"JTextFields and double[] must be the same length");
        final ValueConverter.DoubleConverter valueConverter = new ValueConverter.DoubleConverter(converter, formatter);
        BindingRegistration[] registrations = new BindingRegistration[fields.size()];
        final JTextField[] fieldsAsArray = fields.toArray(new JTextField[0]);
        int i = 0;
        while (i < fields.size()) {
            final int index = i;
            final DocumentUpdateListener listener = new DocumentUpdateListener(){

                @Override
                public void update() {
                    Log.trace((String)"update bindings");
                    try {
                        double oldValue = values[index];
                        String oldValueConverted = valueConverter.fromModel(oldValue);
                        if (!oldValueConverted.equals(fieldsAsArray[index].getText())) {
                            values[index] = valueConverter.fromGui(fieldsAsArray[index].getText());
                            changeListener.propertyChange(new PropertyChangeEvent(fields.toArray()[index], "", oldValue, values[index]));
                        }
                    }
                    catch (Exception exception) {}
                }
            };
            final FocusAdapter formatOnExitListener = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        String valueAsString = fieldsAsArray[index].getText();
                        double value = PrimitiveUtils.parseDouble((String)valueAsString);
                        String formattedValue = formatter.format(value);
                        if (!EqualsUtil.equals((Object)formattedValue, (Object)valueAsString)) {
                            fieldsAsArray[index].setText(formattedValue);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            };
            fieldsAsArray[i].setText(valueConverter.fromModel(values[i]));
            fieldsAsArray[i].getDocument().addDocumentListener(listener);
            fieldsAsArray[i].addFocusListener(formatOnExitListener);
            registrations[i] = new BindingRegistration(){

                @Override
                public void removeRegistration() {
                    fieldsAsArray[index].removeFocusListener(formatOnExitListener);
                    fieldsAsArray[index].getDocument().removeDocumentListener(listener);
                }
            };
            ++i;
        }
        return new CompoundRegistration(registrations);
    }

    public static BindingRegistration bindSetDefaultOnFocusLost(final JTextField nameTextField, final String defaultText) {
        final FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (nameTextField.getBackground().equals(DisplayMessageFactory.ERROR_COLOR)) {
                    nameTextField.setText(defaultText);
                }
            }
        };
        nameTextField.addFocusListener(focusAdapter);
        return new BindingRegistration(){

            @Override
            public void removeRegistration() {
                nameTextField.removeFocusListener(focusAdapter);
            }
        };
    }

    public static BindingRegistration bindEnterEventToButton(final JTextField field, final JButton button) {
        final ActionListener clickButtonOnEnterListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                button.doClick();
            }
        };
        field.addActionListener(clickButtonOnEnterListener);
        return new BindingRegistration(){

            @Override
            public void removeRegistration() {
                field.removeActionListener(clickButtonOnEnterListener);
            }
        };
    }

    public static BindingRegistration bindFieldState(final WidgetState widgetState, final JTextField ... fields) {
        final PropertyChangeListener informOfErrorsAndWarningsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("background")) {
                    boolean isWarning = false;
                    boolean isError = false;
                    if (evt.getNewValue() == DisplayMessageFactory.ERROR_COLOR) {
                        isError = true;
                    } else if (evt.getNewValue() == DisplayMessageFactory.WARNING_COLOR) {
                        isWarning = true;
                    }
                    JTextField[] jTextFieldArray = fields;
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JTextField each = jTextFieldArray[n2];
                        if (each.getBackground() == DisplayMessageFactory.ERROR_COLOR) {
                            isError = true;
                            break;
                        }
                        if (each.getBackground() == DisplayMessageFactory.WARNING_COLOR) {
                            isWarning = true;
                        }
                        ++n2;
                    }
                    if (isError) {
                        widgetState.showError();
                    } else if (isWarning) {
                        widgetState.showWarning();
                    } else {
                        widgetState.clearAll();
                    }
                }
            }
        };
        JTextField[] jTextFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            JTextField each = jTextFieldArray[n2];
            each.addPropertyChangeListener(informOfErrorsAndWarningsListener);
            ++n2;
        }
        return new BindingRegistration(){

            @Override
            public void removeRegistration() {
                JTextField[] jTextFieldArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    JTextField each = jTextFieldArray[n2];
                    each.removePropertyChangeListener(informOfErrorsAndWarningsListener);
                    ++n2;
                }
            }
        };
    }

    public static BindingRegistration bindChangeListenersToForm(FormValidation<?> form, Collection<JTextField> fields) {
        return TextFieldUtils.bindChangeListenersToForm(form, fields.toArray(new JTextField[0]));
    }

    public static BindingRegistration bindChangeListenersToForm(final FormValidation<?> form, JTextField ... fields) {
        CompoundRegistration result = new CompoundRegistration();
        JTextField[] jTextFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            final JTextField each = jTextFieldArray[n2];
            final DocumentUpdateListener listener = new DocumentUpdateListener(){

                @Override
                public void update() {
                    form.validate();
                }
            };
            each.getDocument().addDocumentListener(listener);
            result.add(new BindingRegistration(){

                @Override
                public void removeRegistration() {
                    each.getDocument().removeDocumentListener(listener);
                }
            });
            ++n2;
        }
        return result;
    }

    public static BindingRegistration resetValueOnError(Collection<JTextField> fields) {
        return TextFieldUtils.resetValueOnError(fields.toArray(new JTextField[0]));
    }

    public static BindingRegistration resetValueOnError(JTextField ... fields) {
        CompoundRegistration result = new CompoundRegistration();
        JTextField[] jTextFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            final JTextField each = jTextFieldArray[n2];
            final FocusListener listener = new FocusListener(){
                String originalValue = "";

                @Override
                public void focusLost(FocusEvent e) {
                    if (DisplayMessageFactory.hasError(each)) {
                        TextFieldUtils.setValueOrText(each, this.originalValue);
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                    if (!DisplayMessageFactory.hasError(each) || this.originalValue.isEmpty()) {
                        String val = TextFieldUtils.getValueOrText(each, false);
                        this.originalValue = val != null ? val.toString() : null;
                    }
                }
            };
            each.addFocusListener(listener);
            result.add(new BindingRegistration(){

                @Override
                public void removeRegistration() {
                    each.removeFocusListener(listener);
                }
            });
            ++n2;
        }
        return result;
    }

    public static String getValueOrText(JTextComponent field) {
        return TextFieldUtils.getValueOrText(field, true);
    }

    public static String getValueOrText(JTextComponent field, boolean commit) {
        if (field instanceof JFormattedTextField) {
            return TextFieldUtils.getValueOrTextFromFormattedTextField((JFormattedTextField)field, commit);
        }
        return field.getText();
    }

    private static String getValueOrTextFromFormattedTextField(JFormattedTextField formattedTextField, boolean commit) {
        if (TextFieldUtils.isEdited(formattedTextField) && commit) {
            try {
                formattedTextField.commitEdit();
                Object val = formattedTextField.getValue();
                return val != null ? val.toString() : "";
            }
            catch (ParseException parseException) {
                return formattedTextField.getText();
            }
        }
        if (!TextFieldUtils.isTextParsable(formattedTextField)) {
            return formattedTextField.getText();
        }
        Object val = formattedTextField.getValue();
        if (val == null && formattedTextField.getDocument() != null) {
            val = formattedTextField.getText();
        }
        return val != null ? val.toString() : "";
    }

    private static boolean isTextParsable(JFormattedTextField field) {
        JFormattedTextField.AbstractFormatter formatter = field.getFormatter();
        if (formatter != null) {
            String text = field.getText();
            try {
                formatter.stringToValue(text);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private static boolean isEdited(JFormattedTextField jtf) {
        try {
            String roundedText = TextFieldUtils.getRoundedTextOrNull(jtf.getText(), jtf.getFormatter());
            String roundedValue = TextFieldUtils.getRoundedTextOrNull(jtf.getValue(), jtf.getFormatter());
            return !EqualsUtil.equals((Object)roundedValue, (Object)roundedText);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String getRoundedTextOrNull(Object text, JFormattedTextField.AbstractFormatter formatter) throws ParseException {
        if (text == null) {
            return null;
        }
        if (text.toString().isEmpty()) {
            return "";
        }
        return formatter.valueToString(TextFieldUtils.asDouble(text));
    }

    public static void setValueOrText(JTextField field, Object value) {
        if (field instanceof JFormattedTextField) {
            JFormattedTextField formattedTextfield = (JFormattedTextField)field;
            try {
                value = TextFieldUtils.asDouble(value);
                formattedTextfield.setValue(value);
            }
            catch (Exception exception) {
                field.setText("" + value);
            }
        } else {
            field.setText("" + value);
        }
    }

    private static Object asDouble(Object object) {
        if (object instanceof String) {
            object = PrimitiveUtils.parseDouble((String)object.toString());
        }
        return object;
    }

    public static interface PositionHolder {
        public int getPosition();
    }
}

