/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.text;

import com.ur.swing.AbstractPicker;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.InputPicker;
import com.ur.swing.impl.input.PlainEventDocument;
import com.ur.swing.text.KeyboardPanel;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationStrategy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class TextPicker
extends AbstractPicker {
    public static final String OK_BUTTON = "OK." + TextPicker.class.getSimpleName();
    public static final String BACKSPACE_BUTTON = "BACKSPACE." + TextPicker.class.getSimpleName();
    public static final String TEXT_PICKER_TEXT_FIELD = "TEXT_PICKER_TEXT_FIELD." + TextPicker.class.getSimpleName();
    public static final String TEXT_PICKER = "TEXT_PICKER." + TextPicker.class.getSimpleName();
    public static final String SHIFT_BUTTON = "SHIFT" + TextPicker.class.getSimpleName();
    public static final String SPACE_BAR = "SPACE_BAR" + TextPicker.class.getSimpleName();
    private static final CompoundBorder SELECTED_COMPONENT_BORDER = new CompoundBorder(new LineBorder(Color.DARK_GRAY, 1), new LineBorder(Color.LIGHT_GRAY, 2));
    public static final Border KEYBOARD_BORDER = UIManager.getBorder("TextPicker.border") == null ? BorderFactory.createLineBorder(Color.BLACK) : UIManager.getBorder("TextPicker.border");
    private InputMap inputMap;
    private ActionMap actionMap;
    private TextHolder provider = new DUMMY();

    public TextPicker(TextHolder provider) {
        this(provider, false, null, null);
    }

    public TextPicker(TextHolder provider, boolean isPasswordField) {
        this(provider, isPasswordField, null, null);
    }

    public TextPicker(TextHolder provider, boolean isPasswordField, String headLine) {
        this(provider, isPasswordField, headLine, null);
    }

    public TextPicker(TextHolder provider, boolean isPasswordField, ValidationStrategy validator) {
        this(provider, isPasswordField, null, validator);
    }

    public TextPicker(TextHolder provider, boolean isPasswordField, String headLine, ValidationStrategy validator) {
        super(TextPicker.createField(provider, isPasswordField));
        this.textField.setName(TEXT_PICKER_TEXT_FIELD);
        this.provider = provider;
        this.textField.setPreferredSize(new Dimension(KeyboardPanel.BUTTON_DIMENSIONS.width * 10, KeyboardPanel.BUTTON_DIMENSIONS.height));
        this.textField.setSize(KeyboardPanel.BUTTON_DIMENSIONS.width * 10, KeyboardPanel.BUTTON_DIMENSIONS.height);
        this.keyboardDialog.getRootPane().setWindowDecorationStyle(0);
        JPanel contentPane = (JPanel)this.keyboardDialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(KEYBOARD_BORDER);
        this.actionMap = contentPane.getActionMap();
        this.inputMap = contentPane.getInputMap(2);
        this.pressEscapeKey(this.textField);
        this.pressEnterKey();
        if (this.keyboardPanel != null) {
            this.keyboardDialog.getContentPane().remove(this.keyboardPanel);
        }
        this.keyboardPanel = validator != null ? new KeyboardPanel(this.textField, this, true, headLine, validator, new JButton[0]) : new KeyboardPanel(this.textField, this, true, headLine, new JButton[0]);
        this.keyboardDialog.getContentPane().add((Component)this.keyboardPanel, "Center");
        this.mapEnterAndEscape(this.textField);
        this.keyboardDialog.pack();
        if (isPasswordField) {
            this.setActiveRequest(InputPicker.Request.Cancel);
        }
    }

    private static JTextComponent createField(TextHolder provider, boolean isPasswordField) {
        JTextField jTextField = isPasswordField ? new JPasswordField() : new JTextField();
        jTextField.setDocument(new PlainEventDocument());
        jTextField.setText(provider.getText());
        return jTextField;
    }

    private void mapEnterAndEscape(JComponent jComponent) {
        InputMap iMap = jComponent.getInputMap(0);
        iMap.put(KeyStroke.getKeyStroke(10, 0), "Enter");
        iMap.put(KeyStroke.getKeyStroke(27, 0), "Escape");
        ActionMap aMap = this.textField.getActionMap();
        aMap.put("Enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextPicker.this.keyboardPanel.onSubmit();
            }
        });
        aMap.put("Escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextPicker.this.keyboardPanel.onCancel();
            }
        });
    }

    @Override
    public String getName() {
        return TEXT_PICKER;
    }

    @Override
    public void onShow() {
        Rectangle appFrameBounds = this.keyboardDialog.getParent().getBounds();
        int keyboardDialogY = appFrameBounds.y + appFrameBounds.height - this.keyboardDialog.getHeight();
        this.keyboardDialog.setBounds(appFrameBounds.x, keyboardDialogY, appFrameBounds.width, this.keyboardDialog.getHeight());
        this.keyboardDialog.setVisible(true);
    }

    @Override
    public void onApply() {
        this.provider.setText(this.textField.getText());
        this.completedListener.requestApply();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.provider = null;
        this.inputMap = null;
        this.actionMap = null;
    }

    public static boolean isSelected(Object border) {
        return SELECTED_COMPONENT_BORDER.equals(border);
    }

    private void pressEnterKey() {
        this.inputMap.put(KeyStroke.getKeyStroke("ENTER"), "Enter");
        this.actionMap.put("Enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextPicker.this.hideInputPanel(InputPicker.Request.Apply);
            }
        });
    }

    private void pressEscapeKey(final JTextComponent field) {
        this.inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "Escape");
        this.actionMap.put("Escape", new AbstractAction(){
            String originalText;
            {
                this.originalText = jTextComponent.getText();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                field.setText(this.originalText);
                TextPicker.this.hideInputPanel(InputPicker.Request.Cancel);
            }
        });
    }

    public void validateValue() {
        JTextComponent component = this.getTextField();
        if (component == null) {
            return;
        }
        Document document = component.getDocument();
        if (document instanceof PlainEventDocument) {
            ((PlainEventDocument)document).fireChangeEvent();
            this.setSubmitKeyEnabled(!DisplayMessageFactory.hasError(component));
        }
    }

    public void setSubmitKeyEnabled(boolean enabled) {
        if (this.keyboardPanel != null) {
            ((KeyboardPanel)this.keyboardPanel).setSubmitKeyEnabled(enabled);
        }
    }

    private static class DUMMY
    implements TextHolder {
        private DUMMY() {
        }

        @Override
        public String getText() {
            return "";
        }

        @Override
        public void setText(String text) {
        }
    }
}

