/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.text;

import com.ur.lang.EqualsUtil;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.units.ValueConverter;
import com.ur.util.logging.Log;
import java.lang.reflect.Method;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class UpdateBeanDocumentListener
implements DocumentListener {
    private final Object observer;
    private final JTextField observed;
    private Method setMethod;
    private final ValueConverter converter;

    UpdateBeanDocumentListener(JTextField observed, Object observer, String fieldName) {
        this(observed, observer, fieldName, ValueConverter.DUMMY_CONVERTER);
    }

    UpdateBeanDocumentListener(JTextField observed, Object observer, String fieldName, ValueConverter converter) {
        this.observer = observer;
        this.observed = observed;
        this.converter = converter;
        boolean getterFound = false;
        Method[] methodArray = observer.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method each = methodArray[n2];
            String methodName = each.getName().toLowerCase();
            if (methodName.equals("set" + fieldName.toLowerCase()) && each.getParameterTypes().length == 1) {
                this.setMethod = each;
            }
            if (methodName.equals("get" + fieldName.toLowerCase()) && each.getParameterTypes().length == 0) {
                getterFound = true;
                try {
                    String fromModel = (String)converter.fromModel(each.invoke(observer, new Object[0]));
                    String value = TextFieldUtils.getValueOrText(observed);
                    if (!EqualsUtil.equals((Object)fromModel, (Object)value)) {
                        TextFieldUtils.setValueOrText(observed, fromModel);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not invoke getter method for '" + fieldName + "' on object of type " + observed.getClass(), e);
                }
            }
            ++n2;
        }
        if (!getterFound) {
            throw new IllegalArgumentException("Getter method for '" + fieldName + "' could not be found on object of type " + observer.getClass());
        }
        if (this.setMethod == null) {
            throw new IllegalArgumentException("Setter method for '" + fieldName + "' could not be found on object of type " + observer.getClass());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateField();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateField();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateField();
    }

    private void updateField() {
        try {
            String text = TextFieldUtils.getValueOrText(this.observed);
            if (!text.isEmpty()) {
                Object convertedValue = this.converter.fromGui(text);
                this.setMethod.invoke(this.observer, convertedValue);
            }
        }
        catch (Exception ex) {
            Log.error((String)("Failed to invoke set method on " + this.observer + " with value " + this.observed.getText()), (Throwable)ex);
        }
    }
}

