/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.text.driver;

import com.ur.swing.ComponentDriver;
import com.ur.swing.JemmyUtils;
import com.ur.swing.text.TextPicker;
import com.ur.util.Waiting;
import java.awt.Component;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;

public class TextPickerOperator {
    private static final long WAIT_AFTER_BUTTON_PRESS = 500L;
    private static final long WAIT_FOR_TEXT_PICKER = 1000L;
    private final JDialogOperator textPicker;

    public TextPickerOperator(JTextComponentOperator textField) {
        textField.clickMouse();
        Waiting.pause((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.textPicker = new JDialogOperator(ComponentDriver.aComponent(TextPicker.TEXT_PICKER, ComponentDriver.showing()));
    }

    public TextPickerOperator() {
        this.textPicker = new JDialogOperator(ComponentDriver.aComponent(TextPicker.TEXT_PICKER, ComponentDriver.showing()));
    }

    public void setTextInField(String textInField) {
        new JTextFieldOperator((ContainerOperator)this.textPicker).setText(textInField);
    }

    public void typeFullText(String text) {
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char each = cArray[n2];
            if (Character.isUpperCase(each)) {
                this.clickShift();
            }
            if (each == ' ') {
                this.clickSpaceBar();
            } else {
                System.out.println(" finding: " + each);
                this.clickButtonWith("" + each);
            }
            ++n2;
        }
    }

    public void type(String text) {
        this.typeFullText(text);
        this.clickOkToClose();
    }

    public boolean isOkButtonEnabled() {
        return JemmyUtils.getButtonByName(this.textPicker, TextPicker.OK_BUTTON).isEnabled();
    }

    private void clickButtonWithName(String name) {
        JemmyUtils.getButtonByName(this.textPicker, name).pushNoBlock();
        Waiting.pause((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void clickButtonWith(final String text) {
        JButtonOperator operator = new JButtonOperator((ContainerOperator)this.textPicker, new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component instanceof JButton && ((JButton)component).getText().equals(text);
            }

            public String getDescription() {
                return null;
            }
        });
        operator.clickMouse();
        Waiting.pause((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void clickOkToClose() {
        this.clickButtonWithName(TextPicker.OK_BUTTON);
        this.waitToClose();
    }

    public void clickSpaceBar() {
        this.clickButtonWith(TextPicker.SPACE_BAR);
    }

    public void waitToClose() {
        Waiting.until((Waiting.ItHappens)this.isNotShowing(), (int)10000, (TimeUnit)TimeUnit.MILLISECONDS);
        Waiting.pause((long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    public void clickOk() {
        this.clickButtonWithName(TextPicker.OK_BUTTON);
    }

    public void clickBackSpaceToClose() {
        this.clickButtonWithName(TextPicker.BACKSPACE_BUTTON);
        this.waitToClose();
    }

    public void longPressBackSpace(int timeMillis) {
        JButtonOperator buttonByName = JemmyUtils.getButtonByName(this.textPicker, TextPicker.BACKSPACE_BUTTON);
        buttonByName.pressMouse();
        Waiting.pause((long)timeMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        buttonByName.releaseMouse();
        Waiting.pause((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void setTextSelection(int start, int stop) {
        JComponentOperator componentByName = JemmyUtils.getComponentByName(this.textPicker, TextPicker.TEXT_PICKER_TEXT_FIELD);
        JTextField jTextField = (JTextField)componentByName.getSource();
        jTextField.select(start, stop);
    }

    private Waiting.ItHappens isNotShowing() {
        return new Waiting.ItHappens(){

            public boolean itHappened() {
                return !TextPickerOperator.this.textPicker.isShowing();
            }
        };
    }

    private void clickShift() {
        this.clickButtonWithName(TextPicker.SHIFT_BUTTON);
        Waiting.pause((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void clickBackSpace(int times) {
        int i = 0;
        while (i < times) {
            this.clickButtonWithName(TextPicker.BACKSPACE_BUTTON);
            Waiting.pause((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            ++i;
        }
    }
}

