/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.units;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.math.Acceleration;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import java.text.Format;

@Deprecated
class AccelerationConverter
implements ValueConverter<String, Acceleration> {
    private final boolean forceSiUnits;

    AccelerationConverter(boolean forceSiUnits) {
        this.forceSiUnits = forceSiUnits;
    }

    @Override
    public Acceleration fromGui(String guiValue) {
        double value = PrimitiveUtils.parseDouble((String)guiValue, (double)0.0);
        if (this.forceSiUnits) {
            return Acceleration.from((double)value, (Acceleration.Unit)Acceleration.Unit.SI);
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return Acceleration.from((double)value, (Acceleration.Unit)Acceleration.Unit.INCH_S2);
        }
        return Acceleration.from((double)value, (Acceleration.Unit)Acceleration.Unit.MM_S2);
    }

    @Override
    public String fromModel(Acceleration modelValue) {
        if (this.forceSiUnits) {
            return String.valueOf(modelValue.getIn(Acceleration.Unit.SI));
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return String.valueOf(modelValue.getIn(Acceleration.Unit.INCH_S2));
        }
        return String.valueOf(modelValue.getIn(Acceleration.Unit.MM_S2));
    }

    @Override
    public String getUnit() {
        if (this.forceSiUnits) {
            return Units.getSiText().unitMS2();
        }
        return Units.getText().unitMmS2();
    }

    @Override
    public Format getFormat() {
        if (this.forceSiUnits) {
            return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.000");
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.00");
        }
        return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0");
    }
}

