/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.units;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.swing.i18n.UnitsResource;
import com.ur.swing.i18n.impl.UnitsResourceImpl;
import com.ur.swing.units.ImperialUnitsResourceConverter;
import com.ur.swing.units.SiUnitBundleConverter;
import com.ur.swing.units.UnitType;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.units.UnitsValueConverterFactory;
import com.ur.util.logging.Log;
import java.text.DecimalFormat;
import java.util.Locale;

@Deprecated
public class Units {
    private static final double M_TO_IN = 39.3701;
    private static final double KG_TO_LB = 2.20462262;
    private static final double N_TO_LB_FORCE = 0.224808943;
    private static final double NM_TO_LBFT = 0.7375621;
    private static final DecimalFormat ONE_DECIMAL = DecimalFormatFactory.createHalfEvenDecimalFormatWithLocale((String)"##0.0", (Locale)Locale.ENGLISH);
    private static final DecimalFormat TWO_DECIMALS = DecimalFormatFactory.createHalfEvenDecimalFormatWithLocale((String)"##0.00", (Locale)Locale.ENGLISH);
    private static final DecimalFormat THREE_DECIMALS = DecimalFormatFactory.createHalfEvenDecimalFormatWithLocale((String)"##0.000", (Locale)Locale.ENGLISH);
    private static final DecimalFormat ONE_TO_TWO_DECIMALS = DecimalFormatFactory.createHalfEvenDecimalFormatWithLocale((String)"##0.0#", (Locale)Locale.ENGLISH);
    private static final DecimalFormat ONE_TO_THREE_DECIMALS = DecimalFormatFactory.createHalfEvenDecimalFormatWithLocale((String)"##0.0##", (Locale)Locale.ENGLISH);
    private static final DecimalFormat DEFAULT_INCH_FORMAT = DecimalFormatFactory.createHalfEvenDecimalFormatWithLocale((String)"##0.00#", (Locale)Locale.ENGLISH);
    private static UnitsResource siUnitBundle;
    private static UnitsResource metricUnitsBundle;
    private static ImperialUnitsResourceConverter imperialUnitsBundle;
    private static UnitType unitType;

    static {
        Units.loadResourceBundles();
    }

    private Units() {
    }

    private static void loadResourceBundles() {
        Locale locale = Locale.getDefault();
        siUnitBundle = new SiUnitBundleConverter(locale);
        metricUnitsBundle = new UnitsResourceImpl(locale);
        imperialUnitsBundle = new ImperialUnitsResourceConverter(locale);
    }

    @Deprecated
    public static String getText(String key) {
        String keyText;
        try {
            keyText = Units.getText().get(key);
        }
        catch (Exception e) {
            Log.error((String)("Could not look up units key '" + key + "'."), (Throwable)e);
            keyText = "'" + key + "'";
        }
        return keyText;
    }

    public static UnitsResource getText() {
        if (unitType.isUS()) {
            return imperialUnitsBundle;
        }
        return metricUnitsBundle;
    }

    public static UnitsResource getSiText() {
        return siUnitBundle;
    }

    public static double convert_to_m(String n) {
        return Units.convert_to_m(PrimitiveUtils.parseDouble((String)n));
    }

    public static double convert_to_m(double n) {
        if (unitType.isUS()) {
            return Units.in_to_m(n);
        }
        return n / 1000.0;
    }

    public static String convert_from_m(String n) {
        return Units.convert_from_m(PrimitiveUtils.parseDouble((String)n));
    }

    public static String convert_from_m(double n) {
        if (unitType.isUS()) {
            return ONE_TO_THREE_DECIMALS.format(Units.m_to_in(n));
        }
        return ONE_TO_TWO_DECIMALS.format(n * 1000.0);
    }

    public static String convert_from_m_movetab(double n) {
        if (unitType.isUS()) {
            return THREE_DECIMALS.format(Units.m_to_in(n));
        }
        return TWO_DECIMALS.format(n * 1000.0);
    }

    public static String convert_from_m_max3dec(double n) {
        return Units.convert_from_m(n, ONE_TO_THREE_DECIMALS);
    }

    public static String convert_from_m(double n, DecimalFormat df) {
        if (unitType.isUS()) {
            return df.format(Units.m_to_in(n));
        }
        return df.format(n * 1000.0);
    }

    public static double convert_to_kg(double n) {
        if (unitType.isUS()) {
            return Units.lb_to_kg(n);
        }
        return n;
    }

    public static String convert_from_kg(double n) {
        if (unitType.isUS()) {
            return TWO_DECIMALS.format(Units.kg_to_lb(n));
        }
        return TWO_DECIMALS.format(n);
    }

    public static double convert_to_celsius(double n) {
        if (unitType.isUS()) {
            return Units.F_to_celsius(n);
        }
        return n;
    }

    public static String convert_from_celsius(double n) {
        if (unitType.isUS()) {
            return ONE_DECIMAL.format(Units.celsius_to_F(n));
        }
        return ONE_DECIMAL.format(n);
    }

    public static double convert_to_N(String n) {
        return Units.convert_to_N(PrimitiveUtils.parseDouble((String)n));
    }

    public static double convert_to_N(double n) {
        if (unitType.isUS()) {
            return Units.lb_force_to_N(n);
        }
        return n;
    }

    public static String convert_from_N(double n) {
        if (unitType.isUS()) {
            return ONE_TO_TWO_DECIMALS.format(Units.N_to_lb_force(n));
        }
        return ONE_TO_TWO_DECIMALS.format(n);
    }

    public static double convert_to_Nm(String n) {
        return Units.convert_to_Nm(PrimitiveUtils.parseDouble((String)n));
    }

    public static double convert_to_Nm(double n) {
        if (unitType.isUS()) {
            return Units.lbft_to_Nm(n);
        }
        return n;
    }

    public static String convert_from_Nm(double n) {
        if (unitType.isUS()) {
            return ONE_TO_TWO_DECIMALS.format(Units.Nm_to_lbft(n));
        }
        return ONE_TO_TWO_DECIMALS.format(n);
    }

    public static double convert_to_m_s(double n) {
        if (unitType.isUS()) {
            return Units.in_s_to_m_s(n);
        }
        return n / 1000.0;
    }

    public static double convert_to_m_s(String n) {
        return Units.convert_to_m_s(PrimitiveUtils.parseDouble((String)n));
    }

    public static String convert_from_m_s(double n, DecimalFormat metricFormat, DecimalFormat inchFormat) {
        if (unitType.isUS()) {
            return inchFormat.format(Units.m_s_to_in_s(n));
        }
        return metricFormat.format(n * 1000.0);
    }

    public static double convert_to_m_s2(String n) {
        return Units.convert_to_m_s2(PrimitiveUtils.parseDouble((String)n));
    }

    public static double convert_to_m_s2(double n) {
        if (unitType.isUS()) {
            return Units.in_s2_to_m_s2(n);
        }
        return n / 1000.0;
    }

    public static String convert_from_m_s2(double n, DecimalFormat metricFormat, DecimalFormat inchFormat) {
        if (unitType.isUS()) {
            return inchFormat.format(Units.m_s2_to_in_s2(n));
        }
        return metricFormat.format(n * 1000.0);
    }

    public static double convert_to_kg_m_s(double n) {
        if (unitType.isUS()) {
            return Units.lb_to_kg(Units.in_to_m(n));
        }
        return n;
    }

    public static String convert_from_kg_m_s(double n) {
        if (unitType.isUS()) {
            return ONE_DECIMAL.format(Units.kg_to_lb(Units.m_to_in(n)));
        }
        return ONE_DECIMAL.format(n);
    }

    private static double m_to_in(double m) {
        return m * 39.3701;
    }

    private static double in_to_m(double in) {
        return in / 39.3701;
    }

    private static double kg_to_lb(double kg) {
        return kg * 2.20462262;
    }

    private static double lb_to_kg(double lb) {
        return lb / 2.20462262;
    }

    public static double celsius_to_F(double C) {
        return C * 1.8 + 32.0;
    }

    public static double F_to_celsius(double F) {
        return (F - 32.0) * 0.5555555555555556;
    }

    private static double N_to_lb_force(double N) {
        return N * 0.224808943;
    }

    private static double lb_force_to_N(double lb_force) {
        return lb_force / 0.224808943;
    }

    private static double Nm_to_lbft(double Nm) {
        return Nm * 0.7375621;
    }

    private static double lbft_to_Nm(double lbft) {
        return lbft / 0.7375621;
    }

    private static double m_s_to_in_s(double m_s) {
        return m_s * 39.3701;
    }

    private static double in_s_to_m_s(double in_s) {
        return in_s / 39.3701;
    }

    private static double m_s2_to_in_s2(double m_s2) {
        return m_s2 * 39.3701;
    }

    private static double in_s2_to_m_s2(double in_s2) {
        return in_s2 / 39.3701;
    }

    public static UnitsConverter getKgConverter() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                return PrimitiveUtils.parseDouble((String)Units.convert_from_kg(value));
            }

            @Override
            public double convertTo(double value) {
                return Units.convert_to_kg(value);
            }

            @Override
            public String getUnit() {
                return Units.getText().unitKg();
            }
        };
    }

    public static UnitsConverter getKgMsConverter() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                return PrimitiveUtils.parseDouble((String)Units.convert_from_kg_m_s(value));
            }

            @Override
            public double convertTo(double value) {
                return Units.convert_to_kg_m_s(value);
            }

            @Override
            public String getUnit() {
                return Units.getText().unitKgMS();
            }
        };
    }

    public static UnitsConverter getKgMsConverterSI() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                return value;
            }

            @Override
            public double convertTo(double value) {
                return value;
            }

            @Override
            public String getUnit() {
                return metricUnitsBundle.unitKgMS();
            }
        };
    }

    public static UnitsConverter getTorqueConverter() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                return PrimitiveUtils.parseDouble((String)Units.convert_from_Nm(value));
            }

            @Override
            public double convertTo(double value) {
                return Units.convert_to_Nm(value);
            }

            @Override
            public String getUnit() {
                return Units.getText().unitNm();
            }
        };
    }

    public static UnitsConverter getNewtonsConverter() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                return PrimitiveUtils.parseDouble((String)Units.convert_from_N(value));
            }

            @Override
            public double convertTo(double value) {
                return Units.convert_to_N(value);
            }

            @Override
            public String getUnit() {
                return Units.getText().unitN();
            }
        };
    }

    public static UnitsConverter getNewtonsConverterSI() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                return value;
            }

            @Override
            public double convertTo(double value) {
                return value;
            }

            @Override
            public String getUnit() {
                return metricUnitsBundle.unitN();
            }
        };
    }

    public static UnitsConverter getWattConverter() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                return value;
            }

            @Override
            public double convertTo(double value) {
                return value;
            }

            @Override
            public String getUnit() {
                return Units.getText().unitW();
            }
        };
    }

    public static UnitsConverter getMetersConverter() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double controllerValue) {
                return PrimitiveUtils.parseDouble((String)Units.convert_from_m(controllerValue));
            }

            @Override
            public double convertTo(double guiValue) {
                return Units.convert_to_m(guiValue);
            }

            @Override
            public String getUnit() {
                return Units.getText().unitMm();
            }
        };
    }

    public static UnitsConverter getMmSConverter() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                if (unitType.isUS()) {
                    return Units.m_s_to_in_s(value / 1000.0);
                }
                return value;
            }

            @Override
            public double convertTo(double value) {
                if (unitType.isUS()) {
                    return Units.in_s_to_m_s(value) * 1000.0;
                }
                return value;
            }

            @Override
            public String getUnit() {
                return Units.getText().unitMmS();
            }
        };
    }

    public static UnitsConverter getMmConverter() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                if (unitType.isUS()) {
                    return Units.m_to_in(value / 1000.0);
                }
                return value;
            }

            @Override
            public double convertTo(double value) {
                if (unitType.isUS()) {
                    return Units.in_to_m(value) * 1000.0;
                }
                return value;
            }

            @Override
            public String getUnit() {
                return Units.getText().unitMm();
            }
        };
    }

    public static UnitsConverter getMmPerSecondConverter() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                if (unitType.isUS()) {
                    return Units.m_s_to_in_s(value);
                }
                return value * 1000.0;
            }

            @Override
            public double convertTo(double value) {
                if (unitType.isUS()) {
                    return Units.in_s_to_m_s(value);
                }
                return value / 1000.0;
            }

            @Override
            public String getUnit() {
                return Units.getText().unitMmS();
            }
        };
    }

    public static UnitsConverter getMmPerSecond2Converter() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                if (unitType.isUS()) {
                    return Units.m_s2_to_in_s2(value);
                }
                return value * 1000.0;
            }

            @Override
            public double convertTo(double value) {
                if (unitType.isUS()) {
                    return Units.in_s2_to_m_s2(value);
                }
                return value / 1000.0;
            }

            @Override
            public String getUnit() {
                return Units.getText().unitMmS2();
            }
        };
    }

    public static UnitsConverter getMetersPerSecondConverterSI() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double controllerValue) {
                return controllerValue;
            }

            @Override
            public double convertTo(double guiValue) {
                return guiValue;
            }

            @Override
            public String getUnit() {
                return Units.getText().unitMS();
            }
        };
    }

    public static UnitsConverter getDegreesConverter() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                return Math.toDegrees(value);
            }

            @Override
            public double convertTo(double value) {
                return Math.toRadians(value);
            }

            @Override
            public String getUnit() {
                return Units.getText().unitDegrees();
            }
        };
    }

    public static UnitsConverter getRadiansConverter() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                return value;
            }

            @Override
            public double convertTo(double value) {
                return value;
            }

            @Override
            public String getUnit() {
                return Units.getText().unitRad();
            }
        };
    }

    public static UnitsConverter getDegreesPerSecondConverter() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                return Math.toDegrees(value);
            }

            @Override
            public double convertTo(double value) {
                return Math.toRadians(value);
            }

            @Override
            public String getUnit() {
                return Units.getText().unitDegS();
            }
        };
    }

    public static UnitsConverter getDegreesPerSecond2Converter() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                return Math.toDegrees(value);
            }

            @Override
            public double convertTo(double value) {
                return Math.toRadians(value);
            }

            @Override
            public String getUnit() {
                return Units.getText().unitDegS2();
            }
        };
    }

    public static UnitsConverter getRadiansPerSecondConverterSI() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double value) {
                return value;
            }

            @Override
            public double convertTo(double value) {
                return value;
            }

            @Override
            public String getUnit() {
                return Units.getText().unitRadS();
            }
        };
    }

    public static UnitsConverter getTimeConverter() {
        return new UnitsConverter(){

            @Override
            public double convertFrom(double controllerValue) {
                return controllerValue * 1000.0;
            }

            @Override
            public double convertTo(double guiValue) {
                return guiValue / 1000.0;
            }

            @Override
            public String getUnit() {
                return Units.getText().unitMs();
            }
        };
    }

    public static void setUnitType(UnitType unitType) {
        Units.unitType = unitType;
        UnitsValueConverterFactory.setUnitType(unitType);
    }
}

