/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.units;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.Defense;
import com.ur.lang.PrimitiveUtils;
import com.ur.swing.units.UnitsConverter;
import java.text.Format;
import java.text.NumberFormat;

public interface ValueConverter<G, M> {
    public static final ValueConverter<String, String> DUMMY_CONVERTER = new StringConverter();
    public static final IntegerConverter INTEGER_CONVERTER = new IntegerConverter();

    public M fromGui(G var1);

    public G fromModel(M var1);

    public String getUnit();

    public Format getFormat();

    public static class DoubleConverter
    implements ValueConverter<String, Double> {
        private double defaultValue = 0.0;
        private final UnitsConverter conversionConverter;
        private NumberFormat formatter;

        public DoubleConverter(UnitsConverter conversionConverter) {
            this(conversionConverter, "##0.0");
        }

        public DoubleConverter(UnitsConverter conversionConverter, String formatter) {
            Defense.notNull((Object)conversionConverter, (String)"Must provide a conversion converter");
            this.conversionConverter = conversionConverter;
            this.formatter = DecimalFormatFactory.createHalfEvenDecimalFormat((String)formatter);
        }

        public DoubleConverter(UnitsConverter conversionConverter, NumberFormat formatter) {
            Defense.notNull((Object)conversionConverter, (String)"Must provide a conversion converter");
            this.conversionConverter = conversionConverter;
            this.formatter = formatter;
        }

        @Override
        public Double fromGui(String guiValue) {
            try {
                return this.conversionConverter.convertTo(PrimitiveUtils.parseDouble((String)guiValue, (double)this.defaultValue));
            }
            catch (Exception exception) {
                return this.defaultValue;
            }
        }

        @Override
        public String fromModel(Double modelValue) {
            try {
                if (this.formatter == null) {
                    return String.valueOf(this.conversionConverter.convertFrom(modelValue));
                }
                return this.formatter.format(this.conversionConverter.convertFrom(modelValue));
            }
            catch (Exception exception) {
                return "";
            }
        }

        @Override
        public String getUnit() {
            return this.conversionConverter.getUnit();
        }

        @Override
        public Format getFormat() {
            return this.formatter;
        }
    }

    public static class IntegerConverter
    implements ValueConverter<String, Integer> {
        private NumberFormat formatter = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0");

        @Override
        public Integer fromGui(String guiValue) {
            return Integer.parseInt(guiValue);
        }

        @Override
        public String fromModel(Integer modelValue) {
            return modelValue.toString();
        }

        @Override
        public String getUnit() {
            return "";
        }

        @Override
        public Format getFormat() {
            return this.formatter;
        }
    }

    public static class SimpleDoubleConverter
    implements ValueConverter<String, Double> {
        private double defaultValue = 0.0;
        private final UnitsConverter conversionConverter;

        public SimpleDoubleConverter(UnitsConverter conversionConverter) {
            this.conversionConverter = conversionConverter;
        }

        @Override
        public Double fromGui(String guiValue) {
            try {
                return this.conversionConverter.convertTo(PrimitiveUtils.parseDouble((String)guiValue, (double)this.defaultValue));
            }
            catch (Exception exception) {
                return this.defaultValue;
            }
        }

        @Override
        public String fromModel(Double modelValue) {
            try {
                return String.valueOf(this.conversionConverter.convertFrom(modelValue));
            }
            catch (Exception exception) {
                return "";
            }
        }

        @Override
        public String getUnit() {
            return this.conversionConverter.getUnit();
        }

        @Override
        public Format getFormat() {
            return null;
        }
    }

    public static class SimpleUnitConverter
    extends StringConverter {
        private final String units;

        public SimpleUnitConverter(String units) {
            this.units = units;
        }

        @Override
        public String getUnit() {
            return this.units;
        }
    }

    public static class StringConverter
    implements ValueConverter<String, String> {
        @Override
        public String fromGui(String guiValue) {
            return guiValue;
        }

        @Override
        public String fromModel(String modelValue) {
            return modelValue;
        }

        @Override
        public String getUnit() {
            return "";
        }

        @Override
        public Format getFormat() {
            return null;
        }
    }
}

