/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.validation;

import com.ur.lang.PrimitiveUtils;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.swing.validation.ValidationStrategyDecorator;

public class AutoCorrectionRangeDecorator
extends ValidationStrategyDecorator
implements AutoCorrectionValidator {
    protected final double minimum;
    protected final double maximum;

    public AutoCorrectionRangeDecorator(ValidationStrategy strategy, double minimum, double maximum) {
        super(strategy);
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public String getNearestValidValue(String uncheckedString) {
        try {
            double parseDouble = PrimitiveUtils.parseDouble((String)uncheckedString);
            if (parseDouble < this.minimum) {
                return String.valueOf(this.minimum);
            }
            if (parseDouble > this.maximum) {
                return String.valueOf(this.maximum);
            }
            return uncheckedString;
        }
        catch (Exception exception) {
            return String.valueOf(this.minimum);
        }
    }
}

