/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.validation;

import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.swing.validation.ValidationStrategyDecorator;
import java.math.BigInteger;

public class AutoCorrectionRangeLongDecorator
extends ValidationStrategyDecorator
implements AutoCorrectionValidator {
    protected final long minimum;
    protected final long maximum;

    public AutoCorrectionRangeLongDecorator(ValidationStrategy strategy, long minimum, long maximum) {
        super(strategy);
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public String getNearestValidValue(String uncheckedString) {
        try {
            BigInteger parsedLong = new BigInteger(uncheckedString);
            BigInteger max = BigInteger.valueOf(this.maximum);
            BigInteger min = BigInteger.valueOf(this.minimum);
            if (parsedLong.compareTo(min) <= 0) {
                return String.valueOf(this.minimum);
            }
            if (parsedLong.compareTo(max) >= 0) {
                return String.valueOf(this.maximum);
            }
            return uncheckedString;
        }
        catch (Exception exception) {
            return String.valueOf(this.minimum);
        }
    }
}

