/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.validation;

import com.ur.lang.StringUtils;
import com.ur.swing.validation.ValidationStrategy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RegexStrategyValidator
implements ValidationStrategy {
    @Override
    public boolean isValid(String uncheckedString) {
        String[] patterns = this.getPatterns();
        return this.createMatcher(uncheckedString, patterns).matches();
    }

    protected abstract String[] getPatterns();

    protected Matcher createMatcher(String uncheckedString, String ... patterns) {
        String joinedPattern = StringUtils.joinStringsWith((String)"|", (Object[])patterns);
        Pattern validPattern = joinedPattern.length() == 1 ? Pattern.compile("^" + joinedPattern + "$") : Pattern.compile("^(" + joinedPattern + ")$");
        Matcher matcher = validPattern.matcher(uncheckedString);
        return matcher;
    }

    @Override
    public String getErrorMessage(String text) {
        return "";
    }
}

