/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.validation;

import com.ur.swing.ComponentErrorable;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.validation.FormValidation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class SwingFormValidation
implements FormValidation<JComponent> {
    private Map<JComponent, List<FormValidation.Validator>> errorValidators = new HashMap<JComponent, List<FormValidation.Validator>>();
    private Map<JComponent, List<FormValidation.Validator>> warningValidators = new HashMap<JComponent, List<FormValidation.Validator>>();
    private List<FormValidation.FormListener<JComponent>> listeners = new ArrayList<FormValidation.FormListener<JComponent>>();

    @Override
    public void addErrorValidation(JComponent widget, FormValidation.Validator strategy) {
        List<FormValidation.Validator> widgetValidators;
        if (!this.errorValidators.containsKey(widget)) {
            this.errorValidators.put(widget, new ArrayList());
        }
        if (!(widgetValidators = this.errorValidators.get(widget)).contains(strategy)) {
            widgetValidators.add(strategy);
        }
    }

    @Override
    public void removeErrorValidation(JComponent widget, FormValidation.Validator strategy) {
        this.errorValidators.get(widget).remove(strategy);
    }

    @Override
    public void addWarningValidation(JComponent widget, FormValidation.Validator strategy) {
        if (!this.warningValidators.containsKey(widget)) {
            this.warningValidators.put(widget, new ArrayList());
        }
        this.warningValidators.get(widget).add(strategy);
    }

    @Override
    public void removeWarningValidation(JComponent widget, FormValidation.Validator strategy) {
        this.warningValidators.get(widget).remove(strategy);
    }

    @Override
    public void clearStrategiesFor(JComponent widget) {
        this.errorValidators.remove(widget);
        this.warningValidators.remove(widget);
    }

    @Override
    public void validate() {
        HashSet<JComponent> widgets = new HashSet<JComponent>();
        widgets.addAll(this.errorValidators.keySet());
        widgets.addAll(this.warningValidators.keySet());
        for (JComponent each : widgets) {
            this.checkValidity(each);
        }
        this.fireFormState();
    }

    private void fireFormState() {
        if (this.hasErrors()) {
            for (FormValidation.FormListener<JComponent> each : this.listeners) {
                each.formHasError(this);
            }
        } else if (this.hasWarnings()) {
            for (FormValidation.FormListener<JComponent> each : this.listeners) {
                each.formHasWarning(this);
            }
        } else {
            for (FormValidation.FormListener<JComponent> each : this.listeners) {
                each.formIsOK(this);
            }
        }
    }

    private void checkValidity(JComponent each) {
        if (this.errorValidators.containsKey(each) && this.hasInvalidValidator(this.errorValidators.get(each))) {
            if (this.warningValidators.containsKey(each)) {
                this.clearAllFor(this.warningValidators.get(each));
            }
        } else if (this.warningValidators.containsKey(each) && this.hasInvalidValidator(this.warningValidators.get(each))) {
            return;
        }
    }

    private boolean hasInvalidValidator(List<FormValidation.Validator> list) {
        boolean result = false;
        for (FormValidation.Validator each : list) {
            if (result) {
                each.clearValidation();
                continue;
            }
            each.validate();
            if (each.isValid()) continue;
            result = true;
        }
        return result;
    }

    private void clearAllFor(List<FormValidation.Validator> validators) {
        for (FormValidation.Validator each : validators) {
            each.clearValidation();
        }
    }

    @Override
    public boolean hasErrors() {
        return this.isInvalid(this.errorValidators.values());
    }

    @Override
    public boolean hasErrors(JComponent widget) {
        return this.hasInvalidValidators(this.errorValidators.get(widget));
    }

    @Override
    public boolean hasWarnings() {
        return this.isInvalid(this.warningValidators.values());
    }

    @Override
    public boolean hasWarnings(JComponent widget) {
        return this.hasInvalidValidators(this.warningValidators.get(widget));
    }

    private boolean hasInvalidValidators(List<FormValidation.Validator> validators) {
        if (validators == null) {
            return false;
        }
        for (FormValidation.Validator eachValidator : validators) {
            if (eachValidator.isValid()) continue;
            return true;
        }
        return false;
    }

    private boolean isInvalid(Collection<List<FormValidation.Validator>> validators) {
        for (List<FormValidation.Validator> each : validators) {
            if (!this.hasInvalidValidators(each)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearValidation() {
        for (List<FormValidation.Validator> list : this.errorValidators.values()) {
            this.clearAllFor(list);
        }
        for (List<FormValidation.Validator> list : this.warningValidators.values()) {
            this.clearAllFor(list);
        }
        for (JComponent jComponent : this.errorValidators.keySet()) {
            if (jComponent instanceof ComponentErrorable) {
                ((ComponentErrorable)((Object)jComponent)).clearError();
                continue;
            }
            jComponent.setBackground(DisplayMessageFactory.OK_COLOR);
        }
        for (JComponent jComponent : this.warningValidators.keySet()) {
            if (jComponent instanceof ComponentErrorable) {
                ((ComponentErrorable)((Object)jComponent)).clearWarning();
                continue;
            }
            jComponent.setBackground(DisplayMessageFactory.OK_COLOR);
        }
    }

    @Override
    public void addFormListener(FormValidation.FormListener<JComponent> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeFormListener(FormValidation.FormListener<JComponent> listener) {
        this.listeners.remove(listener);
    }

    public void clearForm() {
        this.clearValidation();
        this.errorValidators.clear();
        this.warningValidators.clear();
        this.listeners.clear();
    }
}

