/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.validation;

import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.DocumentUpdateListener;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.validation.ValidationStrategy;
import java.awt.Color;
import javax.swing.text.JTextComponent;

public class ValidationDocumentListener
extends DocumentUpdateListener {
    private final JTextComponent field;
    private final ValidationStrategy errorValidator;
    private final Color validColor = DisplayMessageFactory.OK_COLOR;
    private final ValidationStrategy warningValidator;
    private ValidationStrategy nonTypicalValidator;

    public ValidationDocumentListener(JTextComponent field, ValidationStrategy errorValidator) {
        this(field, errorValidator, ValidationStrategy.ALWAYS_VALID, ValidationStrategy.ALWAYS_VALID);
    }

    public ValidationDocumentListener(JTextComponent field, ValidationStrategy errorValidator, ValidationStrategy warningValidator, ValidationStrategy nonTypicalValidator) {
        this.field = field;
        this.errorValidator = errorValidator;
        this.warningValidator = warningValidator;
        this.nonTypicalValidator = nonTypicalValidator;
        try {
            if (!errorValidator.isValid(field.getText())) {
                field.setBackground(DisplayMessageFactory.ERROR_COLOR);
            } else if (!warningValidator.isValid(field.getText())) {
                field.setBackground(DisplayMessageFactory.WARNING_COLOR);
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void update() {
        String uncheckedText = TextFieldUtils.getValueOrText(this.field);
        if (!this.errorValidator.isValid(uncheckedText)) {
            DisplayMessageFactory.error(this.field, this.errorValidator.getErrorMessage(uncheckedText));
            return;
        }
        if (DisplayMessageFactory.hasError(this.field)) {
            this.field.setBackground(this.validColor);
            DisplayMessageFactory.removeRegistration(this.field);
        }
        if (!this.warningValidator.isValid(uncheckedText)) {
            DisplayMessageFactory.warn(this.field, this.warningValidator.getErrorMessage(uncheckedText));
        } else if (!this.nonTypicalValidator.isValid(uncheckedText)) {
            DisplayMessageFactory.informAndHighlight(this.field, this.nonTypicalValidator.getErrorMessage(uncheckedText));
        } else {
            this.field.setBackground(this.validColor);
            DisplayMessageFactory.removeRegistration(this.field);
        }
    }
}

