/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.validation;

import com.ur.bean.ReflectUtils;
import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.swing.InputOperation;
import com.ur.swing.SwingLanguagePack;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.validation.IpAddressValidator;
import com.ur.swing.validation.ValidationStrategy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JTextField;

public class ValidationFactory {
    private static final double DEGREES_PER_RAD = 57.29577951308232;
    private static ValidationStrategy expressionValueValidator = new ValidationStrategy(){
        Pattern number = Pattern.compile("-?(\\d+|\\d+\\.|\\.\\d)\\d*([Ee][-+]?\\d+)?");
        Pattern bool = Pattern.compile("(True|False)");
        Pattern quotedString = Pattern.compile("\"[\\w\\d\\s,.!#%&/()?':;@]*\"");
        Pattern pose = Pattern.compile("p\\[\\s*" + this.number + "(\\s*,\\s*" + this.number + "){5}\\s*]");
        Pattern[] expressionValueTypes = new Pattern[]{this.number, this.bool, this.quotedString, this.pose};

        @Override
        public boolean isValid(String uncheckedString) {
            if (uncheckedString.isEmpty()) {
                return false;
            }
            if (uncheckedString.startsWith("[") && uncheckedString.endsWith("]")) {
                List<String> uncheckedSubstrings = this.splitArray(uncheckedString.substring(1, uncheckedString.length() - 1));
                if (uncheckedSubstrings.isEmpty()) {
                    return false;
                }
                Pattern arrayType = null;
                for (String substring : uncheckedSubstrings) {
                    if (!(substring = substring.trim()).isEmpty() || uncheckedSubstrings.size() != 1) {
                        if (!(arrayType == null ? (arrayType = this.determineValueType(substring)) == null : !arrayType.matcher(substring).matches())) continue;
                        return false;
                    }
                    break;
                }
            } else {
                return this.determineValueType(uncheckedString) != null;
            }
            return true;
        }

        private List<String> splitArray(String arrayVariable) {
            ArrayList<String> results = new ArrayList<String>();
            int start = 0;
            int nestingLevel = 0;
            boolean insideString = false;
            int position = 0;
            while (position < arrayVariable.length()) {
                char ch = arrayVariable.charAt(position);
                if (ch == '\"') {
                    insideString = !insideString;
                } else if (ch == ',' && nestingLevel == 0 && !insideString) {
                    this.addToArrayIfValid(results, arrayVariable, start, position);
                    start = position + 1;
                } else if (ch == '[' && !insideString) {
                    ++nestingLevel;
                } else if (ch == ']' && !insideString) {
                    --nestingLevel;
                }
                ++position;
            }
            this.addToArrayIfValid(results, arrayVariable, start, position);
            return results;
        }

        private void addToArrayIfValid(List<String> list, String str, int start, int end) {
            if (start > end) {
                return;
            }
            if (start > str.length() || end > str.length()) {
                return;
            }
            list.add(str.substring(start, end));
        }

        private Pattern determineValueType(String uncheckedString) {
            Pattern[] patternArray = this.expressionValueTypes;
            int n = this.expressionValueTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern valueExpression = patternArray[n2];
                if (valueExpression.matcher(uncheckedString).matches()) {
                    return valueExpression;
                }
                ++n2;
            }
            return null;
        }

        @Override
        public String getErrorMessage(String uncheckedString) {
            return "";
        }
    };
    private static ValidationStrategy valueValidator = new ValidationStrategy(){

        @Override
        public boolean isValid(String uncheckedString) {
            try {
                double parseDouble = PrimitiveUtils.parseDouble((String)uncheckedString);
                return -1.7976931348623157E308 <= parseDouble && parseDouble <= Double.MAX_VALUE;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        @Override
        public String getErrorMessage(String text) {
            if (StringUtils.isNullOrOnlyWhitespace((String)(text = text.replace(',', '.'))) || StringUtils.equalsAny((String)text, (String[])new String[]{".", "-", "-."})) {
                return "";
            }
            try {
                PrimitiveUtils.parseDouble((String)text);
                return "";
            }
            catch (NumberFormatException numberFormatException) {
                return SwingLanguagePack.getTextResource().notANumber();
            }
        }
    };
    private static ValidationStrategy positiveNumberValidator = new ValidationStrategy(){

        @Override
        public boolean isValid(String uncheckedString) {
            if (StringUtils.isNullOrOnlyWhitespace((String)uncheckedString)) {
                return true;
            }
            try {
                double parseDouble = PrimitiveUtils.parseDouble((String)uncheckedString);
                return parseDouble >= 0.0 && parseDouble <= Double.MAX_VALUE;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        @Override
        public String getErrorMessage(String text) {
            if (StringUtils.isNullOrOnlyWhitespace((String)(text = text.replace(',', '.'))) || ".".equals(text)) {
                return "";
            }
            if (StringUtils.equalsAny((String)text, (String[])new String[]{"-", "-."})) {
                return SwingLanguagePack.getTextResource().errorPleaseEnterAPositiveInteger();
            }
            try {
                double value = PrimitiveUtils.parseDouble((String)text);
                if (value < 0.0) {
                    return SwingLanguagePack.getTextResource().errorPleaseEnterAPositiveInteger();
                }
                return "";
            }
            catch (NumberFormatException numberFormatException) {
                return SwingLanguagePack.getTextResource().notANumber();
            }
        }
    };
    private static ValidationStrategy ipAddressValidator = new IpAddressValidator();
    private static ValidationStrategy emptyFieldvalidator = new ValidationStrategy(){

        @Override
        public boolean isValid(String uncheckedString) {
            return !StringUtils.isNullOrOnlyWhitespace((String)uncheckedString);
        }

        @Override
        public String getErrorMessage(String uncheckedString) {
            return SwingLanguagePack.getTextResource().fieldCannotBeBlank();
        }
    };
    private static ValidationStrategy emptyFieldvalidatorNoErrorMessage = new ValidationStrategy(){

        @Override
        public boolean isValid(String uncheckedString) {
            return !StringUtils.isNullOrOnlyWhitespace((String)uncheckedString);
        }

        @Override
        public String getErrorMessage(String uncheckedString) {
            return "";
        }
    };
    private static ValidationStrategy hiddenFileSystemValidator = new ValidationStrategy(){

        @Override
        public boolean isValid(String uncheckedString) {
            return !uncheckedString.startsWith(".");
        }

        @Override
        public String getErrorMessage(String uncheckedString) {
            return SwingLanguagePack.getTextResource().leadingCharacter();
        }
    };
    private static ValidationStrategy fileSystemCharacterValidator = new ValidationStrategy(){

        @Override
        public boolean isValid(String dirName) {
            return !dirName.matches(".*?[#%&{}\\\\|<>*?/$!'\":@,^;=()+].*?");
        }

        @Override
        public String getErrorMessage(String uncheckedString) {
            return SwingLanguagePack.getTextResource().invalidCharactersInName();
        }
    };
    private static ValidationStrategy fileSystemNameValidator = new ValidationStrategy(){

        @Override
        public boolean isValid(String uncheckedString) {
            return hiddenFileSystemValidator.isValid(uncheckedString) && fileSystemCharacterValidator.isValid(uncheckedString) && emptyFieldvalidatorNoErrorMessage.isValid(uncheckedString);
        }

        @Override
        public String getErrorMessage(String uncheckedString) {
            if (!emptyFieldvalidatorNoErrorMessage.isValid(uncheckedString)) {
                return emptyFieldvalidatorNoErrorMessage.getErrorMessage(uncheckedString);
            }
            if (!hiddenFileSystemValidator.isValid(uncheckedString)) {
                return hiddenFileSystemValidator.getErrorMessage(uncheckedString);
            }
            return fileSystemCharacterValidator.getErrorMessage(uncheckedString);
        }
    };

    public static ValidationStrategy getExpressionValueValidator() {
        return expressionValueValidator;
    }

    public static ValidationStrategy getNumberValidator() {
        return valueValidator;
    }

    public static ValidationStrategy getPositiveNumberValidator() {
        return positiveNumberValidator;
    }

    public static ValidationStrategy getIpAddressValidator() {
        return ipAddressValidator;
    }

    public static ValidationStrategy getCannotBeEmptyValidator() {
        return emptyFieldvalidator;
    }

    public static ValidationStrategy getCannotBeEmptyValidatorNoErrorMessage() {
        return emptyFieldvalidatorNoErrorMessage;
    }

    public static ValidationStrategy getTextWidthLimitValidator(int maximumTextWidth) {
        return new TextWidthValidationStrategy(maximumTextWidth);
    }

    public static ValidationStrategy getFileSystemCharacterValidator() {
        return fileSystemCharacterValidator;
    }

    public static ValidationStrategy getFileSystemNameValidator() {
        return fileSystemNameValidator;
    }

    public static ValidationStrategy getRangeValidator(final Object lowerLimitContainer, final Object upperLimitContainer, final String propertyName, final String errorMessage) {
        return new ValidationStrategy(){

            @Override
            public boolean isValid(String uncheckedString) {
                try {
                    double minimum = PrimitiveUtils.parseDouble((String)((String)ReflectUtils.getProperty((Object)lowerLimitContainer, (String)propertyName, (Object)"9223372036854775807")));
                    double maximum = PrimitiveUtils.parseDouble((String)((String)ReflectUtils.getProperty((Object)upperLimitContainer, (String)propertyName, (Object)"-9223372036854775808")));
                    double parseDouble = PrimitiveUtils.parseDouble((String)uncheckedString);
                    return parseDouble >= minimum && parseDouble <= maximum;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }

            @Override
            public String getErrorMessage(String text) {
                if ((text = text.replace(',', '.')).isEmpty() || StringUtils.equalsAny((String)text, (String[])new String[]{".", "-", "-."})) {
                    return "";
                }
                try {
                    PrimitiveUtils.parseDouble((String)text);
                }
                catch (NumberFormatException numberFormatException) {
                    return SwingLanguagePack.getTextResource().notANumber();
                }
                return errorMessage;
            }
        };
    }

    public static ValidationStrategy getRangeValidator(final Object lowerLimitContainer, final String propertyName, final double maximum, final String errorMessage) {
        return new ValidationStrategy(){

            @Override
            public boolean isValid(String uncheckedString) {
                try {
                    double minimum = PrimitiveUtils.parseDouble((String)((String)ReflectUtils.getProperty((Object)lowerLimitContainer, (String)propertyName, (Object)"9223372036854775807")));
                    double parseDouble = PrimitiveUtils.parseDouble((String)uncheckedString);
                    return parseDouble >= minimum && parseDouble <= maximum;
                }
                catch (NullPointerException nullPointerException) {
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }

            @Override
            public String getErrorMessage(String text) {
                if ((text = text.replace(',', '.')).isEmpty() || StringUtils.equalsAny((String)text, (String[])new String[]{".", "-", "-."})) {
                    return "";
                }
                try {
                    PrimitiveUtils.parseDouble((String)text);
                }
                catch (NumberFormatException numberFormatException) {
                    return SwingLanguagePack.getTextResource().notANumber();
                }
                return errorMessage;
            }
        };
    }

    public static ValidationStrategy getRangeValidator(final double minimum, final Object upperLimitContainer, final String propertyName, final String errorMessage) {
        return new ValidationStrategy(){
            private double minimumValue;
            {
                this.minimumValue = d;
            }

            @Override
            public boolean isValid(String uncheckedString) {
                try {
                    double maximum = this.getValueFromUpperLimitContainer(upperLimitContainer, propertyName);
                    double parseDouble = PrimitiveUtils.parseDouble((String)uncheckedString);
                    return parseDouble >= this.minimumValue && parseDouble <= maximum;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }

            private Double getValueFromUpperLimitContainer(Object upperLimitContainer2, String propertyName2) {
                try {
                    return PrimitiveUtils.parseDouble((String)((String)ReflectUtils.getProperty((Object)upperLimitContainer2, (String)propertyName2, (Object)"9223372036854775807")));
                }
                catch (Exception exception) {
                    return Double.NaN;
                }
            }

            @Override
            public String getErrorMessage(String text) {
                if ((text = text.replace(',', '.')).isEmpty() || StringUtils.equalsAny((String)text, (String[])new String[]{".", "-", "-."})) {
                    return "";
                }
                try {
                    PrimitiveUtils.parseDouble((String)text);
                }
                catch (NumberFormatException numberFormatException) {
                    return SwingLanguagePack.getTextResource().notANumber();
                }
                return errorMessage;
            }

            public String toString() {
                return "getRangeValidator(" + minimum + ", " + this.getValueFromUpperLimitContainer(upperLimitContainer, propertyName) + ", \"" + errorMessage + "\")";
            }
        };
    }

    public static ValidationStrategy getRangeValidator(double minimum, double maximum, String errorMessage) {
        return ValidationFactory.getRangeValidator(minimum, maximum, false, errorMessage);
    }

    public static ValidationStrategy getRangeValidator(double minimum, double maximum, boolean requireInteger, String errorMessage) {
        return ValidationFactory.getRangeValidator(minimum, maximum, requireInteger, errorMessage, SwingLanguagePack.getTextResource().notANumber());
    }

    public static ValidationStrategy getRangeValidator(final double minimum, final double maximum, final boolean requireInteger, final String errorMessage, final String notANumberMessage) {
        return new ValidationStrategy(){

            @Override
            public boolean isValid(String uncheckedString) {
                try {
                    if (requireInteger) {
                        BigInteger parsedLong = new BigInteger(uncheckedString);
                        BigInteger max = BigInteger.valueOf((int)maximum);
                        BigInteger min = BigInteger.valueOf((int)minimum);
                        return parsedLong.compareTo(min) >= 0 && parsedLong.compareTo(max) <= 0;
                    }
                    double parseDouble = PrimitiveUtils.parseDouble((String)uncheckedString);
                    return parseDouble >= minimum && parseDouble <= maximum;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            @Override
            public String getErrorMessage(String text) {
                block5: {
                    try {
                        text = text.replace(',', '.');
                        if (!text.isEmpty() && !StringUtils.equalsAny((String)text, (String[])new String[]{".", "-", "-."})) break block5;
                        return "";
                    }
                    catch (Exception exception) {
                        return notANumberMessage;
                    }
                }
                if (requireInteger) {
                    new BigInteger(text);
                } else {
                    PrimitiveUtils.parseDouble((String)text);
                }
                return errorMessage;
            }

            public String toString() {
                return "getRangeValidator(" + minimum + ", " + maximum + ", \"" + errorMessage + "\")";
            }
        };
    }

    public static ValidationStrategy getRangeValidator(double minimum, double maximum, UnitsConverter converter) {
        double convertedMinimum = converter.convertFrom(minimum);
        double convertedMaximum = converter.convertFrom(maximum);
        String unit = converter.getUnit();
        return ValidationFactory.getRangeValidator(convertedMinimum, convertedMaximum, SwingLanguagePack.getTextResource().valueOutOfRange(convertedMinimum, unit, convertedMaximum));
    }

    public static ValidationStrategy getLessThanValidator(final JTextField upperLimitContainer, final String propertyName, final String errorMessage) {
        return new ValidationStrategy(){

            @Override
            public boolean isValid(String uncheckedString) {
                try {
                    double maximum = PrimitiveUtils.parseDouble((String)((String)ReflectUtils.getProperty((Object)upperLimitContainer, (String)propertyName, (Object)"9223372036854775807")));
                    double parseDouble = PrimitiveUtils.parseDouble((String)uncheckedString);
                    return parseDouble <= maximum;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }

            @Override
            public String getErrorMessage(String text) {
                if ((text = text.replace(',', '.')).isEmpty() || StringUtils.equalsAny((String)text, (String[])new String[]{".", "-", "-."})) {
                    return "";
                }
                try {
                    PrimitiveUtils.parseDouble((String)text);
                }
                catch (NumberFormatException numberFormatException) {
                    return SwingLanguagePack.getTextResource().notANumber();
                }
                return errorMessage;
            }
        };
    }

    public static ValidationStrategy getMinDistanceValidator(final JTextField otherLimitContainer, final String propertyName, final double minRangeSize, final String errorMessage) {
        return new ValidationStrategy(){

            @Override
            public boolean isValid(String uncheckedString) {
                try {
                    double otherLimit = PrimitiveUtils.parseDouble((String)((String)ReflectUtils.getProperty((Object)otherLimitContainer, (String)propertyName, (Object)"9223372036854775807")));
                    double parseDouble = PrimitiveUtils.parseDouble((String)uncheckedString);
                    return Math.abs(otherLimit - parseDouble) + 1.0 >= minRangeSize;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }

            @Override
            public String getErrorMessage(String text) {
                if ((text = text.replace(',', '.')).isEmpty() || StringUtils.equalsAny((String)text, (String[])new String[]{".", "-", "-."})) {
                    return "";
                }
                try {
                    PrimitiveUtils.parseDouble((String)text);
                }
                catch (NumberFormatException numberFormatException) {
                    return SwingLanguagePack.getTextResource().notANumber();
                }
                return errorMessage;
            }
        };
    }

    public static ValidationStrategy getGreaterThanValidator(final JTextField lowerLimitContainer, final String propertyName, final String errorMessage) {
        return new ValidationStrategy(){

            @Override
            public boolean isValid(String uncheckedString) {
                try {
                    double minimum = PrimitiveUtils.parseDouble((String)((String)ReflectUtils.getProperty((Object)lowerLimitContainer, (String)propertyName, (Object)"9223372036854775807")));
                    double parseDouble = PrimitiveUtils.parseDouble((String)uncheckedString);
                    return parseDouble >= minimum;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }

            @Override
            public String getErrorMessage(String text) {
                if ((text = text.replace(',', '.')).isEmpty() || StringUtils.equalsAny((String)text, (String[])new String[]{".", "-", "-."})) {
                    return "";
                }
                try {
                    PrimitiveUtils.parseDouble((String)text);
                }
                catch (NumberFormatException numberFormatException) {
                    return SwingLanguagePack.getTextResource().notANumber();
                }
                return errorMessage;
            }
        };
    }

    public static ValidationStrategy getJointValueValidator(double min, double max) {
        return ValidationFactory.getJointValueValidator(min, max, 0.0, InputOperation.VALUE);
    }

    private static double roundDownDouble(double value, int numberOfDecimals) {
        if (Double.isInfinite(value)) {
            return value;
        }
        BigDecimal valueAsBigDecimal = BigDecimal.valueOf(value).setScale(numberOfDecimals, RoundingMode.DOWN);
        return valueAsBigDecimal.doubleValue();
    }

    private static double getDegrees(double angleInRadians) {
        if (Double.isInfinite(angleInRadians)) {
            return angleInRadians;
        }
        return 57.29577951308232 * angleInRadians;
    }

    public static ValidationStrategy getJointValueValidator(double min, double max, final double baseValue, final InputOperation operation) {
        return new ValidationStrategy(max, min){
            private static final int NEITHER = 0;
            private static final int POSITIVE_ONLY = 1;
            private static final int NEGATIVE_ONLY = 2;
            private static final int BOTH = 3;
            double jointMaxLimit;
            double jointMinLimit;
            {
                this.jointMaxLimit = ValidationFactory.roundDownDouble(ValidationFactory.getDegrees(d), 2);
                this.jointMinLimit = ValidationFactory.roundDownDouble(ValidationFactory.getDegrees(d2), 2);
            }

            @Override
            public boolean isValid(String uncheckedString) {
                try {
                    String checkedString = uncheckedString.replace(',', '.');
                    double inputValue = PrimitiveUtils.parseDouble((String)checkedString);
                    inputValue = operation.getNewValue(baseValue, inputValue);
                    return this.isValidJointValue(inputValue);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }

            private boolean isValidJointValue(double inputValue) {
                int casesToCheck = (this.jointMaxLimit == Double.POSITIVE_INFINITY ? 0 : 1) + (this.jointMinLimit == Double.NEGATIVE_INFINITY ? 0 : 2);
                switch (casesToCheck) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return inputValue <= this.jointMaxLimit;
                    }
                    case 2: {
                        return inputValue >= this.jointMinLimit;
                    }
                }
                return inputValue <= this.jointMaxLimit && inputValue >= this.jointMinLimit;
            }

            @Override
            public String getErrorMessage(String text) {
                Double inputValue;
                if (StringUtils.isNullOrOnlyWhitespace((String)(text = text.replace(',', '.'))) || StringUtils.equalsAny((String)text, (String[])new String[]{".", "-", "-."})) {
                    return "";
                }
                try {
                    inputValue = PrimitiveUtils.parseDouble((String)text);
                }
                catch (NumberFormatException numberFormatException) {
                    return SwingLanguagePack.getTextResource().notANumber();
                }
                if (!this.isValidJointValue(inputValue)) {
                    return SwingLanguagePack.getTextResource().valueOutOfRange(this.jointMinLimit, Units.getText().unitDegrees(), this.jointMaxLimit);
                }
                return "";
            }
        };
    }

    public static ValidationStrategy getWholeNumberValidator() {
        return new ValidationStrategy(){

            @Override
            public boolean isValid(String uncheckedString) {
                try {
                    new BigInteger(uncheckedString);
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            @Override
            public String getErrorMessage(String uncheckedString) {
                return SwingLanguagePack.getTextResource().notAWholeNumber();
            }
        };
    }

    public static ValidationStrategy getNonNegativeNumberValidator(final String message) {
        return new ValidationStrategy(){

            @Override
            public boolean isValid(String uncheckedString) {
                try {
                    double parseDouble = PrimitiveUtils.parseDouble((String)uncheckedString);
                    return parseDouble >= 0.0;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            @Override
            public String getErrorMessage(String uncheckedString) {
                return message;
            }
        };
    }

    public static ValidationStrategy getDecimalPlacesValidator(final int numberOfPlaces) {
        return new ValidationStrategy(){

            @Override
            public boolean isValid(String uncheckedString) {
                if (!uncheckedString.contains(".")) {
                    return true;
                }
                String trimmedString = uncheckedString.trim();
                int index = trimmedString.indexOf(".");
                return index + 1 + numberOfPlaces >= trimmedString.length();
            }

            @Override
            public String getErrorMessage(String uncheckedString) {
                if (numberOfPlaces == 1) {
                    return SwingLanguagePack.getTextResource().decimalPrecisionGreaterThanOne();
                }
                return SwingLanguagePack.getTextResource().decimalPrecisionIsTooHigh(numberOfPlaces);
            }

            public String toString() {
                return "decimalPlacesValidator(" + numberOfPlaces + ")";
            }
        };
    }

    public static ValidationStrategy getValueAboveValidationStrategy(NumberField otherField, final String message) {
        return new ValidationStrategy(otherField){
            private NumberField valueField;
            {
                this.valueField = numberField;
            }

            @Override
            public boolean isValid(String uncheckedString) {
                Double value;
                if (!this.valueField.isEnabled() || StringUtils.isNullOrEmpty((String)this.valueField.getText())) {
                    return true;
                }
                try {
                    value = new Double(uncheckedString);
                }
                catch (Exception exception) {
                    return true;
                }
                return value >= new Double(this.valueField.getText().replace(",", "."));
            }

            @Override
            public String getErrorMessage(String uncheckedString) {
                return message;
            }
        };
    }

    public static ValidationStrategy getValueBelowValidationStrategy(NumberField otherField, final String message) {
        return new ValidationStrategy(otherField){
            private NumberField valueField;
            {
                this.valueField = numberField;
            }

            @Override
            public boolean isValid(String uncheckedString) {
                Double value;
                try {
                    value = new Double(uncheckedString);
                }
                catch (Exception exception) {
                    return true;
                }
                return value <= new Double(this.valueField.getText().replace(",", "."));
            }

            @Override
            public String getErrorMessage(String uncheckedString) {
                return message;
            }
        };
    }

    private static final class TextWidthValidationStrategy
    implements ValidationStrategy {
        private final int maximumTextWidth;

        private TextWidthValidationStrategy(int maximumTextWidth) {
            this.maximumTextWidth = maximumTextWidth;
        }

        @Override
        public boolean isValid(String uncheckedString) {
            if (StringUtils.isNullOrOnlyWhitespace((String)uncheckedString)) {
                return false;
            }
            return uncheckedString.length() <= this.maximumTextWidth;
        }

        @Override
        public String getErrorMessage(String uncheckedString) {
            if (StringUtils.isNullOrOnlyWhitespace((String)uncheckedString)) {
                return "";
            }
            return SwingLanguagePack.getTextResource().maximumTextLength(this.maximumTextWidth);
        }
    }
}

