/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface ValidationStrategy {
    public static final ValidationStrategy ALWAYS_VALID = new AlwaysValid();
    public static final ValidationStrategy ALWAYS_INVALID = new AlwaysInvalid();

    public boolean isValid(String var1);

    public String getErrorMessage(String var1);

    public static class AlwaysInvalid
    implements ValidationStrategy {
        @Override
        public boolean isValid(String uncheckedString) {
            return false;
        }

        @Override
        public String getErrorMessage(String uncheckedString) {
            return "This is always in error";
        }
    }

    public static class AlwaysValid
    implements ValidationStrategy {
        @Override
        public boolean isValid(String uncheckedString) {
            return true;
        }

        @Override
        public String getErrorMessage(String uncheckedString) {
            return "Should not be called";
        }
    }

    public static class Composite
    implements ValidationStrategy {
        private final List<ValidationStrategy> strategies = new ArrayList<ValidationStrategy>();
        private ValidationStrategy hasError;

        public Composite(ValidationStrategy ... strategies) {
            this.strategies.addAll(Arrays.asList(strategies));
        }

        @Override
        public boolean isValid(String uncheckedString) {
            this.hasError = null;
            for (ValidationStrategy each : this.strategies) {
                if (each.isValid(uncheckedString)) continue;
                this.hasError = each;
                return false;
            }
            return true;
        }

        public void add(ValidationStrategy strategy) {
            if (strategy != null) {
                this.strategies.add(0, strategy);
            }
        }

        @Override
        public String getErrorMessage(String uncheckedString) {
            return this.hasError.getErrorMessage(uncheckedString);
        }
    }

    public static class ValidationWrapperStrategy
    implements ValidationStrategy {
        private ValidationStrategy strategy = ALWAYS_VALID;

        public void setStrategy(ValidationStrategy strategy) {
            this.strategy = strategy;
        }

        @Override
        public boolean isValid(String uncheckedString) {
            return this.strategy.isValid(uncheckedString);
        }

        @Override
        public String getErrorMessage(String uncheckedString) {
            return this.strategy.getErrorMessage(uncheckedString);
        }
    }
}

