/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.wizard;

import com.ur.swing.CardPanel;
import com.ur.swing.internal.i18n.Translations;
import com.ur.swing.internal.i18n.impl.TranslationsImpl;
import com.ur.swing.wizard.AbstractWizardPage;
import com.ur.swing.wizard.ButtonEvent;
import com.ur.swing.wizard.ButtonListener;
import com.ur.util.swing.HTML;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;

public abstract class AbstractWizardCardPanel
extends CardPanel
implements ButtonListener {
    static Translations textResource = new TranslationsImpl(Locale.ENGLISH);
    protected JButton prevButton;
    protected JButton nextButton;
    protected JButton finishButton;
    protected JButton cancelButton;
    protected JComponent stepsPanel;
    protected JComponent contentPanel;
    protected JComponent buttonPanel;
    protected JLabel headerLabel;
    private Map<AbstractWizardPage, JLabel> stepButtonMap = new HashMap<AbstractWizardPage, JLabel>();
    protected List<AbstractWizardPage> pageList = new ArrayList<AbstractWizardPage>();
    protected Map<String, JButton> buttonNameMap = new HashMap<String, JButton>();
    protected AbstractWizardPage currentPage = null;
    protected String title;

    public AbstractWizardCardPanel(String title) {
        this.title = title;
        this.initComponents();
    }

    @Inject
    public static void setTextResource(Translations textResource) {
        AbstractWizardCardPanel.textResource = textResource;
    }

    public abstract void initComponents();

    public abstract Border createStepBorder(boolean var1);

    public String getTitle() {
        return this.title;
    }

    private void addPage(AbstractWizardPage page) {
        this.pageList.add(page);
        page.addButtonListener(this);
        JLabel stepName = new JLabel(HTML.html((String)page.getTitle()), page.getIcon(), 2);
        stepName.setBorder(this.createStepBorder(false));
        this.stepsPanel.add(stepName);
        this.stepButtonMap.put(page, stepName);
        this.contentPanel.add((Component)page, page.getTitle());
    }

    public void setPageList(List<AbstractWizardPage> pageList) {
        if (pageList.isEmpty()) {
            throw new RuntimeException("Need pages!");
        }
        for (AbstractWizardPage page : pageList) {
            this.addPage(page);
        }
        this.setCurrentPage(pageList.get(0));
    }

    public List<AbstractWizardPage> getPageList() {
        return this.pageList;
    }

    private String getFullTitle(String pageTitle) {
        int currentPageIndex = this.pageList.indexOf(this.currentPage) + 1;
        int numberOfPages = this.pageList.size();
        return String.format(" %s (%d/%d) - %s", textResource.steps(), currentPageIndex, numberOfPages, pageTitle);
    }

    protected void setCurrentPage(AbstractWizardPage page) {
        if (this.currentPage != null) {
            this.currentPage.exit();
            this.stepButtonMap.get(this.currentPage).setBorder(this.createStepBorder(false));
        }
        this.currentPage = page;
        this.headerLabel.setText(HTML.html((String)HTML.h2((String)this.getFullTitle(page.getTitle()))));
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, page.getTitle());
        this.stepButtonMap.get(page).setBorder(this.createStepBorder(true));
        page.enter(null);
        page.setupWizardButtons();
        this.disablePrevNextForFirstAndLast();
    }

    public AbstractWizardPage getCurrentPage() {
        return this.currentPage;
    }

    private void disablePrevNextForFirstAndLast() {
        if (this.currentPage == this.pageList.get(0)) {
            this.prevButton.setEnabled(false);
        }
        if (this.currentPage == this.pageList.get(this.pageList.size() - 1)) {
            this.nextButton.setEnabled(false);
        }
    }

    protected void refreshStepButton(AbstractWizardPage page) {
        JLabel stepButton = this.stepButtonMap.get(page);
        stepButton.setText(HTML.html((String)page.getTitle()));
        stepButton.setIcon(page.getIcon());
    }

    @Override
    public void buttonEventFired(ButtonEvent e) {
        switch (e.getType()) {
            case ENABLE_BUTTON: {
                this.buttonNameMap.get(e.getButtonName()).setEnabled(true);
                break;
            }
            case DISABLE_BUTTON: {
                this.buttonNameMap.get(e.getButtonName()).setEnabled(false);
                break;
            }
            case CHANGE_BUTTON_TEXT: {
                if (e.getButtonName() != "STEP") break;
                this.refreshStepButton((AbstractWizardPage)e.getSource());
            }
        }
    }

    public AbstractButton getPrevButton() {
        return this.prevButton;
    }

    public AbstractButton getNextButton() {
        return this.nextButton;
    }

    public AbstractButton getFinishButton() {
        return this.finishButton;
    }

    public AbstractButton getCancelButton() {
        return this.cancelButton;
    }

    protected void completedActionPerformed() {
        this.setCurrentPage(this.getPageList().get(0));
        for (AbstractWizardPage page : this.getPageList()) {
            page.reset();
        }
        for (AbstractWizardPage page : this.getPageList()) {
            this.refreshStepButton(page);
        }
        this.navigateBack();
    }

    protected void finishActionPerformed(ActionEvent e) {
        this.completedActionPerformed();
    }

    protected void cancelActionPerformed(ActionEvent e) {
        this.completedActionPerformed();
    }

    protected void addDummyIconsToPages(List<AbstractWizardPage> pages) {
        Icon dummyIcon = null;
        for (AbstractWizardPage page : pages) {
            Icon pageIcon = page.getIcon();
            if (pageIcon == null) continue;
            dummyIcon = this.createDummyIcon(pageIcon.getIconWidth(), pageIcon.getIconHeight());
            break;
        }
        if (dummyIcon == null) {
            return;
        }
        for (AbstractWizardPage page : pages) {
            if (page.getIcon() != null) continue;
            page.setIcon(dummyIcon);
        }
    }

    protected Icon createDummyIcon(final int width, final int height) {
        return new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int i, int i1) {
            }

            @Override
            public int getIconWidth() {
                return width;
            }

            @Override
            public int getIconHeight() {
                return height;
            }
        };
    }
}

