/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.driver.g5.driver;

import com.ur.lang.Defense;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.NotEnabled;
import com.ur.polyscope.driver.api.aspects.ScreenShotTakerAspect;
import com.ur.polyscope.driver.g5.driver.PolyScopeDriver;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.j3dcomponents.J3DButton;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.polyscope.visualizer.j3dcomponents.J3DPanel;
import com.ur.swing.ComponentDriver;
import com.ur.swing.JemmyUtils;
import com.ur.swing.SwingUtil;
import com.ur.swing.number.driver.NumberKeyPadOperator;
import com.ur.swing.text.driver.TextPickerOperator;
import com.ur.util.Waiting;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.swing.JButton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.AbstractButtonOperator;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;

public abstract class BaseDriver
extends com.ur.polyscope.driver.api.BaseDriver {
    private static final int WAIT_TIME_ON_OPEN;
    protected PolyScopeDriver polyScopeUI;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    static {
        BaseDriver.ajc$preClinit();
        WAIT_TIME_ON_OPEN = Integer.parseInt(System.getProperty("wait.time.on.open", "3"));
    }

    @Inject
    protected BaseDriver(PolyScopeDriver polyScopeUI, String driverShowingComponentName) {
        super((MainScreen)polyScopeUI, driverShowingComponentName);
        this.polyScopeUI = polyScopeUI;
        JemmyUtils.waitForIdle((int)WAIT_TIME_ON_OPEN, (TimeUnit)TimeUnit.SECONDS);
        SwingUtil.invokeAndWait(() -> {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null);
            try {
                ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            }
            finally {
                ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
            }
        });
    }

    protected static void assertTrue(boolean value) {
        boolean bl = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)Conversions.booleanObject((boolean)bl));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            BaseDriver.assertTrue("Assertion failed: false != true", value);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    protected static void assertTrue(String message, boolean value) {
        String string = message;
        boolean bl = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            if (!value) {
                throw new RuntimeException(message);
            }
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    protected static void assertFalse(String message, boolean value) {
        String string = message;
        boolean bl = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            BaseDriver.assertTrue(message, !value);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    protected static void assertEquals(Object o1, Object o2) {
        Object object = o1;
        Object object2 = o2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)object, (Object)object2);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            BaseDriver.assertEquals("Assertion failed", o1, o2);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    protected static void assertEquals(String message, Object o1, Object o2) {
        String string = message;
        Object object = o1;
        Object object2 = o2;
        Object[] objectArray = new Object[]{string, object, object2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object[])objectArray);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            if (BaseDriver.isBothNotNullAndNotEquals(o1, o2) || BaseDriver.isOnlyOneNull(o1, o2)) {
                throw new RuntimeException(String.valueOf(message) + ": " + o1 + " is not equal to " + o2);
            }
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    private static boolean isBothNotNullAndNotEquals(Object o1, Object o2) {
        return o1 != null && o2 != null && !o1.equals(o2);
    }

    private static boolean isOnlyOneNull(Object o1, Object o2) {
        return o1 == null && o2 != null || o1 != null && o2 == null;
    }

    protected static void assertNotEquals(Object o1, Object o2) {
        Object object = o1;
        Object object2 = o2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)object, (Object)object2);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            BaseDriver.assertNotEquals("Assertion failed", o1, o2);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    private static void assertNotEquals(String message, Object o1, Object o2) {
        String string = message;
        Object object = o1;
        Object object2 = o2;
        Object[] objectArray = new Object[]{string, object, object2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object[])objectArray);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            if (o1 != null && o1.equals(o2) || o1 == null && o2 == null) {
                throw new RuntimeException(String.valueOf(message) + ": " + o1 + " is equal to " + o2);
            }
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    protected NumberKeyPadOperator numberFieldNamed(String withName) {
        NumberKeyPadOperator numberKeyPadOperator;
        String string = withName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(withName));
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
        return numberKeyPadOperator;
    }

    protected void typeAndClickOk(String text, JTextComponentOperator forTextComponent) {
        String string = text;
        JTextComponentOperator jTextComponentOperator = forTextComponent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)jTextComponentOperator);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            if (!Waiting.until((Waiting.ItHappens)this.isEnabled((JComponentOperator)forTextComponent), (int)5, (TimeUnit)TimeUnit.SECONDS)) {
                throw new NotEnabled("TextComponent named '" + forTextComponent.getName() + "' was not enabled when trying to type '" + text + "'");
            }
            new TextPickerOperator(forTextComponent).type(text);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    protected TextPickerOperator clickForTextPicker(JTextComponentOperator componentOperator) {
        TextPickerOperator textPickerOperator;
        JTextComponentOperator jTextComponentOperator = componentOperator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this), (Object)jTextComponentOperator);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            if (!Waiting.until((Waiting.ItHappens)this.isEnabled((JComponentOperator)componentOperator), (int)1, (TimeUnit)TimeUnit.SECONDS)) {
                throw new NotEnabled("TextComponent named '" + componentOperator.getName() + "' was not enabled when trying to open text picker");
            }
            textPickerOperator = new TextPickerOperator(componentOperator);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
        return textPickerOperator;
    }

    protected AbstractButtonOperator button3dNamed(String canvasName, String withName) {
        AbstractButtonOperator abstractButtonOperator;
        String string = canvasName;
        String string2 = withName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            final J3DButtonOperator canvas = new J3DButtonOperator(this.polyScopeUI, canvasName, withName);
            abstractButtonOperator = new AbstractButtonOperator(new JButton()){

                public void push() {
                    canvas.push();
                }
            };
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
        return abstractButtonOperator;
    }

    protected void setNumberValue(String fieldName, String value) {
        String string = fieldName;
        String string2 = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            try {
                this.trySetNumberValue(fieldName, value);
            }
            catch (Exception exception) {
                Waiting.pause((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
                this.trySetNumberValue(fieldName, value);
            }
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    private void trySetNumberValue(String fieldName, String value) {
        String string = fieldName;
        String string2 = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            JemmyUtils.waitForIdle((int)1, (TimeUnit)TimeUnit.SECONDS);
            NumberKeyPadOperator numberPicker = this.numberFieldNamed(fieldName);
            numberPicker.clickClear();
            numberPicker.punchInKeypad(value);
            JemmyUtils.waitForIdle((int)1, (TimeUnit)TimeUnit.SECONDS);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BaseDriver.java", BaseDriver.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "assertTrue", "com.ur.polyscope.driver.g5.driver.BaseDriver", "boolean", "value", "", "void"), 45);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "assertTrue", "com.ur.polyscope.driver.g5.driver.BaseDriver", "java.lang.String:boolean", "message:value", "", "void"), 49);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "button3dNamed", "com.ur.polyscope.driver.g5.driver.BaseDriver", "java.lang.String:java.lang.String", "canvasName:withName", "", "org.netbeans.jemmy.operators.AbstractButtonOperator"), 105);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "setNumberValue", "com.ur.polyscope.driver.g5.driver.BaseDriver", "java.lang.String:java.lang.String", "fieldName:value", "", "void"), 115);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "trySetNumberValue", "com.ur.polyscope.driver.g5.driver.BaseDriver", "java.lang.String:java.lang.String", "fieldName:value", "", "void"), 124);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("100a", "lambda$0", "com.ur.polyscope.driver.g5.driver.BaseDriver", "", "", "", "void"), 42);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "assertFalse", "com.ur.polyscope.driver.g5.driver.BaseDriver", "java.lang.String:boolean", "message:value", "", "void"), 55);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "assertEquals", "com.ur.polyscope.driver.g5.driver.BaseDriver", "java.lang.Object:java.lang.Object", "o1:o2", "", "void"), 59);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "assertEquals", "com.ur.polyscope.driver.g5.driver.BaseDriver", "java.lang.String:java.lang.Object:java.lang.Object", "message:o1:o2", "", "void"), 63);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "assertNotEquals", "com.ur.polyscope.driver.g5.driver.BaseDriver", "java.lang.Object:java.lang.Object", "o1:o2", "", "void"), 77);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "assertNotEquals", "com.ur.polyscope.driver.g5.driver.BaseDriver", "java.lang.String:java.lang.Object:java.lang.Object", "message:o1:o2", "", "void"), 81);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "numberFieldNamed", "com.ur.polyscope.driver.g5.driver.BaseDriver", "java.lang.String", "withName", "", "com.ur.swing.number.driver.NumberKeyPadOperator"), 87);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "typeAndClickOk", "com.ur.polyscope.driver.g5.driver.BaseDriver", "java.lang.String:org.netbeans.jemmy.operators.JTextComponentOperator", "text:forTextComponent", "", "void"), 91);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "clickForTextPicker", "com.ur.polyscope.driver.g5.driver.BaseDriver", "org.netbeans.jemmy.operators.JTextComponentOperator", "componentOperator", "", "com.ur.swing.text.driver.TextPickerOperator"), 98);
    }

    public static class J3DButtonOperator
    extends ComponentOperator {
        private final J3DButton button;

        public J3DButtonOperator(PolyScopeDriver polyScopeUI, String canvasName, String withName) {
            super((ContainerOperator)polyScopeUI, ComponentDriver.aComponent((String)canvasName, (ComponentChooser[])new ComponentChooser[]{ComponentDriver.showing()}));
            this.button = this.findJ3DButton(this.getRobotCanvas3D().getJ3DComponents(), withName);
            Defense.notNull((Object)this.button, (String)("Could not find J3DButton with name '" + withName + "'"));
        }

        private J3DButton findJ3DButton(Iterable<J3DComponent> components, String withName) {
            for (J3DComponent each : components) {
                J3DButton found;
                if (each instanceof J3DButton && each.getName().equals(withName)) {
                    return (J3DButton)each;
                }
                if (!(each instanceof J3DPanel) || (found = this.findJ3DButton(((J3DPanel)each).getChildren(), withName)) == null) continue;
                return found;
            }
            return null;
        }

        public boolean isShowing() {
            return this.button != null;
        }

        public void push() {
            Rectangle bounds = this.button.getBounds();
            MouseEvent newPressedEvent = new MouseEvent(this.getSource(), 501, System.currentTimeMillis(), 16, bounds.x + 4, bounds.y + 4, bounds.x + 4, bounds.y + 4, 1, false, 1);
            MouseEvent newReleaseEvent = new MouseEvent(this.getSource(), 502, System.currentTimeMillis(), 16, bounds.x + 4, bounds.y + 4, bounds.x + 4, bounds.y + 4, 1, false, 1);
            MouseEvent newClickEvent = new MouseEvent(this.getSource(), 500, System.currentTimeMillis(), 16, bounds.x + 4, bounds.y + 4, bounds.x + 4, bounds.y + 4, 1, false, 1);
            this.button.dispatchEvent((AWTEvent)newPressedEvent);
            this.button.dispatchEvent((AWTEvent)newReleaseEvent);
            this.button.dispatchEvent((AWTEvent)newClickEvent);
        }

        public RobotCanvas3D getRobotCanvas3D() {
            return (RobotCanvas3D)this.getSource();
        }
    }
}

