/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.driver.g5.driver;

import com.ur.view.constants.dev.SafetyMode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;

public class DashBoardServerDriver {
    private final SocketConnectionResource dashboardServer = new SocketConnectionResource(29999);

    public void assertNormalSafetyMode() {
        this.checkSafetyMode(SafetyMode.NORMAL);
    }

    public void assertReducedSafetyMode() {
        this.checkSafetyMode(SafetyMode.REDUCED);
    }

    public void assertProtectiveStopSafetyMode() {
        this.checkSafetyMode(SafetyMode.PROTECTIVE_STOP);
    }

    public void loadInstallation(String installation) {
        try {
            this.dashboardServer.sendMessage("load installation " + installation);
            this.dashboardServer.getMessage();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void checkSafetyMode(SafetyMode mode) {
        String safetyModeAsString = this.getSafetyModeFromMessage();
        SafetyMode safetyMode = SafetyMode.valueOf((String)safetyModeAsString);
        if (mode != safetyMode) {
            throw new RuntimeException("expected " + mode + " mode, but was " + safetyMode);
        }
    }

    private String getSafetyModeFromMessage() {
        try {
            this.dashboardServer.sendMessage("safetymode");
            return this.dashboardServer.getMessage().split(" ")[1];
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void sendMessage(String message) throws IOException {
        this.dashboardServer.sendMessage(message);
    }

    public void consumeMessage() {
        try {
            this.dashboardServer.consumeMessage();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closeConnection() {
        this.dashboardServer.closeConnection();
    }

    private static class SocketConnectionResource {
        private final int port;
        private PrintWriter writer;
        private BufferedReader reader;
        private Socket socket;
        private String receivedMessage;

        SocketConnectionResource(int port) {
            this.port = port;
        }

        void consumeMessage() throws IOException {
            if (this.socket == null) {
                this.startConnection();
            }
            this.reader.readLine();
        }

        void sendMessage(String message) throws IOException {
            if (this.socket == null) {
                this.startConnection();
                this.reader.readLine();
            }
            this.print("sending '" + message + "'");
            this.writer.println(message);
            this.receivedMessage = this.print(this.reader.readLine());
        }

        String getMessage() {
            return this.receivedMessage;
        }

        private void startConnection() throws IOException {
            this.socket = new Socket(InetAddress.getByName(null), this.port);
            this.writer = new PrintWriter(this.socket.getOutputStream(), true);
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }

        public void closeConnection() {
            try {
                if (this.socket != null) {
                    this.writer.close();
                    this.reader.close();
                    this.socket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private String print(String message) {
            System.out.println(" DashBoardServer: " + message);
            return message;
        }
    }
}

