/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.driver.g5.driver;

import com.ur.polyscope.driver.api.aspects.ScreenShotTakerAspect;
import com.ur.polyscope.driver.g5.driver.BaseDriver;
import com.ur.polyscope.driver.g5.driver.PolyScopeDriver;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JLabelOperator;

public class IOScreenDriver
extends BaseDriver {
    private String analogOutputComboBoxName = "analog_output_combo_";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    public IOScreenDriver(PolyScopeDriver polyScopeUI) {
        super(polyScopeUI, "robotTab.ioTab");
        this.showScreen();
        IOScreenDriver.assertTrue("The IOScreen was not shown", this.isShowing());
    }

    public void assertConfigurableInputLabelText(int i, String text) {
        int n = i;
        String string = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n), (Object)string);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            this.assertLabelNamed("conf_input_" + i, this.hasText(text));
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void assertConfigurableOutputLabelText(int i, String text) {
        int n = i;
        String string = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n), (Object)string);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            this.assertLabelNamed("conf_output_" + i, this.hasText(text));
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void selectIOModbusScreen() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            this.push(this.buttonNamed("showModbus.ModbusIOTab"));
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void selectImmiIOScreen() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            this.push(this.buttonNamed("showModbus.ModbusIOTab"));
            this.push(this.buttonNamed("showImmi.immiIOTab"));
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    private void showScreen() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            this.push(this.buttonNamed("ioScreen.HeaderMenu"));
            Waiting.until(() -> ((IOScreenDriver)this).isShowing(), (int)3, (TimeUnit)TimeUnit.SECONDS);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    private boolean isAnalogOutputComboBoxEnabled(int pinNumber) {
        String name = String.valueOf(this.analogOutputComboBoxName) + pinNumber;
        JComboBoxOperator componentOperator = this.inComboBox(name);
        return componentOperator.isEnabled();
    }

    private boolean isAnalogOutputSliderEnabled(int pinNumber) {
        String name = String.valueOf(this.analogOutputComboBoxName) + pinNumber;
        JComponentOperator componentOperator = this.componentNamed(name);
        return componentOperator.isEnabled();
    }

    public void selectDisplayMetricForAnalogOutput(int pinNumber, int choice) {
        int n = pinNumber;
        int n2 = choice;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n), (Object)Conversions.intObject((int)n2));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            JComboBoxOperator comboBoxOperator = this.inComboBox(String.valueOf(this.analogOutputComboBoxName) + pinNumber);
            comboBoxOperator.setSelectedIndex(choice);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public String getAnalogOutputDisplayedValue(int pinNumber) {
        String string;
        int n = pinNumber;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            String analogOutputValueLabel = "analog_output_value_";
            JLabelOperator analogOutputLabel = (JLabelOperator)this.componentNamed(String.valueOf(analogOutputValueLabel) + pinNumber);
            string = analogOutputLabel.getText();
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
        return string;
    }

    public void assertAnalogOutputDisabled(int pinNumber) {
        int n = pinNumber;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            IOScreenDriver.assertFalse("analog_out[" + pinNumber + "] should be disabled but it is enabled.", this.isAnalogOutputComboBoxEnabled(pinNumber));
            IOScreenDriver.assertFalse("analog_out[" + pinNumber + "] should be disabled but it is enabled.", this.isAnalogOutputSliderEnabled(pinNumber));
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void assertAnalogOutputEnabled(int pinNumber) {
        int n = pinNumber;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            IOScreenDriver.assertTrue("analog_out[" + pinNumber + "] should be enabled but it is disabled.", this.isAnalogOutputComboBoxEnabled(pinNumber));
            IOScreenDriver.assertTrue("analog_out[" + pinNumber + "] should be enabled but it is disabled.", this.isAnalogOutputSliderEnabled(pinNumber));
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    static {
        IOScreenDriver.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("IOScreenDriver.java", IOScreenDriver.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "assertConfigurableInputLabelText", "com.ur.polyscope.driver.g5.driver.IOScreenDriver", "int:java.lang.String", "i:text", "", "void"), 25);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "assertConfigurableOutputLabelText", "com.ur.polyscope.driver.g5.driver.IOScreenDriver", "int:java.lang.String", "i:text", "", "void"), 29);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectIOModbusScreen", "com.ur.polyscope.driver.g5.driver.IOScreenDriver", "", "", "", "void"), 33);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectImmiIOScreen", "com.ur.polyscope.driver.g5.driver.IOScreenDriver", "", "", "", "void"), 37);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "showScreen", "com.ur.polyscope.driver.g5.driver.IOScreenDriver", "", "", "", "void"), 42);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectDisplayMetricForAnalogOutput", "com.ur.polyscope.driver.g5.driver.IOScreenDriver", "int:int", "pinNumber:choice", "", "void"), 59);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAnalogOutputDisplayedValue", "com.ur.polyscope.driver.g5.driver.IOScreenDriver", "int", "pinNumber", "", "java.lang.String"), 64);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "assertAnalogOutputDisabled", "com.ur.polyscope.driver.g5.driver.IOScreenDriver", "int", "pinNumber", "", "void"), 70);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "assertAnalogOutputEnabled", "com.ur.polyscope.driver.g5.driver.IOScreenDriver", "int", "pinNumber", "", "void"), 75);
    }
}

