/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.driver.g5.driver;

import com.ur.injection.Builder;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.application.driver.filemanager.OpenFileDialogDriver;
import com.ur.polyscope.application.driver.logging.LogTabDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.dialog.Dialog;
import com.ur.polyscope.driver.api.dialog.DialogDriver;
import com.ur.polyscope.driver.api.dialog.DialogDriverFactory;
import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.polyscope.driver.api.init.InitializeScreenDriver;
import com.ur.polyscope.driver.g5.driver.BaseDriver;
import com.ur.polyscope.driver.g5.driver.ComponentSizeDriver;
import com.ur.polyscope.driver.g5.driver.ConfirmationDialogDriver;
import com.ur.polyscope.driver.g5.driver.EditPoseScreenDriver;
import com.ur.polyscope.driver.g5.driver.ExpertScreenDriver;
import com.ur.polyscope.driver.g5.driver.IOScreenDriver;
import com.ur.polyscope.driver.g5.driver.MoveScreenDriver;
import com.ur.polyscope.driver.g5.driver.OldInstallationScreenDriver;
import com.ur.polyscope.driver.g5.driver.ProgramScreenDriver;
import com.ur.polyscope.driver.g5.driver.RunScreenDriver;
import com.ur.polyscope.driver.g5.driver.SpeedPanelDriver;
import com.ur.polyscope.driver.g5.driver.header.OldHeaderMenuDriver;
import com.ur.polyscope.driver.g5.driver.settings.OldSettingsScreenDriver;
import com.ur.polyscope.driver.g5.driver.settings.SetOperationalModePasswordDriver;
import com.ur.polyscope.driver.g5.driver.settings.SetSafetyPasswordDriver;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.swing.ComponentDriver;
import com.ur.util.Waiting;
import gui.polyscope.DashBoard;
import gui.program.position.WaypointNode;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.AbstractButtonOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JDialogOperator;

@Singleton
public class PolyScopeDriver
extends MainScreen {
    public static final String LOG_SCREEN = "logScreen.HeaderMenu";
    private final NamingService namingService;
    private final Builder builder;

    @Inject
    PolyScopeDriver(NamingService namingService, Builder builder) {
        super(builder);
        this.namingService = namingService;
        this.builder = builder;
    }

    public ConfirmationDialogDriver inDialog(Dialog dialog) {
        return new ConfirmationDialogDriver(this, DialogDriverFactory.createDriver((Dialog)dialog));
    }

    @Deprecated
    public ConfirmationDialogDriver inDialog(String titleText) {
        return new ConfirmationDialogDriver(this, this.getDialogRegistry().inDialog(titleText));
    }

    @Deprecated
    public boolean isDialogShown(String dialog) {
        return this.getDialogRegistry().isDialogShown(dialog);
    }

    public boolean isDialogShown(Dialog dialog) {
        return DialogDriverFactory.isDialogShown((Dialog)dialog);
    }

    public void confirmSafetyChanges() {
        if (this.isDialogShown((Dialog)DialogWithName.APPLY_SAFETY_CONFIGURATION)) {
            this.buttonInDialogWithName("confirm.confirmMessageDialog", (Dialog)DialogWithName.APPLY_SAFETY_CONFIGURATION).doClick();
            this.clickOKOnPopupDialog((Dialog)DialogWithName.SAFETY_CHECKSUM_MAY_CHANGE);
        }
    }

    public void revertSafetyChanges() {
        if (this.isDialogShown((Dialog)DialogWithName.APPLY_SAFETY_CONFIGURATION)) {
            this.buttonInDialogWithName("cancel.confirmMessageDialog", (Dialog)DialogWithName.APPLY_SAFETY_CONFIGURATION).doClick();
        }
    }

    public void waitForConfirmSafetyConfigurationAndPushDecline() {
        Waiting.until(() -> this.isDialogShown((Dialog)DialogWithName.CONFIRM_SAFETY_CONFIGURATION), (int)5, (TimeUnit)TimeUnit.SECONDS);
        if (this.isDialogShown((Dialog)DialogWithName.CONFIRM_SAFETY_CONFIGURATION)) {
            this.inDialog((Dialog)DialogWithName.CONFIRM_SAFETY_CONFIGURATION).pushDeclineSafety();
        }
    }

    public void waitForConfirmSafetyConfigurationAndPushConfirm() {
        Waiting.until(() -> this.isDialogShown((Dialog)DialogWithName.CONFIRM_SAFETY_CONFIGURATION), (int)5, (TimeUnit)TimeUnit.SECONDS);
        if (this.isDialogShown((Dialog)DialogWithName.CONFIRM_SAFETY_CONFIGURATION)) {
            this.inDialog((Dialog)DialogWithName.CONFIRM_SAFETY_CONFIGURATION).pushConfirmSafetyConfiguration();
        }
    }

    public void clickOKOnPopupDialog(Dialog dialog) {
        Waiting.until(() -> {
            if (this.isDialogShown(dialog)) {
                DialogDriver dialogDriver = DialogDriverFactory.createDriver((Dialog)dialog);
                dialogDriver.pushButton("rightArrowKey.MessageDialogPanel");
                return true;
            }
            return false;
        }, (int)3, (TimeUnit)TimeUnit.SECONDS);
    }

    public void closeRuntimeExceptionDialog() {
        this.buttonInDialogWithName("leftArrowKey.MessageDialogPanel", (Dialog)com.ur.view.DialogWithName.RUNTIME_EXCEPTION).doClick();
    }

    public RunScreenDriver selectRunScreen() {
        return (RunScreenDriver)((Object)this.builder.get(RunScreenDriver.class));
    }

    public InitializeScreenDriver selectInitializeRobotScreen() {
        return (InitializeScreenDriver)this.builder.get(InitializeScreenDriver.class);
    }

    public MoveScreenDriver gotoMoveScreen(boolean assertMoveScreenShowing) {
        MoveScreenDriver moveScreenDriver = new MoveScreenDriver(this, true);
        if (assertMoveScreenShowing) {
            BaseDriver.assertTrue("The MoveScreen was not shown", moveScreenDriver.isShowing());
        }
        return moveScreenDriver;
    }

    public MoveScreenDriver getMoveScreenDriver() {
        return new MoveScreenDriver(this, false);
    }

    public EditPoseScreenDriver getEditPoseScreenDriver() {
        return new EditPoseScreenDriver(this);
    }

    public IOScreenDriver selectIOScreen() {
        return new IOScreenDriver(this);
    }

    public OldSettingsScreenDriver selectSettingsScreen() {
        return new OldSettingsScreenDriver(this, this.getScreenComponentRegistry());
    }

    public LogTabDriver selectLogScreen() {
        return (LogTabDriver)this.getScreenComponentRegistry().selectComponent(LogTabDriver.class);
    }

    public ProgramScreenDriver selectProgramScreen() {
        return (ProgramScreenDriver)((Object)this.builder.get(ProgramScreenDriver.class));
    }

    public OldInstallationScreenDriver selectInstallationScreen() {
        return OldInstallationScreenDriver.createAndNavigate(this, this.getScreenComponentRegistry());
    }

    public OldHeaderMenuDriver getHeaderMenuDriver() {
        return new OldHeaderMenuDriver(this, this.getScreenComponentRegistry());
    }

    public OpenFileDialogDriver getOpenFileDialogDriver() {
        return (OpenFileDialogDriver)this.builder.get(OpenFileDialogDriver.class);
    }

    public ComponentSizeDriver getComponentSizeDriver() {
        return new ComponentSizeDriver(this);
    }

    public ExpertScreenDriver selectExpertScreen(boolean logInAsUroot) {
        if (logInAsUroot) {
            return new ExpertScreenDriver(this, "uroot");
        }
        return new ExpertScreenDriver(this);
    }

    public JButtonOperator buttonInDialogWithName(String buttonName, String dialogName) {
        JDialogOperator dialogDriver = new JDialogOperator(ComponentDriver.withName((String)dialogName));
        return new JButtonOperator((ContainerOperator)dialogDriver, ComponentDriver.aComponent((String)buttonName, (ComponentChooser[])new ComponentChooser[0]));
    }

    public JButtonOperator buttonInDialogWithName(String buttonName, Dialog dialog) {
        return this.buttonInDialogWithName(buttonName, dialog.getName());
    }

    public boolean canNavigateToRunScreenScreen() {
        return this.canNavigateTo(this.button("runScreen.HeaderMenu"));
    }

    public boolean canNavigateToInitializeRobotScreen() {
        return this.canNavigateTo(this.button("initRobotScreen.HeaderMenu"));
    }

    public boolean canNavigateToSettingsScreen() {
        return this.canNavigateTo(this.button("settingsScreen.HeaderMenu"));
    }

    public boolean canNavigateToEditProgramScreen() {
        return this.canNavigateTo(this.button("programScreen.HeaderMenu"));
    }

    public boolean canNavigateToInstallationScreen() {
        return this.canNavigateTo(this.button("installationScreen.HeaderMenu"));
    }

    public boolean canNavigateToMoveTabScreen() {
        return this.canNavigateTo(this.button("moveScreen.HeaderMenu"));
    }

    public boolean canNavigateToIOScreen() {
        return this.canNavigateTo(this.button("ioScreen.HeaderMenu"));
    }

    public boolean canNavigateToLogScreenScreen() {
        return this.canNavigateTo(this.button(LOG_SCREEN));
    }

    private boolean canNavigateTo(AbstractButtonOperator button) {
        return button.isEnabled();
    }

    private AbstractButtonOperator button(String withName) {
        return new AbstractButtonOperator((ContainerOperator)this, ComponentDriver.aComponent((String)withName, (ComponentChooser[])new ComponentChooser[]{ComponentDriver.showing()}));
    }

    public boolean isShowingRunScreen() {
        return this.button("runScreen.HeaderMenu").isSelected();
    }

    public void setSafetyPassword(String safetyPassword) {
        OldSettingsScreenDriver settingsScreen = this.selectSettingsScreen();
        SetSafetyPasswordDriver setSafetyPasswordScreen = settingsScreen.select(SetSafetyPasswordDriver.class);
        if (!setSafetyPasswordScreen.isPasswordSet()) {
            setSafetyPasswordScreen.setSafetyPassword(safetyPassword);
            setSafetyPasswordScreen.applySafetyPassword();
        }
        settingsScreen.exit();
    }

    public void setOperationalModePassword(String operationalModePassword) {
        OldSettingsScreenDriver settingsScreenDriver = this.selectSettingsScreen();
        SetOperationalModePasswordDriver operationalModePasswordDriver = settingsScreenDriver.select(SetOperationalModePasswordDriver.class);
        operationalModePasswordDriver.setOperationalModePassword(operationalModePassword);
        operationalModePasswordDriver.applyOperationalModePassword();
        settingsScreenDriver.exit();
    }

    public void clearOperationalModePassword(String operationalModePassword) {
        OldSettingsScreenDriver settingsScreen = this.selectSettingsScreen();
        SetOperationalModePasswordDriver setSafetyPasswordScreen = settingsScreen.select(SetOperationalModePasswordDriver.class);
        if (setSafetyPasswordScreen.isPasswordSet()) {
            setSafetyPasswordScreen.clearOperationalModePassword(operationalModePassword);
        }
        settingsScreen.exit();
    }

    public static void waitProgramState(ProgramState state) {
        Waiting.until(() -> DashBoard.getProgramState() == state, (int)5000, (int)100, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public String makeUniqueWaypointVariableName(String name) {
        if (this.namingService.isReservedName(name)) {
            name = this.namingService.makeUniqueName(WaypointNode.class, name);
        }
        return this.makeVariableName(name);
    }

    public SpeedPanelDriver getSpeedPanelDriver() {
        return new SpeedPanelDriver(this);
    }

    String makeVariableName(String name) {
        return this.namingService.toVariableName(name);
    }

    public Builder getBuilder() {
        return this.builder;
    }
}

