/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.driver.g5.driver.header;

import com.ur.g5.polyscope.programandinstallation.infrastructure.ActiveProgramAndInstallationDisplay;
import com.ur.polyscope.application.driver.filemanager.OpenFileDialogDriver;
import com.ur.polyscope.driver.api.aspects.ScreenShotTakerAspect;
import com.ur.polyscope.driver.api.dialog.Dialog;
import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.polyscope.driver.g5.driver.PolyScopeDriver;
import com.ur.polyscope.driver.g5.driver.header.SaveInstallationAsDriver;
import com.ur.swing.text.driver.TextPickerOperator;
import com.ur.view.polyscope.persistence.installation.InstallationFilePersistence;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;

public class InstallationPersistenceDriver
extends SaveInstallationAsDriver {
    private final PolyScopeDriver polyScopeDriver;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public InstallationPersistenceDriver(PolyScopeDriver polyScopeDriver) {
        super(polyScopeDriver);
        this.polyScopeDriver = polyScopeDriver;
    }

    public void saveInstallation(String installationName) {
        String string = installationName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            super.press();
            super.specifyName(installationName);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void loadInstallation(String installationName) {
        String string = installationName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            JPopupMenuOperator openMenu = this.polyScopeDriver.getHeaderMenuDriver().selectOpenMenu();
            this.pushPopupMenuItem(openMenu, InstallationFilePersistence.LOAD_INSTALLATION);
            if (this.polyScopeDriver.isDialogShown((Dialog)DialogWithName.UNSAVED_INSTALLATION_CHANGES)) {
                this.polyScopeDriver.inDialog((Dialog)DialogWithName.UNSAVED_INSTALLATION_CHANGES).pushLoadWithoutSave();
            }
            this.pushSetInstallation();
            OpenFileDialogDriver openFileDialogDriver = this.polyScopeDriver.getOpenFileDialogDriver();
            openFileDialogDriver.selectFile(installationName);
            openFileDialogDriver.openFile();
            this.pushSetInstallation();
            this.polyScopeDriver.confirmSafetyChanges();
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void loadInstallationFromDefault(String installationName) {
        String string = installationName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            JPopupMenuOperator openMenu = this.polyScopeDriver.getHeaderMenuDriver().selectOpenMenu();
            this.pushPopupMenuItem(openMenu, InstallationFilePersistence.LOAD_INSTALLATION);
            OpenFileDialogDriver openFileDialogDriver = this.polyScopeDriver.getOpenFileDialogDriver();
            openFileDialogDriver.selectFile(installationName);
            openFileDialogDriver.openFile();
            this.polyScopeDriver.confirmSafetyChanges();
            this.pushSetInstallation();
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void newInstallation() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            JPopupMenuOperator newMenu = this.polyScopeDriver.getHeaderMenuDriver().selectNewMenu();
            this.pushPopupMenuItem(newMenu, InstallationFilePersistence.NEW_INSTALLATION);
            if (this.polyScopeDriver.isDialogShown((Dialog)DialogWithName.NEW_INSTALLATION_SAFETY_CONFIGURATION)) {
                this.polyScopeDriver.inDialog((Dialog)DialogWithName.NEW_INSTALLATION_SAFETY_CONFIGURATION).pushConfirm();
            }
            this.pushSetInstallation();
            this.polyScopeDriver.confirmSafetyChanges();
            if (this.polyScopeDriver.isDialogShown((Dialog)DialogWithName.UNSAVED_INSTALLATION_CHANGES)) {
                this.polyScopeDriver.inDialog((Dialog)DialogWithName.UNSAVED_INSTALLATION_CHANGES).pushLoadWithoutSave();
            }
            this.pushSetInstallation();
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void newInstallationAndResetSafety(String safetyPassword) {
        String string = safetyPassword;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            JPopupMenuOperator newMenu = this.polyScopeDriver.getHeaderMenuDriver().selectNewMenu();
            this.pushPopupMenuItem(newMenu, InstallationFilePersistence.NEW_INSTALLATION);
            if (this.polyScopeDriver.isDialogShown((Dialog)DialogWithName.NEW_INSTALLATION_SAFETY_CONFIGURATION)) {
                this.polyScopeDriver.inDialog((Dialog)DialogWithName.NEW_INSTALLATION_SAFETY_CONFIGURATION).pushCancel();
                TextPickerOperator safetyPasswordInput = new TextPickerOperator((JTextComponentOperator)this.textFieldNamed("passwordField.EnterPasswordPanel"));
                safetyPasswordInput.typeFullText(safetyPassword);
                safetyPasswordInput.clickOk();
                this.pushSetInstallation();
                this.polyScopeUI.confirmSafetyChanges();
                this.polyScopeUI.inDialog((Dialog)DialogWithName.CONFIRM_SAFETY_CONFIGURATION).pushConfirmSafetyConfiguration();
            }
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    private void pushSetInstallation() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            if (this.polyScopeDriver.isDialogShown((Dialog)DialogWithName.SET_INSTALLATION_FOR_PROGRAM)) {
                this.polyScopeDriver.inDialog((Dialog)DialogWithName.SET_INSTALLATION_FOR_PROGRAM).pushSetInstallation();
            }
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public String getLoadedInstallation() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            string = this.labelNamed(ActiveProgramAndInstallationDisplay.ACTIVE_INSTALLATION_HEADER_LABEL).getText();
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
        return string;
    }

    static {
        InstallationPersistenceDriver.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("InstallationPersistenceDriver.java", InstallationPersistenceDriver.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveInstallation", "com.ur.polyscope.driver.g5.driver.header.InstallationPersistenceDriver", "java.lang.String", "installationName", "", "void"), 20);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "loadInstallation", "com.ur.polyscope.driver.g5.driver.header.InstallationPersistenceDriver", "java.lang.String", "installationName", "", "void"), 25);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "loadInstallationFromDefault", "com.ur.polyscope.driver.g5.driver.header.InstallationPersistenceDriver", "java.lang.String", "installationName", "", "void"), 43);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newInstallation", "com.ur.polyscope.driver.g5.driver.header.InstallationPersistenceDriver", "", "", "", "void"), 55);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newInstallationAndResetSafety", "com.ur.polyscope.driver.g5.driver.header.InstallationPersistenceDriver", "java.lang.String", "safetyPassword", "", "void"), 74);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "pushSetInstallation", "com.ur.polyscope.driver.g5.driver.header.InstallationPersistenceDriver", "", "", "", "void"), 89);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLoadedInstallation", "com.ur.polyscope.driver.g5.driver.header.InstallationPersistenceDriver", "", "", "", "java.lang.String"), 95);
    }
}

