/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.driver.g5.driver.installation.general;

import com.ur.polyscope.driver.api.aspects.ScreenShotTakerAspect;
import com.ur.polyscope.driver.g5.driver.BaseDriver;
import com.ur.polyscope.driver.g5.driver.PolyScopeDriver;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.swing.JCheckBox;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.netbeans.jemmy.operators.AbstractButtonOperator;

public class ConveyorTrackingScreen
extends BaseDriver {
    private static final String ENABLE_CONVEYOR_TRACKING = "enableConveyorTracking";
    private static final String ENCODER_TYPE_DROPDOWN = "encoderTypeDropdown";
    private static final String INCREMENTAL_MODE = "incrementalMode";
    private static final String A_INPUT = "aInput";
    private static final String B_INPUT = "bInput";
    private static final String ABSOLUTE_COUNT = "absoluteCount";
    private static final String CONVEYOR_TYPE = "conveyorType";
    private static final String CENTER_POINT = "centerPoint";
    private static final String TPR = "tpr";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    public ConveyorTrackingScreen(PolyScopeDriver uiDriver) {
        super(uiDriver, ENABLE_CONVEYOR_TRACKING);
        this.showScreen();
        ConveyorTrackingScreen.assertTrue("The ConveyorTrackingScreen was not shown", this.isShowing());
    }

    private void showScreen() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            this.push(this.buttonNamed("ConveyorTracking"));
            Waiting.until(this::isShowing, (int)3, (TimeUnit)TimeUnit.SECONDS);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public boolean isConveyorTrackingSelected() {
        return ((JCheckBox)this.checkBoxNamed(ENABLE_CONVEYOR_TRACKING).getSource()).getModel().isSelected();
    }

    public void pushConveyorTracking() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            this.push((AbstractButtonOperator)this.checkBoxNamed(ENABLE_CONVEYOR_TRACKING));
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void selectEncoderType(String type) {
        String string = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            this.select(this.inComboBox(ENCODER_TYPE_DROPDOWN), type);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void selectIncrementalMode(String modeType) {
        String string = modeType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            this.select(this.inComboBox(INCREMENTAL_MODE), modeType);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public int numberOfEncoderCounterVariables() {
        int n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            n = this.countItems(this.inComboBox(ABSOLUTE_COUNT));
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
        return n;
    }

    public void allDisabled() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            ConveyorTrackingScreen.assertTrue("A_INPUT should be disabled", this.isDisabled(A_INPUT));
            ConveyorTrackingScreen.assertTrue("B_INPUT should be disabled", this.isDisabled(B_INPUT));
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public boolean isAInputEnabled() {
        return this.isEnabled(A_INPUT);
    }

    public boolean isBInputEnabled() {
        return this.isEnabled(B_INPUT);
    }

    public String getConveyorType() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            string = String.valueOf(this.comboBoxNamed(CONVEYOR_TYPE).getSelectedItem());
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
        return string;
    }

    public String getEncoderType() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            string = String.valueOf(this.comboBoxNamed(ENCODER_TYPE_DROPDOWN).getSelectedItem());
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
        return string;
    }

    public String getEncoderCountVariable() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            string = String.valueOf(this.comboBoxNamed(ABSOLUTE_COUNT).getSelectedItem());
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
        return string;
    }

    public String getCenterPoint() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            string = String.valueOf(this.comboBoxNamed(CENTER_POINT).getSelectedItem());
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
        return string;
    }

    public String getTicksPerRevolution() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            string = this.textFieldNamed(TPR).getText();
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
        return string;
    }

    private boolean isDisabled(String name) {
        return Waiting.until((Waiting.ItHappens)super.isDisabled(this.componentNamed(name)), (int)1, (TimeUnit)TimeUnit.SECONDS);
    }

    private boolean isEnabled(String name) {
        return Waiting.until((Waiting.ItHappens)super.isEnabled(this.componentNamed(name)), (int)1, (TimeUnit)TimeUnit.SECONDS);
    }

    public boolean isShowing() {
        return super.isShowing();
    }

    static {
        ConveyorTrackingScreen.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConveyorTrackingScreen.java", ConveyorTrackingScreen.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "showScreen", "com.ur.polyscope.driver.g5.driver.installation.general.ConveyorTrackingScreen", "", "", "", "void"), 39);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pushConveyorTracking", "com.ur.polyscope.driver.g5.driver.installation.general.ConveyorTrackingScreen", "", "", "", "void"), 48);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTicksPerRevolution", "com.ur.polyscope.driver.g5.driver.installation.general.ConveyorTrackingScreen", "", "", "", "java.lang.String"), 93);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectEncoderType", "com.ur.polyscope.driver.g5.driver.installation.general.ConveyorTrackingScreen", "java.lang.String", "type", "", "void"), 52);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectIncrementalMode", "com.ur.polyscope.driver.g5.driver.installation.general.ConveyorTrackingScreen", "java.lang.String", "modeType", "", "void"), 56);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "numberOfEncoderCounterVariables", "com.ur.polyscope.driver.g5.driver.installation.general.ConveyorTrackingScreen", "", "", "", "int"), 60);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "allDisabled", "com.ur.polyscope.driver.g5.driver.installation.general.ConveyorTrackingScreen", "", "", "", "void"), 64);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConveyorType", "com.ur.polyscope.driver.g5.driver.installation.general.ConveyorTrackingScreen", "", "", "", "java.lang.String"), 77);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEncoderType", "com.ur.polyscope.driver.g5.driver.installation.general.ConveyorTrackingScreen", "", "", "", "java.lang.String"), 81);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEncoderCountVariable", "com.ur.polyscope.driver.g5.driver.installation.general.ConveyorTrackingScreen", "", "", "", "java.lang.String"), 85);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCenterPoint", "com.ur.polyscope.driver.g5.driver.installation.general.ConveyorTrackingScreen", "", "", "", "java.lang.String"), 89);
    }
}

