/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.driver.g5.driver.installation.safety;

import com.ur.polyscope.driver.api.aspects.ScreenShotTakerAspect;
import com.ur.polyscope.driver.g5.driver.BaseDriver;
import com.ur.polyscope.driver.g5.driver.PolyScopeDriver;
import com.ur.safety.generallimits.infrastructure.GeneralLimitsPanel;
import com.ur.safety.generallimits.infrastructure.RobotLimitsPanel;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.netbeans.jemmy.operators.JRadioButtonOperator;
import org.netbeans.jemmy.operators.JSliderOperator;

public class RobotLimitsDriver
extends BaseDriver {
    private static final int MOST_RESTRICTED_MODE = 0;
    private static final int LEAST_RESTRICTED_MODE = 3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    public RobotLimitsDriver(PolyScopeDriver polyScopeUI) {
        super(polyScopeUI, GeneralLimitsPanel.LIMITS_MODE_SELECTOR);
        RobotLimitsDriver.assertTrue("GeneralLimitsPanel is not showing", this.isShowing());
    }

    public boolean isShowing() {
        return super.isShowing();
    }

    public void changeSafetyModeSelector() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            JSliderOperator operator = this.sliderNamed(GeneralLimitsPanel.LIMITS_MODE_SELECTOR);
            operator.setValue(operator.getValue() == 1 ? 2 : 1);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void toggleCustomMode() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            this.radioButtonNamed(RobotLimitsPanel.CUSTOM_SETTINGS_RADIO_BUTTON).clickMouse();
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public boolean toggleFactoryPresetMode() {
        boolean bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            JRadioButtonOperator jRadioButtonOperator = this.radioButtonNamed(RobotLimitsPanel.FACTORY_PRESET_RADIO_BUTTON);
            if (!jRadioButtonOperator.isSelected()) {
                jRadioButtonOperator.clickMouse();
                bl = true;
            } else {
                bl = false;
            }
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
        return bl;
    }

    public void setSafetyModeSelectorToMaximumRestriction() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            JSliderOperator operator = this.sliderNamed(GeneralLimitsPanel.LIMITS_MODE_SELECTOR);
            operator.setValue(0);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void setSafetyModeSelectorToLeastRestriction() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            JSliderOperator operator = this.sliderNamed(GeneralLimitsPanel.LIMITS_MODE_SELECTOR);
            operator.setValue(3);
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public boolean isSafetyModeSetToMaximumRestriction() {
        JSliderOperator operator = this.sliderNamed(GeneralLimitsPanel.LIMITS_MODE_SELECTOR);
        return operator.getValue() == 0;
    }

    public boolean isSafetyModeSetToLeastRestriction() {
        JSliderOperator operator = this.sliderNamed(GeneralLimitsPanel.LIMITS_MODE_SELECTOR);
        return operator.getValue() == 3;
    }

    public void setSafetyCustomReducedModeValuesToLowestPossible() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            this.toggleCustomMode();
            this.setNumberValue(GeneralLimitsPanel.POWER_REDUCED_MODE, "80");
            this.setNumberValue(GeneralLimitsPanel.MOMENTUM_REDUCED_MODE, "4.0");
            this.setNumberValue(GeneralLimitsPanel.STOPPING_TIME_REDUCED_MODE, "100");
            this.setNumberValue(GeneralLimitsPanel.STOPPING_DISTANCE_REDUCED_MODE, "50");
            this.setNumberValue(GeneralLimitsPanel.SPEED_REDUCED_MODE, "160");
            this.setNumberValue(GeneralLimitsPanel.FORCE_REDUCED_MODE, "100.0");
            this.setNumberValue(GeneralLimitsPanel.ELBOW_SPEED_REDUCED_MODE, "160");
            this.setNumberValue(GeneralLimitsPanel.ELBOW_FORCE_REDUCE_MODE, "100.0");
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void setSafetyCustomNormalModeValuesToLowestPossible() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            this.toggleCustomMode();
            this.setNumberValue(GeneralLimitsPanel.POWER_NORMAL_MODE, "80");
            this.setNumberValue(GeneralLimitsPanel.MOMENTUM_NORMAL_MODE, "4.0");
            this.setNumberValue(GeneralLimitsPanel.STOPPING_TIME_NORMAL_MODE, "100");
            this.setNumberValue(GeneralLimitsPanel.STOPPING_DISTANCE_NORMAL_MODE, "50");
            this.setNumberValue(GeneralLimitsPanel.SPEED_NORMAL_MODE, "160");
            this.setNumberValue(GeneralLimitsPanel.FORCE_NORMAL_MODE, "100.0");
            this.setNumberValue(GeneralLimitsPanel.ELBOW_SPEED_NORMAL_MODE, "160");
            this.setNumberValue(GeneralLimitsPanel.ELBOW_FORCE_NORMAL_MODE, "100.0");
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void setSafetyCustomReducedModeValuesToHighestPossible() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            this.toggleCustomMode();
            this.setNumberValue(GeneralLimitsPanel.POWER_REDUCED_MODE, "1000");
            this.setNumberValue(GeneralLimitsPanel.MOMENTUM_REDUCED_MODE, "100.0");
            this.setNumberValue(GeneralLimitsPanel.STOPPING_TIME_REDUCED_MODE, "1000");
            this.setNumberValue(GeneralLimitsPanel.STOPPING_DISTANCE_REDUCED_MODE, "4000");
            this.setNumberValue(GeneralLimitsPanel.SPEED_REDUCED_MODE, "5000");
            this.setNumberValue(GeneralLimitsPanel.FORCE_REDUCED_MODE, "250.0");
            this.setNumberValue(GeneralLimitsPanel.ELBOW_SPEED_REDUCED_MODE, "5000");
            this.setNumberValue(GeneralLimitsPanel.ELBOW_FORCE_REDUCE_MODE, "250.0");
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void setSafetyCustomNormalModeValuesToHighestPossible() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            this.toggleCustomMode();
            this.setNumberValue(GeneralLimitsPanel.POWER_NORMAL_MODE, "1000");
            this.setNumberValue(GeneralLimitsPanel.MOMENTUM_NORMAL_MODE, "100.0");
            this.setNumberValue(GeneralLimitsPanel.STOPPING_TIME_NORMAL_MODE, "1000");
            this.setNumberValue(GeneralLimitsPanel.STOPPING_DISTANCE_NORMAL_MODE, "4000");
            this.setNumberValue(GeneralLimitsPanel.SPEED_NORMAL_MODE, "5000");
            this.setNumberValue(GeneralLimitsPanel.FORCE_NORMAL_MODE, "250.0");
            this.setNumberValue(GeneralLimitsPanel.ELBOW_SPEED_NORMAL_MODE, "5000");
            this.setNumberValue(GeneralLimitsPanel.ELBOW_FORCE_NORMAL_MODE, "250.0");
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void verifySafetyCustomReducedModeValuesSetToLowestPossible() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            RobotLimitsDriver.assertTrue("Custom Robot limits not selected", this.radioButtonNamed(RobotLimitsPanel.CUSTOM_SETTINGS_RADIO_BUTTON).isSelected());
            RobotLimitsDriver.assertEquals("Reduced Power not set to 80 W", "80", this.getTextFieldValue(GeneralLimitsPanel.POWER_REDUCED_MODE));
            RobotLimitsDriver.assertEquals("Reduced Momentum not set to 4.0 kg m/s", "4.0", this.getTextFieldValue(GeneralLimitsPanel.MOMENTUM_REDUCED_MODE));
            RobotLimitsDriver.assertEquals("Reduced Stopping Time not set to 100 ms", "100", this.getTextFieldValue(GeneralLimitsPanel.STOPPING_TIME_REDUCED_MODE));
            RobotLimitsDriver.assertEquals("Reduced Stopping Distance not set to 50 mm", "50", this.getTextFieldValue(GeneralLimitsPanel.STOPPING_DISTANCE_REDUCED_MODE));
            RobotLimitsDriver.assertEquals("Reduced Tool Speed not set to 160 mm/s", "160", this.getTextFieldValue(GeneralLimitsPanel.SPEED_REDUCED_MODE));
            RobotLimitsDriver.assertEquals("Reduced Tool Force not set to 100 N", "100.0", this.getTextFieldValue(GeneralLimitsPanel.FORCE_REDUCED_MODE));
            RobotLimitsDriver.assertEquals("Reduced Elbow Speed not set to 160 mm/s", "160", this.getTextFieldValue(GeneralLimitsPanel.ELBOW_SPEED_REDUCED_MODE));
            RobotLimitsDriver.assertEquals("Reduced Elbow Force not set to 100 N", "100.0", this.getTextFieldValue(GeneralLimitsPanel.ELBOW_FORCE_REDUCE_MODE));
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void verifySafetyCustomNormalModeValuesSetToLowestPossible() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            RobotLimitsDriver.assertTrue("Custom Robot limits not selected", this.radioButtonNamed(RobotLimitsPanel.CUSTOM_SETTINGS_RADIO_BUTTON).isSelected());
            RobotLimitsDriver.assertEquals("Normal Power not set to 80 W", "80", this.getTextFieldValue(GeneralLimitsPanel.POWER_NORMAL_MODE));
            RobotLimitsDriver.assertEquals("Normal Momentum not set to 4.0 kg m/s", "4.0", this.getTextFieldValue(GeneralLimitsPanel.MOMENTUM_NORMAL_MODE));
            RobotLimitsDriver.assertEquals("Normal Stopping Time not set to 100 ms", "100", this.getTextFieldValue(GeneralLimitsPanel.STOPPING_TIME_NORMAL_MODE));
            RobotLimitsDriver.assertEquals("Normal Stopping Distance not set to 50 mm", "50", this.getTextFieldValue(GeneralLimitsPanel.STOPPING_DISTANCE_NORMAL_MODE));
            RobotLimitsDriver.assertEquals("Normal Tool Speed not set to 160 mm/s", "160", this.getTextFieldValue(GeneralLimitsPanel.SPEED_NORMAL_MODE));
            RobotLimitsDriver.assertEquals("Normal Tool Force not set to 100 N", "100.0", this.getTextFieldValue(GeneralLimitsPanel.FORCE_NORMAL_MODE));
            RobotLimitsDriver.assertEquals("Normal Elbow Speed not set to 160 mm/s", "160", this.getTextFieldValue(GeneralLimitsPanel.ELBOW_SPEED_NORMAL_MODE));
            RobotLimitsDriver.assertEquals("Normal Elbow Force not set to 100 N", "100.0", this.getTextFieldValue(GeneralLimitsPanel.ELBOW_FORCE_NORMAL_MODE));
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void verifySafetyCustomReducedModeValuesSetToHighestPossible() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            RobotLimitsDriver.assertTrue("Custom Robot limits not selected", this.radioButtonNamed(RobotLimitsPanel.CUSTOM_SETTINGS_RADIO_BUTTON).isSelected());
            RobotLimitsDriver.assertEquals("Reduced Power not set to 1000 W", "1000", this.getTextFieldValue(GeneralLimitsPanel.POWER_REDUCED_MODE));
            RobotLimitsDriver.assertEquals("Reduced Momentum not set to 100.0 kg m/s", "100.0", this.getTextFieldValue(GeneralLimitsPanel.MOMENTUM_REDUCED_MODE));
            RobotLimitsDriver.assertEquals("Reduced Stopping Time not set to 1000 ms", "1000", this.getTextFieldValue(GeneralLimitsPanel.STOPPING_TIME_REDUCED_MODE));
            RobotLimitsDriver.assertEquals("Reduced Stopping Distance not set to 4000 mm", "4000", this.getTextFieldValue(GeneralLimitsPanel.STOPPING_DISTANCE_REDUCED_MODE));
            RobotLimitsDriver.assertEquals("Reduced Tool Speed not set to 5000 mm/s", "5000", this.getTextFieldValue(GeneralLimitsPanel.SPEED_REDUCED_MODE));
            RobotLimitsDriver.assertEquals("Reduced Tool Force not set to 250 N", "250.0", this.getTextFieldValue(GeneralLimitsPanel.FORCE_REDUCED_MODE));
            RobotLimitsDriver.assertEquals("Reduced Elbow Speed not set to 5000 mm/s", "5000", this.getTextFieldValue(GeneralLimitsPanel.ELBOW_SPEED_REDUCED_MODE));
            RobotLimitsDriver.assertEquals("Reduced Elbow Force not set to 250 N", "250.0", this.getTextFieldValue(GeneralLimitsPanel.ELBOW_FORCE_REDUCE_MODE));
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    public void verifySafetyCustomNormalModeValuesSetToHighestPossible() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)((Object)this), (Object)((Object)this));
        try {
            ScreenShotTakerAspect.aspectOf().screenShotBeforeMethodExecution(joinPoint);
            RobotLimitsDriver.assertTrue("Custom Robot limits not selected", this.radioButtonNamed(RobotLimitsPanel.CUSTOM_SETTINGS_RADIO_BUTTON).isSelected());
            RobotLimitsDriver.assertEquals("Normal Power not set to 1000 W", "1000", this.getTextFieldValue(GeneralLimitsPanel.POWER_NORMAL_MODE));
            RobotLimitsDriver.assertEquals("Normal Momentum not set to 100.0 kg m/s", "100.0", this.getTextFieldValue(GeneralLimitsPanel.MOMENTUM_NORMAL_MODE));
            RobotLimitsDriver.assertEquals("Normal Stopping Time not set to 1000 ms", "1000", this.getTextFieldValue(GeneralLimitsPanel.STOPPING_TIME_NORMAL_MODE));
            RobotLimitsDriver.assertEquals("Normal Stopping Distance not set to 4000 mm", "4000", this.getTextFieldValue(GeneralLimitsPanel.STOPPING_DISTANCE_NORMAL_MODE));
            RobotLimitsDriver.assertEquals("Normal Tool Speed not set to 5000 mm/s", "5000", this.getTextFieldValue(GeneralLimitsPanel.SPEED_NORMAL_MODE));
            RobotLimitsDriver.assertEquals("Normal Tool Force not set to 250 N", "250.0", this.getTextFieldValue(GeneralLimitsPanel.FORCE_NORMAL_MODE));
            RobotLimitsDriver.assertEquals("Normal Elbow Speed not set to 5000 mm/s", "5000", this.getTextFieldValue(GeneralLimitsPanel.ELBOW_SPEED_NORMAL_MODE));
            RobotLimitsDriver.assertEquals("Normal Elbow Force not set to 250 N", "250.0", this.getTextFieldValue(GeneralLimitsPanel.ELBOW_FORCE_NORMAL_MODE));
        }
        finally {
            ScreenShotTakerAspect.aspectOf().screenShotAfterMethodExecution(joinPoint);
        }
    }

    static {
        RobotLimitsDriver.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RobotLimitsDriver.java", RobotLimitsDriver.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "changeSafetyModeSelector", "com.ur.polyscope.driver.g5.driver.installation.safety.RobotLimitsDriver", "", "", "", "void"), 25);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toggleCustomMode", "com.ur.polyscope.driver.g5.driver.installation.safety.RobotLimitsDriver", "", "", "", "void"), 30);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "verifySafetyCustomNormalModeValuesSetToLowestPossible", "com.ur.polyscope.driver.g5.driver.installation.safety.RobotLimitsDriver", "", "", "", "void"), 123);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "verifySafetyCustomReducedModeValuesSetToHighestPossible", "com.ur.polyscope.driver.g5.driver.installation.safety.RobotLimitsDriver", "", "", "", "void"), 135);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "verifySafetyCustomNormalModeValuesSetToHighestPossible", "com.ur.polyscope.driver.g5.driver.installation.safety.RobotLimitsDriver", "", "", "", "void"), 147);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toggleFactoryPresetMode", "com.ur.polyscope.driver.g5.driver.installation.safety.RobotLimitsDriver", "", "", "", "boolean"), 34);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSafetyModeSelectorToMaximumRestriction", "com.ur.polyscope.driver.g5.driver.installation.safety.RobotLimitsDriver", "", "", "", "void"), 43);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSafetyModeSelectorToLeastRestriction", "com.ur.polyscope.driver.g5.driver.installation.safety.RobotLimitsDriver", "", "", "", "void"), 48);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSafetyCustomReducedModeValuesToLowestPossible", "com.ur.polyscope.driver.g5.driver.installation.safety.RobotLimitsDriver", "", "", "", "void"), 63);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSafetyCustomNormalModeValuesToLowestPossible", "com.ur.polyscope.driver.g5.driver.installation.safety.RobotLimitsDriver", "", "", "", "void"), 75);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSafetyCustomReducedModeValuesToHighestPossible", "com.ur.polyscope.driver.g5.driver.installation.safety.RobotLimitsDriver", "", "", "", "void"), 87);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSafetyCustomNormalModeValuesToHighestPossible", "com.ur.polyscope.driver.g5.driver.installation.safety.RobotLimitsDriver", "", "", "", "void"), 99);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "verifySafetyCustomReducedModeValuesSetToLowestPossible", "com.ur.polyscope.driver.g5.driver.installation.safety.RobotLimitsDriver", "", "", "", "void"), 111);
    }
}

