/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.defaultprogram;

import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.Trigger;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import gui.installation.RobotInstallationLookupService;

public abstract class AbstractInputTrigger
implements InstallationStateListener,
Trigger,
RobotStateListener {
    public static final int AFTER_BOOT = -1;
    private final Object listenLock = new Object();
    protected final RobotInstallationLookupService lookupService;
    private int triggerLevel;
    protected int prevTriggerLevel = -1;
    private Pin<?> triggerInput;
    private boolean triggered = false;
    private boolean trigger_valid = false;
    boolean enableTriggerAction = false;

    public AbstractInputTrigger(RobotInstallationLookupService lookupService) {
        this.lookupService = lookupService;
        EventNotificationService.register((Object)this, InstallationStateListener.class, (Object)this);
    }

    public abstract boolean preCondition(RobotState var1);

    public abstract void triggered(RobotState var1);

    public void onPress() {
        if (this.triggerLevel == 1) {
            EventNotificationService.register((Object)this, RobotStateListener.class, (Object)this);
        } else {
            EventNotificationService.unregister((Object)this, RobotStateListener.class);
        }
        if (this.enableTriggerAction) {
            this.updateRobotState(RobotState.getLatestRobotState());
        }
    }

    public void onRelease() {
        if (this.triggerLevel == 0) {
            EventNotificationService.register((Object)this, RobotStateListener.class, (Object)this);
        } else {
            EventNotificationService.unregister((Object)this, RobotStateListener.class);
        }
        if (this.enableTriggerAction) {
            this.updateRobotState(RobotState.getLatestRobotState());
        }
    }

    public void updateRobotState(RobotState rs) {
        if (this.preCondition(rs) && this.trigger_valid) {
            int level = this.getTriggerLevel();
            this.triggered = level == this.triggerLevel && this.prevTriggerLevel != this.triggerLevel;
            this.prevTriggerLevel = level;
            if (this.triggered) {
                EventNotificationService.unregister((Object)this, RobotStateListener.class);
                this.triggered(rs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableTriggering() {
        Object object = this.listenLock;
        synchronized (object) {
            if (!this.enableTriggerAction) {
                this.invalidateTrigger();
                this.enableTriggerAction = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disableTriggering() {
        Object object = this.listenLock;
        synchronized (object) {
            if (this.enableTriggerAction) {
                EventNotificationService.unregister((Object)this, RobotStateListener.class);
                this.enableTriggerAction = false;
            }
        }
    }

    public void updateTrigger() {
        if (this.trigger_valid) {
            int level = this.getTriggerLevel();
            this.triggered = level == this.triggerLevel && this.prevTriggerLevel != this.triggerLevel;
            this.prevTriggerLevel = level;
        } else {
            this.triggered = false;
        }
    }

    private int getTriggerLevel() {
        int level = this.triggerInput.getValue() instanceof Byte ? ((Byte)this.triggerInput.getValue()).intValue() : (this.triggerInput.getValue() instanceof Boolean ? ((Boolean)this.triggerInput.getValue() != false ? 1 : 0) : (Integer)this.triggerInput.getValue());
        return level;
    }

    private void invalidateTrigger() {
        if (this.prevTriggerLevel != -1) {
            this.updateTrigger();
            this.triggered = false;
        }
    }

    protected boolean isTriggering() {
        return this.enableTriggerAction;
    }

    public boolean isTriggerValid() {
        return this.trigger_valid;
    }

    protected boolean updateTriggerSettings(PinReference triggerInput, boolean triggerLevel) {
        int n = this.triggerLevel = triggerLevel ? 1 : 0;
        if (triggerInput != null && triggerInput.dereference() != null) {
            this.triggerInput = triggerInput.dereference();
            Log.info((String)("Using sensor: " + triggerInput.toString()));
            return true;
        }
        return false;
    }

    protected abstract boolean updateTriggerSettings(Installation var1);

    public void installationLoaded(Installation installation) {
        this.trigger_valid = this.updateTriggerSettings(installation);
    }

    public void installationModified() {
    }

    public void installationSaved() {
        this.trigger_valid = this.updateTriggerSettings(this.lookupService.getInstallation());
    }

    public void installationLoadFailed() {
    }

    protected <T extends InstallationComponent> T getComponent(Installation installation, Class<T> componentType) {
        if (installation == null) {
            return null;
        }
        try {
            return (T)installation.getComponent(componentType);
        }
        catch (Exception exception) {
            Log.warning((String)("Could not find component: " + componentType));
            return null;
        }
    }
}

