/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.defaultprogram;

import com.ur.lang.EqualsUtil;
import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.RobotModeListener;
import com.ur.polyscope.defaultprogram.AbstractInputTrigger;
import com.ur.polyscope.defaultprogram.DefaultProgramSettings;
import com.ur.polyscope.defaultprogram.ResetAutoStartTrigger;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.hmc.ControllerSocketSender;
import com.ur.view.hmc.HMC;
import com.ur.view.robot.PowerUpRobot;
import gui.installation.RobotInstallationLookupService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class AutoInitialize
extends AbstractInputTrigger
implements RobotModeListener {
    private static final int TIMES_TO_TRY_MOUNTING_CHECK = 5;
    private final AtomicBoolean initializing = new AtomicBoolean(false);
    private Provider<ResetAutoStartTrigger> autoStartDefaultProgramProvider;
    private PowerUpRobot powerUpRobot;

    @Inject
    AutoInitialize(RobotInstallationLookupService lookupService, Provider<ResetAutoStartTrigger> autoStartDefaultProgramProvider, PowerUpRobot powerUpRobot) {
        super(lookupService);
        this.autoStartDefaultProgramProvider = autoStartDefaultProgramProvider;
        this.powerUpRobot = powerUpRobot;
        EventNotificationService.register((Object)this, RobotModeListener.class, (Object)this);
        EventNotificationService.register((Object)this, InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationLoaded(Installation installation) {
                DefaultProgramSettings programSettings = (DefaultProgramSettings)installation.getComponent(DefaultProgramSettings.class);
                if (programSettings != null) {
                    programSettings.updateAutoInitializeFromPinReference();
                }
            }
        });
    }

    private boolean isAutoInitializeable(RobotMode robotMode, SafetyMode safetyMode) {
        return EqualsUtil.equalsOneOf((Object)robotMode, (Object[])new RobotMode[]{RobotMode.POWER_OFF, RobotMode.POWER_ON, RobotMode.IDLE}) && EqualsUtil.equalsOneOf((Object)safetyMode, (Object[])new SafetyMode[]{SafetyMode.NORMAL, SafetyMode.REDUCED});
    }

    private boolean isAutoInitializationConfigured() {
        DefaultProgramSettings settings = (DefaultProgramSettings)this.lookupService.getComponent(DefaultProgramSettings.class);
        return this.isTriggerValid() && settings.shouldInitializeRobot();
    }

    @Override
    public boolean preCondition(RobotState rs) {
        return this.isAutoInitializeable(rs.robotMode, rs.masterSafetyState);
    }

    @Override
    public void triggered(RobotState rs) {
        if (this.isAutoInitializeable(rs.robotMode, rs.masterSafetyState)) {
            this.kickoffInitialization();
        }
    }

    private void kickoffInitialization() {
        if (!this.initializing.compareAndSet(false, true)) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean poweredOn = AutoInitialize.this.powerUpRobot.sendPowerOnAndWaitTillRobotIsReady();
                if (poweredOn) {
                    AutoInitialize.this.tryBrakeRelease();
                }
                AutoInitialize.this.initializing.set(false);
            }
        }).start();
    }

    private void tryBrakeRelease() {
        RobotState rs = RobotState.getLatestRobotState();
        if (this.isAutoInitializeable(rs.robotMode, rs.masterSafetyState)) {
            boolean mountingCorrect = false;
            int i = 0;
            while (i < 5) {
                mountingCorrect = new HMC().isRobotMountingCorrect();
                if (mountingCorrect) break;
                Waiting.pause((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                ++i;
            }
            if (mountingCorrect) {
                Log.info((String)"Sending brake release!");
                ControllerSocketSender.sendReleaseBrakes();
            }
        } else {
            Log.error((String)("Unable to automatically initialize robot. Robot mode is: " + rs.robotMode));
        }
    }

    public void modeChanged(RobotMode oldValue, RobotMode newValue) {
        if (this.isTriggering() && newValue == RobotMode.RUNNING) {
            Log.info((String)"Automatic initialization successful.");
            ((ResetAutoStartTrigger)this.autoStartDefaultProgramProvider.get()).resetTriggerValid();
        }
        if (this.isAutoInitializationConfigured() && this.isAutoInitializeable(newValue, SafetyMode.NORMAL)) {
            this.enableTriggering();
        } else {
            this.disableTriggering();
        }
    }

    @Override
    protected boolean updateTriggerSettings(Installation installation) {
        DefaultProgramSettings defaultProgramSettings = this.getComponent(installation, DefaultProgramSettings.class);
        if (defaultProgramSettings == null) {
            defaultProgramSettings = (DefaultProgramSettings)this.lookupService.getComponent(DefaultProgramSettings.class);
        }
        if (defaultProgramSettings != null) {
            return this.updateTriggerSettings(defaultProgramSettings.getAutoInitializeSensor(), defaultProgramSettings.getAutoInitializeSensorValue());
        }
        return false;
    }
}

