/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.defaultprogram;

import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.defaultprogram.AutoLoadWhen;
import com.ur.polyscope.defaultprogram.DefaultProgramSettings;
import com.ur.polyscope.defaultprogram.ForceLoadDefaultProgram;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import gui.polyscope.DashBoard;
import gui.program.ProgramRootNode;
import gui.program.ProgramRootNodeLoad;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AutoLoadDefaultProgram
implements ProgramModeHolder.ProgramModeListener,
ForceLoadDefaultProgram {
    private final Object lock = new Object();
    private final InstallationComponentLookup lookupService;
    private AutoLoadWhen autoLoadWhen;
    private boolean shouldLoad = false;
    private Thread defferedLoader = null;
    private ControllerInterface controllerInterface;

    @Inject
    AutoLoadDefaultProgram(ProgramModeHolder programModeHolder, InstallationComponentLookup lookupService, AutoLoadWhen autoLoadWhen, ControllerInterface controllerInterface) {
        this.lookupService = lookupService;
        this.autoLoadWhen = autoLoadWhen;
        this.controllerInterface = controllerInterface;
        EventNotificationService.register((Object)this, ProgramModeHolder.ProgramModeListener.class, (Object)this);
        ProgramModeHolder.ProgramMode mode = programModeHolder.getMode();
        if (mode != ProgramModeHolder.ProgramMode.Unknown) {
            this.changedMode(mode);
        }
    }

    private boolean isAutoLoadable() {
        return this.autoLoadWhen.condition();
    }

    public void changedMode(ProgramModeHolder.ProgramMode newMode) {
        if (newMode == ProgramModeHolder.ProgramMode.ReadOnly || newMode == ProgramModeHolder.ProgramMode.Editable) {
            this.shouldLoad = true;
            this.deferredLoad();
        } else {
            this.shouldLoad = false;
        }
    }

    @Override
    public void forceLoadProgram() {
        this.shouldLoad = true;
        this.deferredLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deferredLoad() {
        Object object = this.lock;
        synchronized (object) {
            if (this.defferedLoader != null) {
                return;
            }
            this.defferedLoader = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (!AutoLoadDefaultProgram.this.controllerInterface.isControllerAvailable() && !Waiting.until((Waiting.ItHappens)new ControllerAvailableOrAborted(), (int)732, (TimeUnit)TimeUnit.DAYS)) {
                        return;
                    }
                    if (AutoLoadDefaultProgram.this.isAutoLoadable() && AutoLoadDefaultProgram.this.shouldLoad) {
                        AutoLoadDefaultProgram.this.doLoadDefaultProgram();
                    }
                    AutoLoadDefaultProgram.this.defferedLoader = null;
                }
            });
        }
        this.defferedLoader.start();
    }

    private boolean doLoadDefaultProgram() {
        File defaultFile = ((DefaultProgramSettings)this.lookupService.getComponent(DefaultProgramSettings.class)).getProgramFile();
        if (defaultFile == null || !defaultFile.exists()) {
            Log.warning((String)"Cannot start a non existing program");
            return false;
        }
        ProgramRootNode p = null;
        try {
            try {
                DashBoard.autoLoadingNoPopups = true;
                p = ProgramRootNodeLoad.autoloadWithOutKinematicCheck((File)defaultFile);
            }
            catch (Exception e) {
                Log.error((String)("Could not load program: " + defaultFile), (Throwable)e);
                DashBoard.autoLoadingNoPopups = false;
                return false;
            }
        }
        finally {
            DashBoard.autoLoadingNoPopups = false;
        }
        if (!this.shouldLoad) {
            Log.warning((String)"Program load aborted.");
            return false;
        }
        DashBoard.setProgram((ProgramRootNode)p);
        Log.debug((String)"Program set");
        return true;
    }

    private class ControllerAvailableOrAborted
    implements Waiting.ItHappens {
        private ControllerAvailableOrAborted() {
        }

        public boolean itHappened() {
            return AutoLoadDefaultProgram.this.controllerInterface.isControllerAvailable() || !AutoLoadDefaultProgram.this.shouldLoad;
        }
    }
}

