/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.defaultprogram;

import com.ur.lang.EqualsUtil;
import com.ur.monitor.RobotState;
import com.ur.polyscope.defaultprogram.AbstractInputTrigger;
import com.ur.polyscope.defaultprogram.AutoStartDefaultProgram$AjcClosure1;
import com.ur.polyscope.defaultprogram.DefaultProgramSettings;
import com.ur.polyscope.defaultprogram.ResetAutoStartTrigger;
import com.ur.polyscope.defaultprogram.StartDefaultProgramTrigger;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.program.ProgramStateListener;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.swing.dialog.YesNoCancelDialogListener;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.gui.threading.WorkerDeamon;
import com.ur.view.gui.threading.WorkerDeamonAspect;
import com.ur.view.program.StartStopDefaultProgram;
import gui.installation.RobotInstallationLookupService;
import gui.polyscope.DashBoard;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramRootNode;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Singleton
public class AutoStartDefaultProgram
extends AbstractInputTrigger
implements StartStopDefaultProgram,
ProgramStateListener,
ProgramModeHolder.ProgramModeListener,
ResetAutoStartTrigger,
StartDefaultProgramTrigger {
    private static final int AFTER_AUTO_INITIALIZE = -2;
    private final ProgramModeHolder programModeHolder;
    private final AutoStartResolver resolver;
    private boolean userInterrupted = false;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Inject
    public AutoStartDefaultProgram(ProgramModeHolder programModeHolder, RobotInstallationLookupService lookupService, AutoStartResolver resolver) {
        super(lookupService);
        this.programModeHolder = programModeHolder;
        this.resolver = resolver;
        EventNotificationService.register((Object)this, ProgramStateListener.class, (Object)this);
        EventNotificationService.register((Object)this, ProgramModeHolder.ProgramModeListener.class, (Object)this);
        ProgramModeHolder.ProgramMode programMode = programModeHolder.getMode();
        if (programMode != ProgramModeHolder.ProgramMode.Unknown) {
            this.changedMode(programMode);
        }
        EventNotificationService.register((Object)this, InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationLoaded(Installation installation) {
                DefaultProgramSettings programSettings = (DefaultProgramSettings)installation.getComponent(DefaultProgramSettings.class);
                if (programSettings != null) {
                    programSettings.updateAutoStartFromPinReference();
                }
            }
        });
    }

    private boolean shouldAutoStartDefaultProgram() {
        return ((DefaultProgramSettings)this.lookupService.getComponent(DefaultProgramSettings.class)).shouldAutomaticallyStartDefaultProgram();
    }

    private boolean shouldAutomaticallyStartDefaultProgram() {
        if (this.shouldAutoStartDefaultProgram() && DashBoard.getProgram() != null) {
            boolean isStopped = DashBoard.getProgramState() == ProgramState.STOPPED;
            ProgramRootNode programRootNode = DashBoard.getProgram();
            boolean isLoadedProgramSameAsDefaultProgram = ((DefaultProgramSettings)this.lookupService.getComponent(DefaultProgramSettings.class)).getProgramFile().equals(((FileManagementProgramComponent)programRootNode.getComponent(FileManagementProgramComponent.class)).getFile(programRootNode));
            return isStopped && isLoadedProgramSameAsDefaultProgram;
        }
        return false;
    }

    @Override
    public boolean preCondition(RobotState rs) {
        return rs.robotMode == RobotMode.RUNNING && this.isAllowedToAutoRun(rs) && DashBoard.getProgram() != null;
    }

    public boolean isAllowedToAutoRun(RobotState rs) {
        if (rs == null) {
            rs = RobotState.getLatestRobotState();
        }
        return EqualsUtil.equalsOneOf((Object)rs.masterSafetyState, (Object[])new SafetyMode[]{SafetyMode.NORMAL, SafetyMode.REDUCED});
    }

    @Override
    public void triggered(RobotState rs) {
        if (!this.userInterrupted && this.shouldAutomaticallyStartDefaultProgram()) {
            this.doAutoStartDefaultProgram();
            this.disableTriggering();
        }
    }

    @WorkerDeamon
    private void doAutoStartDefaultProgram() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        AutoStartDefaultProgram$AjcClosure1 autoStartDefaultProgram$AjcClosure1 = new AutoStartDefaultProgram$AjcClosure1(objectArray);
        WorkerDeamonAspect.aspectOf().aroundAnnotatedMethod(autoStartDefaultProgram$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    protected boolean updateTriggerSettings(Installation installation) {
        DefaultProgramSettings defaultProgramSettings = this.getComponent(installation, DefaultProgramSettings.class);
        if (defaultProgramSettings == null) {
            defaultProgramSettings = (DefaultProgramSettings)this.lookupService.getComponent(DefaultProgramSettings.class);
        }
        if (defaultProgramSettings != null) {
            return this.updateTriggerSettings(defaultProgramSettings.getAutoStartProgramSensor(), defaultProgramSettings.getAutoStartProgramSensorValue());
        }
        return false;
    }

    public void changedMode(ProgramModeHolder.ProgramMode newMode) {
        if (newMode == ProgramModeHolder.ProgramMode.ReadOnly || newMode == ProgramModeHolder.ProgramMode.Editable) {
            if (this.shouldAutoStartDefaultProgram()) {
                this.enableTriggering();
            } else {
                this.disableTriggering();
            }
        } else if (newMode == ProgramModeHolder.ProgramMode.Unknown) {
            this.disableTriggering();
            this.interruptTriggering();
        }
    }

    public void programStateChanged(ProgramState oldState, ProgramState newState) {
        if (newState == ProgramState.STOPPED) {
            if (this.shouldAutoStartDefaultProgram()) {
                this.enableTriggering();
            }
        } else if (newState == ProgramState.PLAYING) {
            this.disableTriggering();
        }
    }

    public void stopButtonPushed() {
        DashBoard.stopProgram();
        this.interruptTriggering();
    }

    private void interruptTriggering() {
        if (!this.userInterrupted && this.shouldAutoStartDefaultProgram()) {
            this.resolver.informAutoStartWillBeDisabled();
            Log.info((String)"User interrupted the autostart by pressing stop.");
            this.userInterrupted = true;
        }
    }

    public void startButtonPushed() {
        boolean askForInput;
        boolean bl = askForInput = this.shouldAutoStartDefaultProgram() && this.isUserInterrupted() && (this.programModeHolder.getMode() == ProgramModeHolder.ProgramMode.ReadOnly || this.programModeHolder.getMode() == ProgramModeHolder.ProgramMode.Editable);
        if (askForInput) {
            DashBoard.fanOutProgramState();
            YesNoCancelDialogListener listener = new YesNoCancelDialogListener(){

                public void onNoClicked() {
                    AutoStartDefaultProgram.this.autoStart();
                }

                public void onYesClicked() {
                    AutoStartDefaultProgram.this.autoStart();
                    AutoStartDefaultProgram.togglePlay();
                }
            };
            this.resolver.confirmShouldPlayProgramAfterEnabling(listener);
        } else {
            AutoStartDefaultProgram.togglePlay();
        }
    }

    private void autoStart() {
        Log.info((String)"AutoStartDefaultProgram: Autostart reenabled by pressing start.");
        this.userInterrupted = false;
    }

    private static void togglePlay() {
        if (DashBoard.getProgramState() == ProgramState.STOPPED) {
            DashBoard.play();
        } else if (DashBoard.getProgramState() == ProgramState.PLAYING) {
            DashBoard.pauseProgram();
        } else if (DashBoard.getProgramState() == ProgramState.PAUSED) {
            DashBoard.resume();
        }
    }

    public boolean isUserInterrupted() {
        return this.userInterrupted;
    }

    @Override
    public void resetTriggerValid() {
        this.prevTriggerLevel = -2;
    }

    static {
        AutoStartDefaultProgram.ajc$preClinit();
    }

    static final /* synthetic */ void doAutoStartDefaultProgram_aroundBody0(AutoStartDefaultProgram ajc$this, JoinPoint joinPoint) {
        Log.info((String)"Auto starting program");
        DashBoard.play();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AutoStartDefaultProgram.java", AutoStartDefaultProgram.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doAutoStartDefaultProgram", "com.ur.polyscope.defaultprogram.AutoStartDefaultProgram", "", "", "", "void"), 107);
    }

    public static interface AutoStartResolver {
        public void informAutoStartWillBeDisabled();

        public void confirmShouldPlayProgramAfterEnabling(YesNoCancelDialogListener var1);
    }
}

