/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.defaultprogram;

import com.ur.disk.Directories;
import com.ur.lang.StringUtils;
import com.ur.polyscope.defaultprogram.DefaultProgramSettings;
import com.ur.polyscope.installation.InstallationComponentConversionStrategy;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.PinReference;
import com.ur.util.persist.FileUtils;
import gui.program.services.ProgramReferenceService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

public class DefaultProgramSettingsConverterStrategy
extends ConversionStrategyTemplate<DefaultProgramSettings>
implements InstallationComponentConversionStrategy<DefaultProgramSettings> {
    private static final String DEFAULT_PROGRAM_SETTINGS = "DefaultProgramSettings";
    static final String AUTO_START_PROGRAM_SENSOR = "nameOfSensorToAutoStartProgram";
    private static final String AUTO_START_PROGRAM_SENSOR_TRIGGER_LEVEL = "triggerValueToStartProgram";
    static final String AUTO_INITIALIZE_SENSOR = "nameOfSensorToInitialize";
    private static final String AUTO_INITIALIZE_SENSOR_TRIGGER_LEVEL = "triggerValueToInitialize";
    private static final String FILE_NAME = "fileName";
    private static final String AUTO_LOAD = "autoLoad";
    @Deprecated
    static final String AUTO_START = "autoStart";
    @Deprecated
    static final String AUTO_INIT_ROBOT = "autoInitRobot";
    private Provider<DefaultProgramSettings> defaultProgramSettingsProvider;
    private final ProgramReferenceService programRefService;

    @Inject
    public DefaultProgramSettingsConverterStrategy(Provider<DefaultProgramSettings> defaultProgramSettingsProvider, ProgramReferenceService programRefService) {
        super(DefaultProgramSettings.class);
        this.defaultProgramSettingsProvider = defaultProgramSettingsProvider;
        this.programRefService = programRefService;
    }

    public void marshal(DefaultProgramSettings settings, PersistWriter writer) {
        if (settings.getProgramFile() != null) {
            writer.addAttribute(FILE_NAME, FileUtils.relativize((File)Directories.programs(), (File)settings.getProgramFile()));
        }
        writer.addAttribute(AUTO_LOAD, settings.isLoadProgramOnStartup());
        if (settings.getAutoInitializeSensor() != null) {
            writer.addAttribute(AUTO_INITIALIZE_SENSOR, settings.getAutoInitializeSensor().getKey());
            writer.addAttribute(AUTO_INITIALIZE_SENSOR_TRIGGER_LEVEL, settings.getAutoInitializeSensorValue());
        }
        if (settings.getAutoStartProgramSensor() != null) {
            writer.addAttribute(AUTO_START_PROGRAM_SENSOR, settings.getAutoStartProgramSensor().getKey());
            writer.addAttribute(AUTO_START_PROGRAM_SENSOR_TRIGGER_LEVEL, settings.getAutoStartProgramSensorValue());
        }
    }

    public DefaultProgramSettings unmarshal(PersistReader reader) {
        DefaultProgramSettings settings = (DefaultProgramSettings)this.defaultProgramSettingsProvider.get();
        if (reader.getStringAttribute(FILE_NAME) != null) {
            settings.setProgramFile(new File(Directories.programs(), reader.getStringAttribute(FILE_NAME)));
        }
        settings.setLoadProgramOnStartup(reader.getBooleanAttribute(AUTO_LOAD));
        if (this.loadDataFor(reader, AUTO_INIT_ROBOT)) {
            settings.setAutoInitializeSensor(this.getReference(reader.getStringAttribute(AUTO_INITIALIZE_SENSOR)));
            settings.setAutoInitializeSensorValue(reader.getBooleanAttribute(AUTO_INITIALIZE_SENSOR_TRIGGER_LEVEL));
        }
        if (this.loadDataFor(reader, AUTO_START)) {
            settings.setAutoStartProgramOnInput(this.getReference(reader.getStringAttribute(AUTO_START_PROGRAM_SENSOR)));
            settings.setAutoStartProgramSensorValue(reader.getBooleanAttribute(AUTO_START_PROGRAM_SENSOR_TRIGGER_LEVEL));
        }
        return settings;
    }

    private boolean loadDataFor(PersistReader reader, String autoInitRobot) {
        return reader.hasOneOfAttributes(new String[]{autoInitRobot}) && reader.getBooleanAttribute(autoInitRobot) || !reader.hasOneOfAttributes(new String[]{autoInitRobot});
    }

    protected PinReference getReference(String pinName) {
        if (StringUtils.isNullOrOnlyWhitespace((String)pinName)) {
            return null;
        }
        return this.programRefService.getPinReference(pinName);
    }

    public Map<String, Class<? extends DefaultProgramSettings>> getClassAliases(boolean forMarshalling) {
        return new HashMap<String, Class<? extends DefaultProgramSettings>>(){
            {
                this.put(DefaultProgramSettingsConverterStrategy.DEFAULT_PROGRAM_SETTINGS, DefaultProgramSettings.class);
            }
        };
    }
}

