/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.defaultprogram;

import com.ur.polyscope.defaultprogram.CombinePinEnablement;
import com.ur.polyscope.pin.DefaultInputPinAction;
import com.ur.polyscope.pin.InputActionPin;
import com.ur.polyscope.pin.PinAction;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.Trigger;
import com.ur.polyscope.pin.internal.TextResource;

class PinEnablement
implements PinAction {
    private final Trigger trigger;
    private final String shortName;
    private boolean triggerValue;
    private PinReference inputPin;

    public PinEnablement(String shortName, Trigger trigger) {
        this.shortName = shortName;
        this.trigger = trigger;
    }

    public PinReference getInput() {
        return this.inputPin;
    }

    public void setInput(PinReference reference) {
        this.removePin(this.inputPin);
        this.inputPin = reference;
        this.addPin(reference);
    }

    private void addPin(PinReference reference) {
        if (!this.isActionablePin(reference)) {
            return;
        }
        InputActionPin pin = (InputActionPin)reference.dereference();
        PinAction action = pin.getIOPinAction();
        if (action instanceof PinEnablement) {
            pin.setIOPinAction((PinAction)new CombinePinEnablement(this, (PinEnablement)action));
        } else {
            pin.setIOPinAction((PinAction)this);
        }
    }

    private void removePin(PinReference inputPin) {
        if (!this.isActionablePin(inputPin)) {
            return;
        }
        InputActionPin pin = (InputActionPin)inputPin.dereference();
        PinAction action = pin.getIOPinAction();
        if (action == this) {
            pin.setIOPinAction(DefaultInputPinAction.INPUT_PIN_ACTION_NONE);
        } else if (action instanceof CombinePinEnablement) {
            PinAction toKeep = ((CombinePinEnablement)action).getOtherPin(this);
            pin.setIOPinAction(toKeep);
        }
    }

    private boolean isActionablePin(PinReference inputPin) {
        return inputPin != null && inputPin.dereference() instanceof InputActionPin;
    }

    public void setTriggerValue(boolean sensorValue) {
        this.triggerValue = sensorValue;
    }

    public boolean getTriggerValue() {
        return this.triggerValue;
    }

    public boolean isDefined() {
        if (this.isActionablePin(this.inputPin)) {
            PinAction action = ((InputActionPin)this.inputPin.dereference()).getIOPinAction();
            return action == this || action instanceof CombinePinEnablement;
        }
        return false;
    }

    public void onPress() {
        this.trigger.onPress();
    }

    public void onRelease() {
        this.trigger.onRelease();
    }

    public String getShortFunctionName() {
        return this.shortName;
    }

    public String getLocalizedName(TextResource textResource) {
        return this.shortName;
    }

    public String name() {
        return null;
    }
}

