/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.defaultprogram;

import com.ur.lang.EqualsUtil;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.requirements.AbstractRobotRequirement;
import com.ur.monitor.requirements.FailedRequirementListener;
import com.ur.polyscope.defaultprogram.DefaultProgramSettings;
import com.ur.polyscope.initializerobot.veto.ModeVetoListener;
import com.ur.polyscope.initializerobot.veto.VetoListener;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import gui.tools.DialogCreator;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RequirementToInitializeRobotOnPowerOff
extends AbstractRobotRequirement
implements RobotStateListener {
    RobotMode oldRobotMode;
    private boolean needToNotifyAboutChangeInRobotState;
    private InstallationComponentLookup installationLookupService;
    private final DialogCreator dialogCreator;
    final ModeVetoListener modeVetoListener = this.createModeVetoListener();

    @Inject
    public RequirementToInitializeRobotOnPowerOff(FailedRequirementListener failedRequirementListener, InstallationComponentLookup installationLookupService, DialogCreator dialogCreator) {
        super(failedRequirementListener);
        this.installationLookupService = installationLookupService;
        this.dialogCreator = dialogCreator;
        EventNotificationService.register((Object)((Object)this), VetoListener.class, (Object)this.modeVetoListener);
    }

    protected ModeVetoListener createModeVetoListener() {
        return new ModeVetoListener.Template(VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES){

            public void doClearState() {
                RequirementToInitializeRobotOnPowerOff.this.needToNotifyAboutChangeInRobotState = false;
            }
        };
    }

    public void updateRobotState(RobotState robotState) {
        boolean bl = this.needToNotifyAboutChangeInRobotState = this.needToNotifyAboutChangeInRobotState || RequirementToInitializeRobotOnPowerOff.needToNotifyAboutChangeInRobotState(this.oldRobotMode, robotState.robotMode);
        if (robotState.robotMode.getId() >= RobotMode.POWER_ON.getId()) {
            this.needToNotifyAboutChangeInRobotState = false;
        }
        if (this.oldRobotMode != null && this.needToNotifyAboutChangeInRobotState && this.modeVetoListener.isNotVetoed(VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES)) {
            this.showRobotModeDialogAndSwitchViewIfAppropriate();
        }
        this.oldRobotMode = robotState.robotMode;
    }

    private static boolean needToNotifyAboutChangeInRobotState(RobotMode oldRobotMode, RobotMode newRobotMode) {
        return oldRobotMode != null && newRobotMode.getId() < oldRobotMode.getId();
    }

    void showRobotModeDialogAndSwitchViewIfAppropriate() {
        if (!this.dialogCreator.isShowingADialog() && !this.checkAndNotify()) {
            this.needToNotifyAboutChangeInRobotState = false;
        }
    }

    protected boolean isFulfilled() {
        RobotState robotState = RobotState.getLatestRobotState();
        return ((DefaultProgramSettings)this.installationLookupService.getComponent(DefaultProgramSettings.class)).shouldInitializeRobot() || EqualsUtil.equalsOneOf((Object)robotState.masterSafetyState, (Object[])new SafetyMode[]{SafetyMode.FAULT, SafetyMode.VIOLATION});
    }
}

