/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.defaultprogram;

import com.ur.monitor.RobotState;
import com.ur.monitor.requirements.FailedRequirementListener;
import com.ur.polyscope.defaultprogram.RequirementToInitializeRobotOnPowerOff;
import com.ur.polyscope.initializerobot.veto.ModeVetoListener;
import com.ur.polyscope.initializerobot.veto.VetoListener;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.view.constants.dev.RobotMode;
import gui.installation.RobotInstallationLookupService;
import gui.tools.DialogCreator;
import java.util.Arrays;
import java.util.EnumSet;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RequirementToInitializeRobotOnPowerOffImpl
extends RequirementToInitializeRobotOnPowerOff {
    private final EnumSet<RobotMode> ignoredRobotModes = EnumSet.copyOf(Arrays.asList(RobotMode.CONFIRM_SAFETY, RobotMode.BOOTING, RobotMode.IDLE, RobotMode.BACKDRIVE, RobotMode.RUNNING, RobotMode.UPDATING));

    @Inject
    public RequirementToInitializeRobotOnPowerOffImpl(FailedRequirementListener failedRequirementListener, RobotInstallationLookupService installationLookupService, DialogCreator dialogCreator) {
        super(failedRequirementListener, (InstallationComponentLookup)installationLookupService, dialogCreator);
    }

    @Override
    protected ModeVetoListener createModeVetoListener() {
        return new ModeVetoListener.Template(VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES);
    }

    @Override
    public void updateRobotState(RobotState robotState) {
        boolean shouldShowDialog = this.needToNotifyAboutChangeInRobotState(robotState);
        if (shouldShowDialog && this.modeVetoListener.isNotVetoed(VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES)) {
            this.showRobotModeDialogAndSwitchViewIfAppropriate();
        }
        this.oldRobotMode = robotState.robotMode;
    }

    private boolean needToNotifyAboutChangeInRobotState(RobotState robotState) {
        if (this.oldRobotMode == null) {
            return false;
        }
        if (this.ignoredRobotModes.contains(robotState.robotMode)) {
            return false;
        }
        return robotState.robotMode.getId() < this.oldRobotMode.getId();
    }
}

