/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.defaultprogram;

import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.polyscope.defaultprogram.api.DefaultProgramAPI;
import com.ur.polyscope.defaultprogram.internal.TextResource;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.extensible.AddToViewExtension;
import com.ur.swing.extensible.Extension;
import com.ur.util.event.EventNotificationService;
import com.ur.util.swing.HTML;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

@Extension(value="RunScreen")
public class StartProgramStatusPanel
implements RobotStateListener,
InstallationStateListener,
AddToViewExtension {
    private final TextResource text;
    private final DefaultProgramAPI defaultProgramAPI;
    private final JLabel autoStartEnabled;
    private final JPanel autoStartPanel;
    private boolean registered = false;

    @Inject
    private StartProgramStatusPanel(DefaultProgramAPI defaultProgramAPI, ViewContext viewContext) {
        this.defaultProgramAPI = defaultProgramAPI;
        this.text = (TextResource)viewContext.getTextResource(TextResource.class);
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        this.autoStartEnabled = widgetFactory.createLabel("");
        this.autoStartPanel = widgetFactory.createTitleValuePair(this.text.autoStartProgram(), this.autoStartEnabled);
        this.autoStartPanel.setVisible(false);
        this.updateVisibility();
        this.updateAutoStartText();
        EventNotificationService.register((Object)this.autoStartPanel, InstallationStateListener.class, (Object)this);
    }

    public JComponent create() {
        return this.autoStartPanel;
    }

    public void updateRobotState(RobotState robotState) {
        this.updateAutoStartText();
    }

    private void updateAutoStartText() {
        if (this.defaultProgramAPI.isAutoStartProgramEnabled()) {
            this.autoStartEnabled.setText(HTML.html((String)HTML.h1((String)this.text.enabled())));
        } else {
            this.autoStartEnabled.setText(HTML.html((String)HTML.h1((String)this.text.disabled())));
        }
    }

    public void installationModified() {
        this.updateVisibility();
    }

    public void installationSaved() {
        this.updateVisibility();
    }

    public void installationLoaded(Installation installation) {
        this.updateVisibility();
    }

    public void installationLoadFailed() {
    }

    private void updateVisibility() {
        boolean autoStartProgramConfigured = this.defaultProgramAPI.isAutoStartProgramConfigured();
        if (autoStartProgramConfigured) {
            if (!this.registered) {
                EventNotificationService.register((Object)this.autoStartPanel, RobotStateListener.class, (Object)this);
                this.registered = true;
            }
            this.autoStartPanel.setVisible(true);
        } else if (!autoStartProgramConfigured) {
            if (this.registered) {
                EventNotificationService.unregister((Object)this.autoStartPanel, RobotStateListener.class);
                this.registered = false;
            }
            this.autoStartPanel.setVisible(false);
        }
    }
}

