/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.defaultprogram.api;

import com.ur.disk.Directories;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.defaultprogram.DefaultProgramSettings;
import com.ur.polyscope.defaultprogram.api.DigitalOrBooleanFilter;
import com.ur.polyscope.defaultprogram.internal.TextResource;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FilePersistence;
import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.resources.ViewImageResource;
import com.ur.swing.CardPanel;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.FormBuilder;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.text.TextFieldUtils;
import com.ur.util.CollectionUtils;
import com.ur.util.Predicate;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import com.ur.view.program.filemanager.ProgramFileManagerConfiguration;
import gui.program.services.ProgramReferenceService;
import gui.swing.renderers.PinComboBoxModel;
import gui.swing.renderers.PinRenderingStrategy;
import gui.tools.BoundsPopupMenuListener;
import gui.tools.LanguagePack;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DefaultProgramTab
extends CardPanel {
    public static final String LOAD_PROGRAM_ON_STARTUP_CHECKBOX = "DefaultProgramTab.automaticallyLoadProgramCheckbox";
    public static final String DEFAULT_PROGRAM_TO_LOAD = "DefualtProgramTab.defaultProgramToLoad";
    public static final String START_PROGRAM_INPUT_TRIGGER = "DefaultProgramTab.startProgramInputTrigger";
    public static final String SHOW_DEFAULT_PROGRAM_ACTION = "showDefaultProgramAction.G3DefaultProgramTab";
    private final FilePersistence filePersistence;
    private final InstallationComponentLookup lookupService;
    private final IOService ioService;
    private FileContainer defaultLoadFileContainer = null;
    private final ProgramReferenceService programRefService;
    private JComboBox autoInitializeDigitalInputSelection;
    private JComboBox autoInitializeDigitalValueSelection;
    private JCheckBox enableLoadDefaultProgram;
    private JComboBox autostartProgramOnInput;
    private JComboBox autostartProgramOnEdge;
    private JTextField selectedStartupProgram;
    private final ViewContext viewContext;
    private final TextResource textResource;
    private final HelpIdAssigner helpIdAssigner;

    @Inject
    public DefaultProgramTab(FilePersistence filePersistence, InstallationComponentLookup lookupService, ViewContext viewContext, IOService ioService, ProgramReferenceService programRefService, HelpIdAssigner helpIdAssigner) {
        this.filePersistence = filePersistence;
        this.lookupService = lookupService;
        this.viewContext = viewContext;
        this.ioService = ioService;
        this.programRefService = programRefService;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.helpIdAssigner = helpIdAssigner;
        this.initComponents(viewContext);
        this.assignHelpIds();
        this.assignNamesToWidgets();
        ComboBoxRenderer.bindRenderer((JComboBox)this.autostartProgramOnInput, (RenderingStrategy)new PinRenderingStrategy());
        ComboBoxRenderer.bindRenderer((JComboBox)this.autoInitializeDigitalInputSelection, (RenderingStrategy)new PinRenderingStrategy());
    }

    private void assignNamesToWidgets() {
        this.enableLoadDefaultProgram.setName(LOAD_PROGRAM_ON_STARTUP_CHECKBOX);
        this.selectedStartupProgram.setName(DEFAULT_PROGRAM_TO_LOAD);
        this.autostartProgramOnInput.setName(START_PROGRAM_INPUT_TRIGGER);
    }

    private void assignHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.selectedStartupProgram, "gui:installation_defaultprogram_load");
        this.helpIdAssigner.assignHelpId((JComponent)this.autostartProgramOnInput, "gui:installation_defaultprogram_start");
        this.helpIdAssigner.assignHelpId((JComponent)this.autoInitializeDigitalInputSelection, "gui:installation_autoinitialize_settings");
    }

    public void enter(Object o) {
        super.enter(o);
        if (this.defaultLoadFileContainer != null) {
            File file = this.defaultLoadFileContainer.getFile();
            if (file != null && file.exists()) {
                this.getDefaultProgramSettings().setProgramFile(file);
            }
            this.defaultLoadFileContainer = null;
        }
        this.autostartProgramOnInput.setModel(this.makeComboBoxModel());
        this.autoInitializeDigitalInputSelection.setModel(this.makeComboBoxModel());
        this.updateCard();
        EventNotificationService.register((Object)((Object)this), InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationLoaded(Installation installation) {
                DefaultProgramTab.this.updateCard();
            }
        });
    }

    public Object exit() {
        EventNotificationService.unregister((Object)((Object)this), InstallationStateListener.class);
        return super.exit();
    }

    public void updateCard() {
        DefaultProgramSettings defaultProgramSettings = this.getDefaultProgramSettings();
        this.enableLoadDefaultProgram.setSelected(defaultProgramSettings.isLoadProgramOnStartup());
        File defaultProgramFile = defaultProgramSettings.getProgramFile();
        if (defaultProgramFile != null) {
            try {
                this.selectedStartupProgram.setText(URLDecoder.decode(FileUtils.relativize((File)Directories.programs(), (File)defaultProgramFile), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Log.error((String)"", (Throwable)e);
            }
        } else {
            this.selectedStartupProgram.setText("<" + this.textResource.selectDefaultProgram() + ">");
        }
        boolean loadProgram = defaultProgramSettings.isLoadProgramOnStartup();
        this.autostartProgramOnInput.setEnabled(loadProgram);
        this.autostartProgramOnInput.getModel().setSelectedItem(defaultProgramSettings.getAutoStartProgramSensor());
        this.autostartProgramOnEdge.setSelectedIndex(defaultProgramSettings.getAutoStartProgramSensorValue() ? 1 : 0);
        this.autostartProgramOnEdge.setEnabled(loadProgram && this.isAnInputSignalSelected(this.autostartProgramOnInput));
        this.autoInitializeDigitalInputSelection.getModel().setSelectedItem(defaultProgramSettings.getAutoInitializeSensor());
        this.autoInitializeDigitalValueSelection.setSelectedIndex(defaultProgramSettings.getAutoInitializeSensorValue() ? 1 : 0);
        boolean immiEnabled = ((Immi)this.lookupService.getComponent(Immi.class)).isEnabled();
        BoundsPopupMenuListener.enableOnComboBox((JComboBox)this.autoInitializeDigitalInputSelection, (boolean)immiEnabled);
    }

    private boolean isAnInputSignalSelected(JComboBox inputSignalCombobox) {
        Object selectedInput = inputSignalCombobox.getModel().getSelectedItem();
        return !(selectedInput instanceof String);
    }

    private void initComponents(ViewContext view) {
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout(5, 5));
        this.enableLoadDefaultProgram = new JCheckBox(this.textResource.loadDefaultProgram());
        this.enableLoadDefaultProgram.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DefaultProgramSettings settings = (DefaultProgramSettings)DefaultProgramTab.this.lookupService.getComponent(DefaultProgramSettings.class);
                if (settings.isLoadProgramOnStartup() != DefaultProgramTab.this.enableLoadDefaultProgram.isSelected()) {
                    settings.setLoadProgramOnStartup(DefaultProgramTab.this.enableLoadDefaultProgram.isSelected());
                    DefaultProgramTab.this.updateCard();
                }
            }
        });
        this.selectedStartupProgram = new SelectStartProgram();
        this.autostartProgramOnInput = new JComboBox(this.makeComboBoxModel());
        this.autostartProgramOnInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultProgramTab.this.autostartDefaultProgramDigitalInputSelectionActionPerformed();
            }
        });
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(((com.ur.i18n.TextResource)this.viewContext.getTextResource(com.ur.i18n.TextResource.class)).tokenDigitalLo());
        model.addElement(((com.ur.i18n.TextResource)this.viewContext.getTextResource(com.ur.i18n.TextResource.class)).tokenDigitalHi());
        this.autostartProgramOnEdge = new JComboBox(model);
        this.autostartProgramOnEdge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultProgramTab.this.autostartDefaultProgramDigitalValueSelectionActionPerformed();
            }
        });
        JPanel programStartup = view.createFormBuilder().description(this.textResource.defaultProgramFileExplanation(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().component((JComponent)this.enableLoadDefaultProgram, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().component((JComponent)this.selectedStartupProgram, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).end().end().label(this.textResource.autoStartDefaultProgram(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().label(this.textResource.on(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT}).component((JComponent)this.autostartProgramOnInput, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).label(this.textResource.edgeTo(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT}).component((JComponent)this.autostartProgramOnEdge, new FormBuilder.PanelConstraints[0]).end().end().end().label(ViewImageResource.formWarning(), this.textResource.autoStartWarning(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().label(this.textResource.onlyAvailableInRemoteControlMode(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().getCardPanel(this.textResource.defaultProgramFileTitle());
        this.autoInitializeDigitalInputSelection = new JComboBox(this.makeComboBoxModel());
        this.autoInitializeDigitalInputSelection.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        this.autoInitializeDigitalInputSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultProgramTab.this.autoInitializeDigitalInputSelectionActionPerformed();
            }
        });
        DefaultComboBoxModel<String> autoInitializeDigitalValueModel = new DefaultComboBoxModel<String>();
        autoInitializeDigitalValueModel.addElement(((com.ur.i18n.TextResource)this.viewContext.getTextResource(com.ur.i18n.TextResource.class)).tokenDigitalLo());
        autoInitializeDigitalValueModel.addElement(((com.ur.i18n.TextResource)this.viewContext.getTextResource(com.ur.i18n.TextResource.class)).tokenDigitalHi());
        this.autoInitializeDigitalValueSelection = new JComboBox(autoInitializeDigitalValueModel);
        this.autoInitializeDigitalValueSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultProgramTab.this.autoInitializeDigitalValueSelectionActionPerformed();
            }
        });
        JPanel autoInitialize = view.createFormBuilder().description(this.textResource.autoInitializeExplanation(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().end().label(this.textResource.autoInitializeCheckbox(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().label(this.textResource.on(), new FormBuilder.PanelConstraints[0]).component((JComponent)this.autoInitializeDigitalInputSelection, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).label(this.textResource.edgeTo(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT}).component((JComponent)this.autoInitializeDigitalValueSelection, new FormBuilder.PanelConstraints[0]).end().end().label(ViewImageResource.formWarning(), this.textResource.autoInitializeWarning(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().label(this.textResource.onlyAvailableInRemoteControlMode(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().getCardPanel(this.textResource.autoInitializeTitle());
        this.add(view.createWidgetFactory().createInfoMessagePanel(this.textResource.saveBeforeChangesTakeEffect()), "North");
        this.add(programStartup, "Center");
        this.add(autoInitialize, "South");
    }

    private DefaultProgramSettings getDefaultProgramSettings() {
        return (DefaultProgramSettings)this.lookupService.getComponent(DefaultProgramSettings.class);
    }

    private void autostartDefaultProgramDigitalValueSelectionActionPerformed() {
        DefaultProgramSettings defaultProgramSettings;
        boolean digitalValue = this.autostartProgramOnEdge.getSelectedIndex() == 1;
        if (digitalValue != (defaultProgramSettings = this.getDefaultProgramSettings()).getAutoStartProgramSensorValue()) {
            defaultProgramSettings.setAutoStartProgramSensorValue(digitalValue);
        }
    }

    private void autostartDefaultProgramDigitalInputSelectionActionPerformed() {
        DefaultProgramSettings defaultProgramSettings = this.getDefaultProgramSettings();
        PinReference savedDigitalSensor = defaultProgramSettings.getAutoStartProgramSensor();
        Object selection = this.autostartProgramOnInput.getModel().getSelectedItem();
        if (selection instanceof Pin) {
            PinReference selectedDigitalSensor = this.programRefService.getPinReference((Pin)selection);
            if (!selectedDigitalSensor.equals((Object)savedDigitalSensor)) {
                defaultProgramSettings.setAutoStartProgramOnInput(selectedDigitalSensor);
            }
            this.autostartProgramOnEdge.setEnabled(true);
        } else if (selection instanceof String) {
            if (savedDigitalSensor != null) {
                defaultProgramSettings.setAutoStartProgramOnInput(null);
            }
            this.autostartProgramOnEdge.setEnabled(false);
        }
    }

    private void autoInitializeDigitalValueSelectionActionPerformed() {
        DefaultProgramSettings defaultProgramSettings;
        boolean digitalValue = this.autoInitializeDigitalValueSelection.getSelectedIndex() == 1;
        if (digitalValue != (defaultProgramSettings = this.getDefaultProgramSettings()).getAutoInitializeSensorValue()) {
            defaultProgramSettings.setAutoInitializeSensorValue(digitalValue);
        }
    }

    private void autoInitializeDigitalInputSelectionActionPerformed() {
        DefaultProgramSettings defaultProgramSettings = this.getDefaultProgramSettings();
        PinReference savedDigitalSensor = defaultProgramSettings.getAutoInitializeSensor();
        Object selection = this.autoInitializeDigitalInputSelection.getModel().getSelectedItem();
        if (selection instanceof Pin) {
            PinReference selectedDigitalSensor = this.programRefService.getPinReference((Pin)selection);
            if (!selectedDigitalSensor.equals((Object)savedDigitalSensor)) {
                defaultProgramSettings.setAutoInitializeSensor(selectedDigitalSensor);
            }
            this.autoInitializeDigitalValueSelection.setEnabled(true);
        } else if (!this.isAnInputSignalSelected(this.autoInitializeDigitalInputSelection)) {
            if (savedDigitalSensor != null) {
                defaultProgramSettings.setAutoInitializeSensor(null);
            }
            this.autoInitializeDigitalValueSelection.setEnabled(false);
        }
    }

    public CustomPinComboBoxModel makeComboBoxModel() {
        List digitalOrBooleanRegisterInputPins = CollectionUtils.filter((Iterable)this.ioService.getAllInputs(), (Predicate)new DigitalOrBooleanFilter());
        return new CustomPinComboBoxModel(digitalOrBooleanRegisterInputPins);
    }

    private class CustomPinComboBoxModel
    extends PinComboBoxModel {
        public CustomPinComboBoxModel(List<Pin<?>> inputPins) {
            this.addElement(DefaultProgramTab.this.textResource.selectDigitalInput());
            for (Pin<?> each : inputPins) {
                this.addElement(each);
            }
        }

        public void setSelectedItem(Object toSelect) {
            if (toSelect == null) {
                super.setSelectedItem(this.getElementAt(0));
            } else if (toSelect instanceof PinReference) {
                PinReference pinReference = (PinReference)toSelect;
                String pinName = pinReference.getKey();
                int i = 0;
                while (i < this.getSize()) {
                    Pin eachPin;
                    Object eachElement = this.getElementAt(i);
                    if (eachElement instanceof Pin) {
                        eachPin = (Pin)eachElement;
                        if (EqualsUtil.equalsOneOf((Object)pinName, (Object[])new String[]{eachPin.getName(), eachPin.getDefaultName()})) {
                            this.setSelectedItem(eachPin);
                            return;
                        }
                    } else if (eachElement instanceof PinReference && (eachPin = ((PinReference)eachElement).dereference()) != null && EqualsUtil.equals((Object)pinName, (Object)eachPin.getDefaultName())) {
                        this.setSelectedItem(eachPin);
                        return;
                    }
                    ++i;
                }
                super.insertElementAt(toSelect, 1);
                super.setSelectedItem(toSelect);
            } else {
                super.setSelectedItem(toSelect);
            }
        }
    }

    private class SelectStartProgram
    extends JTextField
    implements MouseListener {
        SelectStartProgram() {
            this.setFocusable(false);
            this.setBackground(this.getBackground());
            TextFieldUtils.bindGhostText((JTextField)this, (String)("<" + DefaultProgramTab.this.textResource.selectDefaultProgram() + ">"));
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DefaultProgramTab.this.defaultLoadFileContainer = new FileContainer();
            DefaultProgramTab.this.filePersistence.openFile(DefaultProgramTab.this.defaultLoadFileContainer, (FileManagerConfiguration)new ProgramFileManagerConfiguration(LanguagePack.getTextResource().loadProgram()));
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

