/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.valueobjects.NumberValue;
import com.ur.polyscope.valueobjects.UnknownUnitType;
import com.ur.urcap.api.domain.value.simple.MomentOfInertia;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class MomentOfInertia
implements NumberValue<MomentOfInertia.Unit>,
com.ur.urcap.api.domain.value.simple.MomentOfInertia {
    private static final double KG_M_SQ_EPSILON = 1.0E-6;
    public static final MomentOfInertia ZERO = MomentOfInertia.create(0.0, Unit.SI);
    private final double measureInSi;

    private MomentOfInertia(double measure) {
        this.measureInSi = measure;
    }

    public boolean equals(Object obj) {
        if (obj == null || !MomentOfInertia.class.equals(obj.getClass())) {
            return false;
        }
        MomentOfInertia other = (MomentOfInertia)obj;
        return EqualsUtil.equals((double)this.measureInSi, (double)other.measureInSi, (double)1.0E-6);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.measureInSi).toHashCode();
    }

    public String toString() {
        return String.valueOf(this.measureInSi) + " kg m2";
    }

    public static MomentOfInertia create(double value, Unit unit) {
        return new MomentOfInertia(unit.unConvert(value));
    }

    @Override
    public double asDouble() {
        return this.measureInSi;
    }

    @Override
    public Object createNewInstance(String value, MomentOfInertia.Unit unit) {
        return MomentOfInertia.from(Double.parseDouble(value), unit);
    }

    @Override
    public double getAs(MomentOfInertia.Unit unit) {
        return Unit.internal(unit).convert(this.measureInSi);
    }

    public double toUnit(Unit desiredUnit) {
        return desiredUnit.convert(this.measureInSi);
    }

    public static com.ur.urcap.api.domain.value.simple.MomentOfInertia from(double amountInSI, MomentOfInertia.Unit unit) {
        return new MomentOfInertia(Unit.internal(unit).unConvert(amountInSI));
    }

    public static enum Unit {
        KG_M2(1.0),
        LBF_FT2(23.7529691211);

        public static final Unit SI;
        private final double toUnit;

        static {
            SI = KG_M2;
        }

        private Unit(double multiplySiMeasureBy) {
            this.toUnit = multiplySiMeasureBy;
        }

        private double convert(double measureInSi) {
            return measureInSi * this.toUnit;
        }

        private double unConvert(double measureInUnit) {
            return measureInUnit / this.toUnit;
        }

        public static Unit internal(MomentOfInertia.Unit unit) {
            switch (unit) {
                case KG_M2: {
                    return KG_M2;
                }
                case LB_FT2: {
                    return LBF_FT2;
                }
            }
            throw new UnknownUnitType(unit);
        }
    }
}

