/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.aspects;

import com.google.inject.Inject;
import com.ur.exception.CustomUncaughtExceptionHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public abstract class AbstractArgumentInterceptor
extends SecurityManager
implements MethodInterceptor {
    private Class<? extends Annotation> annotationClass;
    private CustomUncaughtExceptionHandler exceptionHandler;

    public AbstractArgumentInterceptor(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    @Inject(optional=true)
    public void setCustomExceptionHandler(CustomUncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected abstract boolean isArgumentValid(Object var1);

    protected abstract String createExceptionMessage(Method var1, Class var2, int var3);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] arguments = invocation.getArguments();
        if (arguments.length == 0) {
            return invocation.proceed();
        }
        Annotation[][] parameterAnnotations = invocation.getMethod().getParameterAnnotations();
        int i = 0;
        while (i < parameterAnnotations.length) {
            if (!this.isArgumentValid(arguments[i])) {
                this.throwExceptionForArgument(i, invocation);
            }
            ++i;
        }
        return invocation.proceed();
    }

    private void throwExceptionForArgument(int i, MethodInvocation invocation) {
        Annotation[] annotations;
        Annotation[][] parameterAnnotations = invocation.getMethod().getParameterAnnotations();
        Annotation[] annotationArray = annotations = parameterAnnotations[i];
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType() == this.annotationClass) {
                Class<?>[] parameterTypes = invocation.getMethod().getParameterTypes();
                String className = invocation.getMethod().getDeclaringClass().getName();
                String interfaceName = AbstractArgumentInterceptor.getInterfaceNameFromMethod(invocation.getMethod());
                IllegalArgumentException exception = this.createException(invocation.getMethod(), parameterTypes[i], i + 1, className, interfaceName);
                if (this.exceptionHandler != null) {
                    this.exceptionHandler.setStackTraceClassesForThrowable((Class[])this.getClassContext(), (Throwable)exception);
                }
                throw exception;
            }
            ++n2;
        }
    }

    private IllegalArgumentException createException(Method method, Class parameterType, int parameterNumber, String className, String interfaceName) {
        String exceptionMessage = this.createExceptionMessage(method, parameterType, parameterNumber);
        IllegalArgumentException exception = new IllegalArgumentException(exceptionMessage);
        exception.setStackTrace(AbstractArgumentInterceptor.createStackTraceWithoutTopFour(exception.getStackTrace(), className, interfaceName));
        return exception;
    }

    private static String getInterfaceNameFromMethod(Method method) {
        Class<?>[] interfaces = method.getDeclaringClass().getInterfaces();
        String interfaceName = method.getDeclaringClass().getName();
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            if (AbstractArgumentInterceptor.isMethodInClass(method, cls)) {
                interfaceName = cls.getName();
                break;
            }
            ++n2;
        }
        return interfaceName;
    }

    private static boolean isMethodInClass(Method method, Class<?> cls) {
        try {
            cls.getMethod(method.getName(), method.getParameterTypes());
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private static synchronized StackTraceElement[] createStackTraceWithoutTopFour(StackTraceElement[] originalStackTrace, String replaceClass, String withClass) {
        int depth;
        if (originalStackTrace != null && (depth = originalStackTrace.length - 4) > 0) {
            StackTraceElement[] stackTrace = new StackTraceElement[depth];
            int i = 0;
            while (i < depth) {
                stackTrace[i] = AbstractArgumentInterceptor.getAdjustedStackTraceElement(i, originalStackTrace, replaceClass, withClass);
                ++i;
            }
            return stackTrace;
        }
        return originalStackTrace;
    }

    private static StackTraceElement getAdjustedStackTraceElement(int i, StackTraceElement[] originalStackTrace, String replaceClass, String withClass) {
        StackTraceElement stackTraceElement = originalStackTrace[i + 4];
        if (replaceClass.equals(stackTraceElement.getClassName())) {
            stackTraceElement = new StackTraceElement(withClass, stackTraceElement.getMethodName(), "", 0);
        }
        return stackTraceElement;
    }
}

