/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.aspects;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class InterceptionUtils {
    public static Object intercept(final ProceedingJoinPoint joinPoint, MethodInterceptor interceptor) throws Throwable {
        if (interceptor != null) {
            return interceptor.invoke((MethodInvocation)new MethodInvocationAdapter((JoinPoint)joinPoint){

                @Override
                public Object proceed() throws Throwable {
                    return joinPoint.proceed();
                }
            });
        }
        return joinPoint.proceed();
    }

    private static abstract class MethodInvocationAdapter
    implements MethodInvocation {
        private final JoinPoint joinPoint;

        public MethodInvocationAdapter(JoinPoint joinPoint) {
            this.joinPoint = joinPoint;
        }

        public Object[] getArguments() {
            return this.joinPoint.getArgs();
        }

        public abstract Object proceed() throws Throwable;

        public Object getThis() {
            return this.joinPoint.getThis();
        }

        public AccessibleObject getStaticPart() {
            return this.getMethod();
        }

        public Method getMethod() {
            return ((MethodSignature)this.joinPoint.getSignature()).getMethod();
        }
    }
}

