/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.aspects;

import com.ur.polyscope.valueobjects.aspects.AbstractArgumentInterceptor;
import com.ur.polyscope.valueobjects.validation.StringNotNullOrEmpty;
import java.lang.reflect.Method;

public class StringNotNullOrEmptyInterceptor
extends AbstractArgumentInterceptor {
    public StringNotNullOrEmptyInterceptor() {
        super(StringNotNullOrEmpty.class);
    }

    @Override
    protected boolean isArgumentValid(Object object) {
        if (object != null && object instanceof String) {
            return !((String)object).isEmpty();
        }
        return false;
    }

    @Override
    protected String createExceptionMessage(Method method, Class parameterType, int parameterNumber) {
        return "Null or empty String is not accepted as argument for parameter number " + parameterNumber + " of type " + parameterType.getSimpleName() + " in method " + method.getName();
    }
}

