/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.converters;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.converters.Units;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import java.text.Format;

class AccelerationConverter
implements ValueConverter<String, Acceleration> {
    private final boolean forceSiUnits;

    AccelerationConverter(boolean forceSiUnits) {
        this.forceSiUnits = forceSiUnits;
    }

    public Acceleration fromGui(String guiValue) {
        double value = PrimitiveUtils.parseDouble((String)guiValue, (double)0.0);
        if (this.forceSiUnits) {
            return Acceleration.from(value, Acceleration.Unit.SI);
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return Acceleration.from(value, Acceleration.Unit.INCH_S2);
        }
        return Acceleration.from(value, Acceleration.Unit.MM_S2);
    }

    public String fromModel(Acceleration modelValue) {
        if (this.forceSiUnits) {
            return String.valueOf(modelValue.getIn(Acceleration.Unit.SI));
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return String.valueOf(modelValue.getIn(Acceleration.Unit.INCH_S2));
        }
        return String.valueOf(modelValue.getIn(Acceleration.Unit.MM_S2));
    }

    public String getUnit() {
        if (this.forceSiUnits) {
            return Units.getSiText().unitMS2();
        }
        return Units.getText().unitMmS2();
    }

    public Format getFormat() {
        if (this.forceSiUnits) {
            return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.000");
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.00");
        }
        return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0");
    }
}

