/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.converters;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.valueobjects.Angle;
import com.ur.polyscope.valueobjects.converters.Units;
import com.ur.swing.units.ValueConverter;
import java.text.Format;

class AngleConverter
implements ValueConverter<String, Angle> {
    private boolean forceSiUnits;

    AngleConverter(boolean forceSIUnits) {
        this.forceSiUnits = forceSIUnits;
    }

    public Angle fromGui(String guiValue) {
        double value = PrimitiveUtils.parseDouble((String)guiValue, (double)0.0);
        if (this.forceSiUnits) {
            return Angle.from(value, Angle.Unit.SI);
        }
        return Angle.from(value, Angle.Unit.DEGREES);
    }

    public String fromModel(Angle modelValue) {
        if (this.forceSiUnits) {
            return String.valueOf(modelValue.getIn(Angle.Unit.SI));
        }
        return String.valueOf(modelValue.getIn(Angle.Unit.DEGREES));
    }

    public String getUnit() {
        return this.forceSiUnits ? Units.getSiText().unitRad() : Units.getText().unitDegrees();
    }

    public Format getFormat() {
        if (this.forceSiUnits) {
            return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.000");
        }
        return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.00");
    }
}

