/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.converters;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.valueobjects.Force;
import com.ur.polyscope.valueobjects.converters.Units;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import java.text.Format;

class ForceConverter
implements ValueConverter<String, Force> {
    private final boolean forceSiUnits;

    ForceConverter(boolean forceSiUnits) {
        this.forceSiUnits = forceSiUnits;
    }

    public Force fromGui(String guiValue) {
        double value = PrimitiveUtils.parseDouble((String)guiValue, (double)0.0);
        if (UnitsValueConverterFactory.unitType.isUS() && !this.forceSiUnits) {
            return Force.from(value, Force.Unit.LB);
        }
        return Force.from(value, Force.Unit.N);
    }

    public String fromModel(Force modelValue) {
        if (UnitsValueConverterFactory.unitType.isUS() && !this.forceSiUnits) {
            return String.valueOf(modelValue.getIn(Force.Unit.LB));
        }
        return String.valueOf(modelValue.getIn(Force.Unit.N));
    }

    public String getUnit() {
        if (this.forceSiUnits) {
            return Units.getSiText().unitN();
        }
        return Units.getText().unitN();
    }

    public Format getFormat() {
        return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.0");
    }
}

