/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.converters;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.converters.Units;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import java.text.Format;

class LengthConverter
implements ValueConverter<String, Length> {
    private final boolean forceSiUnits;

    LengthConverter(boolean forceSiUnits) {
        this.forceSiUnits = forceSiUnits;
    }

    public Length fromGui(String guiValue) {
        double value = PrimitiveUtils.parseDouble((String)guiValue, (double)0.0);
        if (this.forceSiUnits) {
            return Length.from(value, Length.Unit.SI);
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return Length.from(value, Length.Unit.INCH);
        }
        return Length.from(value, Length.Unit.MM);
    }

    public String fromModel(Length modelValue) {
        if (this.forceSiUnits) {
            return String.valueOf(modelValue.getIn(Length.Unit.SI));
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return String.valueOf(modelValue.getIn(Length.Unit.INCH));
        }
        return String.valueOf(modelValue.getIn(Length.Unit.MM));
    }

    public String getUnit() {
        if (this.forceSiUnits) {
            return Units.getSiText().unitMm();
        }
        return Units.getText().unitMm();
    }

    public Format getFormat() {
        if (this.forceSiUnits) {
            return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.00");
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.0000");
        }
        return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.00");
    }
}

