/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.converters;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.valueobjects.MomentOfInertia;
import com.ur.polyscope.valueobjects.converters.Units;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import java.text.Format;

public final class MomentOfInertiaConverter
implements ValueConverter<String, MomentOfInertia> {
    private final boolean forceSiUnits;

    MomentOfInertiaConverter(boolean forceSiUnits) {
        this.forceSiUnits = forceSiUnits;
    }

    public MomentOfInertia fromGui(String guiValue) {
        double value = PrimitiveUtils.parseDouble((String)guiValue, (double)0.0);
        if (UnitsValueConverterFactory.unitType.isUS() && !this.forceSiUnits) {
            return MomentOfInertia.create(value, MomentOfInertia.Unit.LBF_FT2);
        }
        return MomentOfInertia.create(value, MomentOfInertia.Unit.KG_M2);
    }

    public String fromModel(MomentOfInertia modelValue) {
        if (UnitsValueConverterFactory.unitType.isUS() && !this.forceSiUnits) {
            return String.valueOf(modelValue.toUnit(MomentOfInertia.Unit.LBF_FT2));
        }
        return String.valueOf(modelValue.toUnit(MomentOfInertia.Unit.KG_M2));
    }

    public String getUnit() {
        if (this.forceSiUnits) {
            return Units.getSiText().unitKgM2();
        }
        return Units.getText().unitLbFt2();
    }

    public Format getFormat() {
        if (UnitsValueConverterFactory.unitType.isUS() && !this.forceSiUnits) {
            return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.000000");
        }
        return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.000000");
    }
}

