/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.converters;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.valueobjects.Momentum;
import com.ur.polyscope.valueobjects.converters.Units;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import java.text.Format;

class MomentumConverter
implements ValueConverter<String, Momentum> {
    private final boolean forceSiUnits;

    MomentumConverter(boolean forceSiUnits) {
        this.forceSiUnits = forceSiUnits;
    }

    public Momentum fromGui(String guiValue) {
        double value = PrimitiveUtils.parseDouble((String)guiValue, (double)0.0);
        if (UnitsValueConverterFactory.unitType.isUS() && !this.forceSiUnits) {
            return Momentum.create(value, Momentum.Unit.LBS_INCHES_PER_SECOND);
        }
        return Momentum.create(value, Momentum.Unit.KG_METERS_PER_SECOND);
    }

    public String fromModel(Momentum modelValue) {
        if (UnitsValueConverterFactory.unitType.isUS() && !this.forceSiUnits) {
            return String.valueOf(modelValue.toUnit(Momentum.Unit.LBS_INCHES_PER_SECOND));
        }
        return String.valueOf(modelValue.toUnit(Momentum.Unit.KG_METERS_PER_SECOND));
    }

    public String getUnit() {
        if (this.forceSiUnits) {
            return Units.getSiText().unitKgMS();
        }
        return Units.getText().unitKgMS();
    }

    public Format getFormat() {
        if (UnitsValueConverterFactory.unitType.isUS() && !this.forceSiUnits) {
            return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0");
        }
        return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.0");
    }
}

